/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.apm.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.packagedrone.sec.service.apm.model.UserEntity;
import org.eclipse.packagedrone.sec.service.apm.model.UserNotFoundException;

public class UserWriteModel {
    private final Map<String, UserEntity> userMap;
    private final Map<String, UserEntity> userMailMap;
    private boolean changed;

    public UserWriteModel() {
        this.userMap = new HashMap<String, UserEntity>();
        this.userMailMap = new HashMap<String, UserEntity>();
    }

    public UserWriteModel(Collection<UserEntity> users, boolean clone) {
        this.userMap = new HashMap<String, UserEntity>(users.size());
        this.userMailMap = new HashMap<String, UserEntity>(users.size());
        for (UserEntity user : users) {
            UserEntity newUser = clone ? new UserEntity(user) : user;
            this.userMap.put(user.getId(), newUser);
            if (newUser.getEmail() == null) continue;
            this.userMailMap.put(newUser.getEmail(), newUser);
        }
    }

    public UserWriteModel(UserWriteModel other) {
        this(other.userMap.values(), true);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public Collection<UserEntity> asCollection() {
        return Collections.unmodifiableCollection(this.userMap.values());
    }

    public Map<String, UserEntity> getAll() {
        return Collections.unmodifiableMap(this.userMap);
    }

    public Optional<UserEntity> getUser(String userId) {
        return Optional.ofNullable(this.userMap.get(userId));
    }

    public Optional<UserEntity> findByEmail(String email) {
        return Optional.ofNullable(this.userMailMap.get(email));
    }

    public UserEntity getCheckedUser(String userId) {
        return this.getUser(userId).orElseThrow(() -> new UserNotFoundException());
    }

    public void putUser(UserEntity user) {
        if (user.getId() == null) {
            throw new IllegalArgumentException("User has no ID assigned");
        }
        this.changed = true;
        this.userMap.put(user.getId(), user);
        if (user.getEmail() != null) {
            this.userMailMap.put(user.getEmail(), user);
        }
    }

    public boolean removeUser(String userId) {
        this.changed = true;
        return this.userMap.remove(userId) != null;
    }
}

