/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.apm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.packagedrone.sec.DatabaseUserInformation;
import org.eclipse.packagedrone.sec.service.apm.Helper;
import org.eclipse.packagedrone.sec.service.apm.model.UserEntity;

public class UserModel {
    private final Map<String, DatabaseUserInformation> users;
    private final Map<String, DatabaseUserInformation> usersByEmail;
    private final List<DatabaseUserInformation> allUsers;

    public UserModel(Collection<UserEntity> users) {
        this.users = new HashMap<String, DatabaseUserInformation>(users.size());
        this.usersByEmail = new HashMap<String, DatabaseUserInformation>(users.size());
        ArrayList<DatabaseUserInformation> allUsers = new ArrayList<DatabaseUserInformation>(users.size());
        for (UserEntity user : users) {
            DatabaseUserInformation dui = new DatabaseUserInformation(user.getId(), null, user.getRoles(), Helper.toDetails(user));
            this.users.put(user.getId(), dui);
            String email = user.getEmail();
            if (email != null) {
                this.usersByEmail.put(email, dui);
            }
            allUsers.add(dui);
        }
        this.allUsers = Collections.unmodifiableList(allUsers);
    }

    public Optional<DatabaseUserInformation> getUser(String userId) {
        return Optional.ofNullable(this.users.get(userId));
    }

    public Optional<DatabaseUserInformation> findUserByEmail(String email) {
        return Optional.ofNullable(this.usersByEmail.get(email));
    }

    public List<DatabaseUserInformation> listAll() {
        return this.allUsers;
    }

    public boolean isEmpty() {
        return this.users.isEmpty();
    }
}

