/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.manage.system.SitePrefixService;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
public class MavenController
implements InterfaceExtender {
    private ChannelService service;
    private SitePrefixService sitePrefixService;

    public void setService(ChannelService service) {
        this.service = service;
    }

    public void setSitePrefixService(SitePrefixService sitePrefixService) {
        this.sitePrefixService = sitePrefixService;
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        if (object instanceof ChannelInformation) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            ChannelInformation channel = (ChannelInformation)object;
            if (channel.hasAspect("maven.repo")) {
                result.add(new MenuEntry("Maven Repository", 20000, new LinkTarget("/maven/" + channel.getId()), Modifier.LINK, null));
            }
            return result;
        }
        return null;
    }

    public List<MenuEntry> getViews(HttpServletRequest request, Object object) {
        if (object instanceof ChannelInformation) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            ChannelInformation channel = (ChannelInformation)object;
            HashMap<String, String> model = new HashMap<String, String>(1);
            model.put("channelId", channel.getId());
            result.add(new MenuEntry("Help", Integer.MAX_VALUE, "Maven", 2000, LinkTarget.createFromController(MavenController.class, (String)"help").expand(model), Modifier.LINK, "info-sign"));
            return result;
        }
        return null;
    }

    @RequestMapping(value={"/channel/{channelId}/help.maven"})
    public ModelAndView help(@PathVariable(value="channelId") String channelId) {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("mavenRepo", channel.hasAspect("maven.repo"));
            model.put("channel", channel.getInformation());
            model.put("deployGroups", this.service.getChannelDeployGroups(ChannelService.By.id((String)channelId)).orElse(Collections.emptyList()));
            model.put("sitePrefix", this.sitePrefixService.getSitePrefix());
            return new ModelAndView("helpMaven", model);
        });
    }
}

