/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.core;

import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.manage.core.CoreHelper;
import org.eclipse.packagedrone.repo.manage.core.CoreService;
import org.eclipse.packagedrone.sec.service.password.BadPasswordException;
import org.eclipse.packagedrone.sec.service.password.PasswordChecker;

public class CorePasswordChecker
implements PasswordChecker {
    private static final MetaKey KEY_MIN_PASSWORD_LENGTH = new MetaKey("core", "min-password-length");
    private static final int DEFAULT_MIN_LENGTH = 6;
    private CoreService service;

    public void setService(CoreService service) {
        this.service = service;
    }

    public void checkPassword(String password) throws BadPasswordException {
        int minLength = CoreHelper.getInteger((CoreService)this.service, (MetaKey)KEY_MIN_PASSWORD_LENGTH, (int)6);
        if (minLength <= 0) {
            minLength = 6;
        }
        this.checkPassword(password, minLength);
    }

    private void checkPassword(String password, int minLength) throws BadPasswordException {
        if (password == null) {
            throw new BadPasswordException("Password must not be empty");
        }
        if (password.length() < minLength) {
            throw new BadPasswordException(String.format("Password  must be at least %s characters long", minLength));
        }
    }
}

