/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.dispatcher.internal;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.packagedrone.web.dispatcher.internal.ResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagDirTracker
implements ResourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(TagDirTracker.class);
    private final BundleTracker<TagDirInfo> bundleTracker;
    private final BundleTrackerCustomizer<TagDirInfo> customizer = new BundleTrackerCustomizer<TagDirInfo>(){

        public TagDirInfo addingBundle(Bundle bundle, BundleEvent event) {
            return TagDirTracker.this.createTagLibInfo(bundle);
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, TagDirInfo object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, TagDirInfo object) {
        }
    };

    public TagDirTracker(BundleContext context) {
        this.bundleTracker = new BundleTracker(context, 36, this.customizer);
        this.bundleTracker.open();
    }

    protected TagDirInfo createTagLibInfo(Bundle bundle) {
        logger.trace("Checking for tag dir directories: {}", (Object)bundle);
        String tld = (String)bundle.getHeaders().get("Web-TagLib-Directory");
        if (tld != null) {
            TagDirInfo result = new TagDirInfo(bundle, tld);
            logger.debug("Found tag directory: {}", (Object)result);
            return result;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.bundleTracker.close();
    }

    @Override
    public URL getResource(String name) {
        logger.trace("Getting tag dir for: {}", (Object)name);
        for (TagDirInfo tli : this.bundleTracker.getTracked().values()) {
            if (!name.startsWith(tli.getPrefix())) continue;
            logger.trace("Trying {} for {}", (Object)tli, (Object)name);
            URL result = tli.getBundle().getEntry(name);
            if (result == null) continue;
            logger.trace("Using {} for {}", (Object)tli, (Object)name);
            return result;
        }
        return null;
    }

    @Override
    public Set<String> getPaths(String name) {
        logger.trace("Getting url for: {}", (Object)name);
        HashSet<String> result = new HashSet<String>();
        for (TagDirInfo tli : this.bundleTracker.getTracked().values()) {
            URL url;
            if (!tli.getPrefix().equals(name) || (url = tli.getUrl()) == null) continue;
            result.addAll(tli.getDirectoryUrls());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Result: {}", result);
        }
        return result;
    }

    private static class TagDirInfo {
        private final String prefix;
        private final Bundle bundle;

        public TagDirInfo(Bundle bundle, String prefix) {
            this.bundle = bundle;
            this.prefix = prefix;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public URL getUrl() {
            return this.bundle.getEntry(this.prefix);
        }

        public List<String> getDirectoryUrls() {
            LinkedList<String> result = new LinkedList<String>();
            Enumeration en = this.bundle.getEntryPaths(this.prefix);
            while (en.hasMoreElements()) {
                result.add("/" + (String)en.nextElement());
            }
            return result;
        }

        public String toString() {
            return String.format("[TagDir - prefix: %s, bundle: %s]", this.prefix, this.bundle);
        }
    }
}

