/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.dispatcher;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.equinox.jsp.jasper.JspServlet;
import org.eclipse.packagedrone.web.dispatcher.Dispatcher;
import org.eclipse.packagedrone.web.dispatcher.DispatcherHttpContext;
import org.eclipse.packagedrone.web.dispatcher.ServletWrapper;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public abstract class JspServletInitializer {
    private WebContainer httpService;
    private DispatcherHttpContext webctx;
    private JspServlet jspServlet;
    private final String alias;
    private Servlet servlet;
    private final Bundle bundle;

    protected abstract Servlet createServlet();

    public JspServletInitializer(String alias, Bundle bundle) {
        this.alias = !alias.endsWith("/") ? alias : alias.substring(0, alias.length() - 1);
        this.bundle = bundle;
    }

    public void setHttpService(WebContainer httpService) {
        this.httpService = httpService;
    }

    public void start() throws ServletException, NamespaceException {
        this.webctx = Dispatcher.createContext(this.bundle.getBundleContext());
        this.servlet = new BundleServletWrapper(this.createServlet(), this.bundle);
        this.httpService.registerServlet(this.alias, this.servlet, null, (HttpContext)this.webctx);
        this.jspServlet = new JspServlet(this.bundle, "/WEB-INF/views", String.format("/bundle/%d/WEB-INF/views", this.bundle.getBundleId()));
        this.httpService.registerServlet((Servlet)this.jspServlet, new String[]{"*.jsp"}, null, (HttpContext)this.webctx);
    }

    public void stop() {
        this.httpService.unregisterServlet((Servlet)this.jspServlet);
        this.httpService.unregisterServlet(this.servlet);
        this.webctx.dispose();
    }

    public static class BundleRequestWrapper
    extends HttpServletRequestWrapper {
        private final Bundle bundle;

        public BundleRequestWrapper(HttpServletRequest request, Bundle bundle) {
            super(request);
            this.bundle = bundle;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            if (path != null && path.startsWith("/WEB-INF")) {
                path = String.format("/bundle/%d%s", this.bundle.getBundleId(), path);
            }
            return super.getRequestDispatcher(path);
        }
    }

    public static class BundleServletWrapper
    extends ServletWrapper {
        private final Bundle bundle;

        public BundleServletWrapper(Servlet servlet, Bundle bundle) {
            super(servlet);
            this.bundle = bundle;
        }

        @Override
        public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            if (request instanceof HttpServletRequest) {
                super.service((ServletRequest)new BundleRequestWrapper((HttpServletRequest)request, this.bundle), response);
            } else {
                super.service(request, response);
            }
        }
    }
}

