/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.str;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;

public final class Tables {
    private Tables() {
    }

    public static void showTable(final PrintStream out, List<String> header, List<List<String>> data, int gap) {
        Tables.showTable(new Output(){

            @Override
            public void println() {
                out.println();
            }

            @Override
            public void print(String string) {
                out.print(string);
            }

            @Override
            public void print(char c) {
                out.print(c);
            }
        }, header, data, gap);
    }

    public static void showTable(final PrintWriter out, List<String> header, List<List<String>> data, int gap) {
        Tables.showTable(new Output(){

            @Override
            public void println() {
                out.println();
            }

            @Override
            public void print(String string) {
                out.print(string);
            }

            @Override
            public void print(char c) {
                out.print(c);
            }
        }, header, data, gap);
    }

    /*
     * WARNING - void declaration
     */
    protected static void showTable(Output out, List<String> header, List<List<String>> data, int gap) {
        void var7_18;
        if (gap < 0) {
            gap = 0;
        }
        int max = header.size();
        for (List<String> row : data) {
            max = Math.max(row.size(), max);
        }
        int[] lens = new int[max];
        boolean bl = false;
        for (String string : header) {
            void var6_7;
            if (string != null) {
                lens[var6_7] = Math.max(lens[var6_7], string.length());
            }
            ++var6_7;
        }
        for (List<String> list : data) {
            int i2 = 0;
            for (String cell : list) {
                if (cell != null) {
                    lens[i2] = Math.max(lens[i2], cell.length());
                }
                ++i2;
            }
        }
        String[] stringArray = new String[max];
        boolean bl2 = false;
        int i3 = 0;
        while (i3 < stringArray.length) {
            var7_18 += lens[i3] + gap;
            stringArray[i3] = String.format("%%-%ds", lens[i3] + gap);
            ++i3;
        }
        int i = 0;
        for (String cell : header) {
            out.print(String.format(stringArray[i], cell));
            ++i;
        }
        out.println();
        i = 0;
        while (i < var7_18) {
            out.print('=');
            ++i;
        }
        out.println();
        for (List<String> row : data) {
            int i4 = 0;
            for (String cell : row) {
                out.print(String.format(stringArray[i4], cell == null ? "" : cell));
                ++i4;
            }
            out.println();
        }
    }

    private static interface Output {
        public void println();

        public void print(String var1);

        public void print(char var1);
    }
}

