/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm;

import java.util.Arrays;

public class Rpms {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    public static String toHex(byte[] data, int maxWidth) {
        return Rpms.toHex(data, 0, data.length, maxWidth);
    }

    public static String toHex(byte[] data, int offset, int length, int maxWidth) {
        StringBuilder sb = new StringBuilder(length * 2);
        int lc = 0;
        int i = 0;
        while (i < length) {
            if (maxWidth > 0 && lc >= maxWidth) {
                sb.append(System.lineSeparator());
                lc = 0;
            }
            int b = data[offset + i] & 0xFF;
            sb.append(HEX[b >>> 4]);
            sb.append(HEX[b & 0xF]);
            ++lc;
            ++i;
        }
        return sb.toString();
    }

    public static String dumpValue(Object value) {
        StringBuilder sb = new StringBuilder();
        Rpms.dumpValue(sb, value);
        return sb.toString();
    }

    public static void dumpValue(StringBuilder sb, Object value) {
        if (value != null) {
            if (value instanceof byte[]) {
                sb.append(Rpms.toHex((byte[])value, -1));
            } else if (value.getClass().isArray()) {
                sb.append(Arrays.toString((Object[])value));
            } else {
                sb.append(value);
            }
        } else {
            sb.append("null");
        }
    }
}

