/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm;

import java.util.Optional;

public class RpmVersion {
    private final Optional<Integer> epoch;
    private final String version;
    private final Optional<String> release;

    public RpmVersion(Integer epoch, String version, String release) {
        this.epoch = Optional.ofNullable(epoch);
        this.version = version;
        this.release = Optional.ofNullable(release);
    }

    public Optional<Integer> getEpoch() {
        return this.epoch;
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<String> getRelease() {
        return this.release;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.epoch.ifPresent(v -> {
            StringBuilder stringBuilder2 = sb.append(v).append(':');
        });
        sb.append(this.version);
        if (this.release.isPresent() && !this.release.get().isEmpty()) {
            sb.append('-').append(this.release);
        }
        return sb.toString();
    }

    public static RpmVersion valueOf(String version) {
        String n;
        if (version == null || version.isEmpty()) {
            return null;
        }
        String[] toks1 = version.split(":", 2);
        Integer epoch = null;
        if (toks1.length > 1) {
            epoch = Integer.parseInt(toks1[0]);
            n = toks1[1];
        } else {
            n = toks1[0];
        }
        String[] toks2 = n.split("-", 2);
        String ver = toks2[0];
        String rel = toks2.length > 1 ? toks2[1] : null;
        return new RpmVersion(epoch, ver, rel);
    }
}

