/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm;

import java.util.Optional;

public class RpmTagValue {
    private final Object value;

    public RpmTagValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Optional<String[]> asStringArray() {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof String) {
            return Optional.of(new String[]{(String)this.value});
        }
        if (this.value instanceof String[]) {
            return Optional.of((String[])this.value);
        }
        return Optional.empty();
    }

    public Optional<String> asString() {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof String) {
            return Optional.of((String)this.value);
        }
        if (this.value instanceof String[]) {
            String[] arr = (String[])this.value;
            if (arr.length > 0) {
                return Optional.of(arr[0]);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Optional<Long[]> asLongArray() {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof Long) {
            return Optional.of(new Long[]{(Long)this.value});
        }
        if (this.value instanceof Long[]) {
            return Optional.of((Long[])this.value);
        }
        return Optional.empty();
    }

    public Optional<Long> asLong() {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof Number) {
            return Optional.of(((Number)this.value).longValue());
        }
        if (this.value instanceof Long[]) {
            Long[] arr = (Long[])this.value;
            if (arr.length > 0) {
                return Optional.of(arr[0]);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

