/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.history;

import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.internal.ui.history.Branch;
import org.eclipse.emf.cdo.internal.ui.history.Net;
import org.eclipse.emf.cdo.internal.ui.history.Segment;

public class Commit {
    private final CDOCommitInfo commitInfo;
    private final Segment segment;
    private Segment[] rowSegments;
    private int commitCounter = -1;

    public Commit(CDOCommitInfo commitInfo, Segment segment) {
        this.segment = segment;
        this.commitInfo = commitInfo;
    }

    public final CDOCommitInfo getCommitInfo() {
        return this.commitInfo;
    }

    public final Net getNet() {
        return this.segment.getNet();
    }

    public final Branch getBranch() {
        return this.segment.getBranch();
    }

    public final long getTime() {
        return this.commitInfo.getTimeStamp();
    }

    public final Segment getSegment() {
        return this.segment;
    }

    public final Segment[] getRowSegments() {
        Net net = this.segment.getNet();
        int netCommitCounter = net.getCommitCounter();
        if (this.rowSegments == null || this.commitCounter < netCommitCounter) {
            long time = this.getTime();
            this.rowSegments = net.createRowSegments(time);
            this.commitCounter = netCommitCounter;
        }
        return this.rowSegments;
    }

    public final boolean isFirstInBranch() {
        long firstTime = this.segment.getBranch().getFirstCommitTime();
        return this.getTime() == firstTime;
    }

    public final boolean isLastInBranch() {
        long lastTime = this.segment.getBranch().getLastCommitTime();
        return this.getTime() == lastTime;
    }

    public String toString() {
        return "Commit[" + this.getTime() + " --> " + this.segment + "]";
    }
}

