/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.SearchField;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;

public class SelectClassDialog
extends TitleAreaDialog {
    private final IWorkbenchPage page;
    private final String title;
    private final String message;
    private EPackage.Registry registry = EPackage.Registry.INSTANCE;
    private SearchField packageSearch;
    private TableViewer packageViewer;
    private SearchField classSearch;
    private EClass selectedClass;
    private TableViewer classViewer;

    public SelectClassDialog(IWorkbenchPage page, String title, String message) {
        super(page.getWorkbenchWindow().getShell());
        this.page = page;
        this.title = title;
        this.message = message;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public EPackage.Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(EPackage.Registry registry) {
        this.registry = registry;
    }

    public EClass getSelectedClass() {
        return this.selectedClass;
    }

    protected Point getInitialSize() {
        return new Point(750, 600);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        this.setTitle(this.title);
        this.setTitleImage(SharedIcons.getImage((String)"wizban/PackageManager.gif"));
        this.setMessage(this.message);
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayoutData((Object)UIUtil.createGridData());
        composite.setLayout((Layout)new FillLayout(256));
        SashForm sashForm = new SashForm(composite, 65536);
        GridLayout packageLayout = new GridLayout(1, false);
        packageLayout.marginWidth = 0;
        packageLayout.marginHeight = 0;
        Composite packageComposite = new Composite((Composite)sashForm, 0);
        packageComposite.setLayout((Layout)packageLayout);
        PackageContentProvider packageContentProvider = new PackageContentProvider();
        this.packageSearch = new SearchField(packageComposite, packageContentProvider){

            protected void finishFilter() {
                SelectClassDialog.this.packageViewer.getControl().setFocus();
            }
        };
        this.packageSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.packageViewer = new TableViewer(packageComposite, 0x10010800);
        this.packageViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.packageViewer.setContentProvider((IContentProvider)packageContentProvider);
        this.packageViewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider((Viewer)this.packageViewer));
        this.packageViewer.setInput((Object)this.registry);
        this.packageViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                String nsURI = (String)selection.getFirstElement();
                EPackage ePackage = ((EPackage.Registry)SelectClassDialog.this.packageViewer.getInput()).getEPackage(nsURI);
                SelectClassDialog.this.classViewer.setInput((Object)ePackage);
                try {
                    SelectClassDialog.this.packageViewer.update((Object)nsURI, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        GridLayout classLayout = new GridLayout(1, false);
        classLayout.marginWidth = 0;
        classLayout.marginHeight = 0;
        Composite classComposite = new Composite((Composite)sashForm, 0);
        classComposite.setLayout((Layout)classLayout);
        ClassContentProvider classContentProvider = new ClassContentProvider();
        this.classSearch = new SearchField(classComposite, classContentProvider){

            protected void finishFilter() {
                SelectClassDialog.this.classViewer.getControl().setFocus();
            }
        };
        this.classSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.classViewer = new TableViewer(classComposite, 0x10010800);
        this.classViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.classViewer.setUseHashlookup(true);
        this.classViewer.setContentProvider((IContentProvider)classContentProvider);
        this.classViewer.setLabelProvider((IBaseLabelProvider)new ClassLabelProvider());
        this.classViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SelectClassDialog.this.selectedClass = (EClass)selection.getFirstElement();
                SelectClassDialog.this.updateOkButton();
            }
        });
        this.classViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectClassDialog.this.okPressed();
            }
        });
        sashForm.setWeights(new int[]{2, 1});
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateOkButton();
    }

    private void updateOkButton() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.selectedClass != null);
        }
    }

    private static final class ClassContentProvider
    implements IStructuredContentProvider,
    SearchField.FilterHandler {
        private Viewer viewer;
        private Object input;
        private String filter;
        private EClass[] elements;

        private ClassContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
            this.input = newInput;
            this.computeElements();
        }

        public void handleFilter(String filter) {
            this.filter = filter == null ? null : filter.toLowerCase();
            this.computeElements();
            this.viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void dispose() {
            this.elements = null;
        }

        private void computeElements() {
            if (this.input instanceof EPackage) {
                EPackage ePackage = (EPackage)this.input;
                ArrayList<EClass> eClasses = new ArrayList<EClass>();
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    EClass eClass;
                    if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || eClass.isInterface() || this.filter != null && !eClass.getName().toLowerCase().contains(this.filter)) continue;
                    eClasses.add(eClass);
                }
                this.elements = eClasses.toArray(new EClass[eClasses.size()]);
                Arrays.sort(this.elements, new Comparator<EClass>(){

                    @Override
                    public int compare(EClass c1, EClass c2) {
                        return StringUtil.safe((String)c1.getName()).compareTo(StringUtil.safe((String)c2.getName()));
                    }
                });
            } else {
                this.elements = null;
            }
            if (this.elements == null) {
                this.elements = new EClass[0];
            }
        }
    }

    private static final class ClassLabelProvider
    extends LabelProvider {
        private static final Image CLASS_IMAGE = SharedIcons.getImage((String)"obj16/EClass.gif");
        private final ComposedAdapterFactory adapterFactory = CDOEditor.createAdapterFactory(true);
        private final ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);

        public void dispose() {
            this.labelProvider.dispose();
            this.adapterFactory.dispose();
            super.dispose();
        }

        public Image getImage(Object element) {
            try {
                EClass eClass = (EClass)element;
                EObject eObject = EcoreUtil.create((EClass)eClass);
                Image image = this.labelProvider.getImage((Object)eObject);
                if (image != null) {
                    return image;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return CLASS_IMAGE;
        }

        public String getText(Object element) {
            return ((EClass)element).getName();
        }
    }

    private static final class PackageContentProvider
    implements IStructuredContentProvider,
    SearchField.FilterHandler {
        private Viewer viewer;
        private Object input;
        private String filter;
        private String[] elements;

        private PackageContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
            this.input = newInput;
            this.computeElements();
        }

        public void handleFilter(String filter) {
            this.filter = filter == null ? null : filter.toLowerCase();
            this.computeElements();
            this.viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void dispose() {
            this.elements = null;
        }

        private void computeElements() {
            if (this.input instanceof EPackage.Registry) {
                EPackage.Registry registry = (EPackage.Registry)this.input;
                ArrayList<String> nsURIs = new ArrayList<String>();
                for (String nsURI : registry.keySet()) {
                    if (this.filter != null && !nsURI.toLowerCase().contains(this.filter)) continue;
                    nsURIs.add(nsURI);
                }
                this.elements = nsURIs.toArray(new String[nsURIs.size()]);
                Arrays.sort(this.elements);
            } else {
                this.elements = null;
            }
            if (this.elements == null) {
                this.elements = new String[0];
            }
        }
    }

    private static final class PackageLabelProvider
    extends LabelProvider {
        private static final Image PACKAGE_IMAGE = SharedIcons.getImage((String)"obj16/EPackage.gif");
        private static final Image UNKNOWN_IMAGE = SharedIcons.getImage((String)"obj16/EPackageUnknown.gif");
        private final Viewer viewer;

        public PackageLabelProvider(Viewer viewer) {
            this.viewer = viewer;
        }

        public Image getImage(Object element) {
            String nsURI = (String)element;
            EPackage.Registry registry = (EPackage.Registry)this.viewer.getInput();
            Object value = registry.get((Object)nsURI);
            if (value instanceof EPackage) {
                return PACKAGE_IMAGE;
            }
            return UNKNOWN_IMAGE;
        }
    }
}

