/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.dialogs.AbstractBranchPointDialog;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateBranchDialog
extends AbstractBranchPointDialog {
    public static final String TITLE = "New Branch";
    private Text nameText;
    private String name;

    public CreateBranchDialog(Shell parentShell, CDOBranchPoint base, String defaultName) {
        super(parentShell, true, base);
        this.name = StringUtil.safe((String)defaultName);
    }

    public String getName() {
        return this.name;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(TITLE);
        this.setTitle(TITLE);
        this.setTitleImage(SharedIcons.getImage((String)"wizban/BranchBanner.gif"));
        this.setMessage("Select a base point and enter the name of the new branch.");
        return super.createDialogArea(parent);
    }

    protected void createUI(Composite container) {
        super.createUI(container);
        Label newLabel = new Label(container, 0);
        newLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        newLabel.setText("Name:");
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.setText(this.name);
        this.nameText.selectAll();
        this.nameText.setFocus();
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateBranchDialog.this.name = CreateBranchDialog.this.nameText.getText();
                CreateBranchDialog.this.validate();
            }
        });
    }

    protected void doValidate() throws Exception {
        super.doValidate();
        if (this.name.length() == 0) {
            throw new Exception("Name is empty.");
        }
        if (this.name.contains("/") || this.name.contains("\\")) {
            throw new Exception("Name contains a path separator.");
        }
        CDOBranch baseBranch = this.getBranchPoint().getBranch();
        CDOBranch branch = baseBranch.getBranch(this.name);
        if (branch != null) {
            throw new Exception("Name is not unique within " + baseBranch.getPathName() + ".");
        }
    }

    protected void doubleClicked() {
    }
}

