/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf.xylayout;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class FixAnchorHelper {
    protected final TransactionalEditingDomain domain;

    public FixAnchorHelper(TransactionalEditingDomain domain) {
        Assert.isNotNull((Object)domain);
        this.domain = domain;
    }

    public Command getFixIdentityAnchorCommand(INodeEditPart node, Point move, Dimension sizeDelta, int moveDirection) {
        Command tmp;
        CompoundCommand cc = new CompoundCommand("Fix All Anchors Command");
        IFigure nodeFigure = node.getFigure();
        PrecisionRectangle oldBounds = new PrecisionRectangle(nodeFigure.getBounds());
        nodeFigure.translateToAbsolute((Translatable)oldBounds);
        PrecisionRectangle newBounds = oldBounds.getPreciseCopy();
        newBounds.translate(move.preciseX(), move.preciseY());
        newBounds.resize(sizeDelta.preciseWidth(), sizeDelta.preciseHeight());
        for (Object targetConnection : node.getTargetConnections()) {
            if (!(targetConnection instanceof AbstractConnectionEditPart) || (tmp = this.getFixAnchorCommand(node, oldBounds, newBounds, (AbstractConnectionEditPart)targetConnection, move, sizeDelta, false)) == null) continue;
            cc.add(tmp);
        }
        for (Object sourceConnection : node.getSourceConnections()) {
            if (!(sourceConnection instanceof AbstractConnectionEditPart) || (tmp = this.getFixAnchorCommand(node, oldBounds, newBounds, (AbstractConnectionEditPart)sourceConnection, move, sizeDelta, true)) == null) continue;
            cc.add(tmp);
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    protected Point getRealAnchorPoint(AbstractConnectionEditPart edgeEP, boolean sourcePoint) {
        IFigure figure = edgeEP.getFigure();
        Point point = null;
        if (figure instanceof AbstractPointListShape) {
            point = sourcePoint ? ((AbstractPointListShape)figure).getStart().getCopy() : ((AbstractPointListShape)figure).getEnd().getCopy();
        }
        figure.translateToAbsolute(point);
        return point;
    }

    protected IdentityAnchor getIdentityAnchor(AbstractConnectionEditPart edgeEP, boolean sourcePoint, INodeEditPart nodeEP, Point p) {
        View view = (View)edgeEP.getAdapter(View.class);
        IdentityAnchor anchor = null;
        if (view instanceof Edge) {
            Anchor tmpAnchor = sourcePoint ? ((Edge)view).getSourceAnchor() : ((Edge)view).getTargetAnchor();
            if (tmpAnchor instanceof IdentityAnchor) {
                anchor = (IdentityAnchor)tmpAnchor;
            }
            if (anchor == null) {
                ConnectionAnchor connectionAnchor = null;
                if (nodeEP.getFigure() instanceof NodeFigure) {
                    NodeFigure nodeFigure = (NodeFigure)nodeEP.getFigure();
                    connectionAnchor = sourcePoint ? nodeFigure.getSourceConnectionAnchorAt(p) : nodeFigure.getTargetConnectionAnchorAt(p);
                    if (connectionAnchor != null) {
                        String id = nodeEP.mapConnectionAnchorToTerminal(connectionAnchor);
                        anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                        anchor.setId(id);
                    }
                }
            }
        }
        return anchor;
    }

    public Command getFixAnchorCommand(INodeEditPart nodeEditPart, PrecisionRectangle oldNodeBounds, PrecisionRectangle newNodeBounds, AbstractConnectionEditPart targetConnectionEP, Point move, Dimension sizeDelta, final boolean fixSource) {
        Point realAnchorPoint = this.getRealAnchorPoint(targetConnectionEP, fixSource);
        IFigure fig = nodeEditPart.getFigure();
        if (fig instanceof NodeFigure) {
            View view;
            NodeFigure nodeFigure = (NodeFigure)fig;
            final IdentityAnchor editedAnchor = this.getIdentityAnchor(targetConnectionEP, fixSource, nodeEditPart, realAnchorPoint);
            if (realAnchorPoint != null && editedAnchor != null && (view = (View)targetConnectionEP.getAdapter(View.class)) instanceof Edge) {
                int anchorSide = this.getSideOfConnectionPoint((IFigure)nodeFigure, targetConnectionEP, fixSource);
                double newX = -1.0;
                double newY = -1.0;
                switch (anchorSide) {
                    case 1: {
                        newY = 0.0;
                        break;
                    }
                    case 8: {
                        newX = 0.0;
                        break;
                    }
                    case 16: {
                        newX = 1.0;
                        break;
                    }
                    case 4: {
                        newY = 1.0;
                        break;
                    }
                }
                PrecisionPoint newRealAnchorPoint = new PrecisionPoint(realAnchorPoint);
                newRealAnchorPoint.setPreciseLocation((double)newRealAnchorPoint.x() - oldNodeBounds.preciseX(), (double)newRealAnchorPoint.y() - oldNodeBounds.preciseY());
                PrecisionPoint newLocation = newRealAnchorPoint.getPreciseCopy();
                newLocation.setPreciseX(newLocation.preciseX() - move.preciseX());
                newLocation.setPreciseY(newLocation.preciseY() - move.preciseY());
                if (newX == -1.0) {
                    newX = newLocation.preciseX() / newNodeBounds.preciseWidth();
                }
                if (newY == -1.0) {
                    newY = newLocation.preciseY() / newNodeBounds.preciseHeight();
                }
                if (newX <= 1.0 && newX >= 0.0 && newY <= 1.0 && newY >= 0.0) {
                    final String newIdValue = FixAnchorHelper.createNewAnchorIdValue(newX, newY);
                    AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(this.domain, "Fix Anchor Location", null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            editedAnchor.setId(newIdValue);
                            if (editedAnchor.eContainer() == null) {
                                if (fixSource) {
                                    ((Edge)view).setSourceAnchor((Anchor)editedAnchor);
                                } else {
                                    ((Edge)view).setTargetAnchor((Anchor)editedAnchor);
                                }
                            }
                            return CommandResult.newOKCommandResult((Object)editedAnchor);
                        }
                    };
                    return new ICommandProxy((ICommand)cmd);
                }
            }
        }
        return null;
    }

    protected final int getSideOfConnectionPoint(IFigure nodeFigure, AbstractConnectionEditPart edgeEP, boolean fixingSource) {
        int side = -1;
        IFigure figure = edgeEP.getFigure();
        if (figure instanceof PolylineConnectionEx) {
            PointList list;
            PolylineConnectionEx connection = (PolylineConnectionEx)figure;
            Rectangle bounds = nodeFigure.getBounds().getCopy();
            nodeFigure.translateToAbsolute((Translatable)bounds);
            Point pt = fixingSource ? connection.getStart() : connection.getEnd();
            figure.translateToAbsolute((Translatable)pt);
            Rectangle includedRect = bounds.getCopy();
            while (includedRect.contains(pt)) {
                includedRect.shrink(1, 1);
            }
            side = includedRect.getPosition(pt);
            if ((side == 9 || side == 17 || side == 20 || side == 12) && (list = connection.getPoints()).size() > 1) {
                Point previousPoint = fixingSource ? list.getPoint(1) : list.getPoint(list.size() - 2);
                nodeFigure.translateToAbsolute((Translatable)previousPoint.getCopy());
                while (includedRect.contains(previousPoint)) {
                    includedRect.shrink(1, 1);
                }
                side = includedRect.getPosition(previousPoint);
            }
        }
        return side;
    }

    public static final String createNewAnchorIdValue(double percentageOnX, double percentageOnY) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(Double.toString(percentageOnX));
        buffer.append(',');
        buffer.append(Double.toString(percentageOnY));
        buffer.append(')');
        return buffer.toString();
    }
}

