/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf.policies;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.tooling.runtime.linklf.AbsoluteBendpointsConvention;
import org.eclipse.gmf.tooling.runtime.linklf.DiagramGridSpec;
import org.eclipse.gmf.tooling.runtime.linklf.policies.AdjustAbsoluteBendpointsEditPolicyBase;
import org.eclipse.gmf.tooling.runtime.linklf.policies.SetAbsoluteBendpointsCommand;
import org.eclipse.gmf.tooling.runtime.linklf.router.LinkLFRectilinearRouter;

public class AdjustLinksToIndirectlyMovedNodesEditPolicy
extends AdjustAbsoluteBendpointsEditPolicyBase {
    public static final String ROLE = String.valueOf(AdjustLinksToIndirectlyMovedNodesEditPolicy.class.getName()) + ":Role";
    private WeakReference<ChangeBoundsRequest> myLastRequest;
    private WeakReference<Command> myLastCommand;

    @Override
    protected Command getAdjustLinksCommand(ChangeBoundsRequest req) {
        Command result;
        if (this.myLastRequest != null && this.myLastRequest.get() == req) {
            if (this.myLastCommand == null) {
                return null;
            }
            result = (Command)this.myLastCommand.get();
            if (result != null) {
                return result;
            }
        }
        this.myLastCommand = null;
        this.myLastRequest = null;
        result = this.createAdjustLinksCommand(req);
        this.myLastRequest = new WeakReference<ChangeBoundsRequest>(req);
        this.myLastCommand = result == null ? null : new WeakReference<Command>(result);
        return result;
    }

    protected Command createAdjustLinksCommand(ChangeBoundsRequest req) {
        ICommand result = null;
        AdjustAbsoluteBendpointsEditPolicyBase.CachedEditPartsSet allMoved = AdjustLinksToIndirectlyMovedNodesEditPolicy.getMovedEditPartsSet(req);
        LinkedList queue = new LinkedList();
        queue.addAll(this.getHost().getChildren());
        while (!queue.isEmpty()) {
            GraphicalEditPart cur = (GraphicalEditPart)queue.removeFirst();
            for (EditPart link : cur.getSourceConnections()) {
                ICommand nextOutgoingCommand = this.getAdjustOneLinkCommand(link, allMoved, req, true);
                result = AdjustLinksToIndirectlyMovedNodesEditPolicy.compose(result, nextOutgoingCommand);
            }
            for (EditPart link : cur.getTargetConnections()) {
                ICommand nextIncomingCommand = this.getAdjustOneLinkCommand(link, allMoved, req, false);
                result = AdjustLinksToIndirectlyMovedNodesEditPolicy.compose(result, nextIncomingCommand);
            }
            queue.addAll(cur.getChildren());
        }
        return result == null ? null : new ICommandProxy(result.reduce());
    }

    protected ICommand getAdjustOneLinkCommand(EditPart linkEP, AdjustAbsoluteBendpointsEditPolicyBase.CachedEditPartsSet allMoved, ChangeBoundsRequest req, boolean outgoing) {
        int staticGateSegment;
        Point staticGate;
        EditPart staticEnd;
        if (!(linkEP instanceof ConnectionEditPart)) {
            return null;
        }
        ConnectionEditPart link = (ConnectionEditPart)linkEP;
        EditPart editPart = staticEnd = outgoing ? link.getTarget() : link.getSource();
        if (staticEnd == null) {
            return null;
        }
        AdjustAbsoluteBendpointsEditPolicyBase.MovedNodeKind kind = allMoved.isMoved(staticEnd);
        if (kind != AdjustAbsoluteBendpointsEditPolicyBase.MovedNodeKind.NO) {
            return null;
        }
        Connection conn = link.getConnectionFigure();
        if (conn == null) {
            return null;
        }
        if (!this.acceptAdjustingConnection(link, conn)) {
            return null;
        }
        GraphicalEditPart staticGateEP = (GraphicalEditPart)AdjustLinksToIndirectlyMovedNodesEditPolicy.findHighestDifferentAncestor(staticEnd, (EditPart)this.getHost());
        if (staticGateEP == null) {
            return null;
        }
        PointList linkPoints = AdjustLinksToIndirectlyMovedNodesEditPolicy.makeAbsolute((IFigure)conn, conn.getPoints());
        Point hostGate = this.findGatePosition(linkPoints, this.getHostFigure());
        if (hostGate == null) {
            return null;
        }
        int hostGateSegment = PointListUtilities.findNearestLineSegIndexOfPoint((PointList)linkPoints, (Point)hostGate);
        if (staticGateEP == staticEnd) {
            staticGate = null;
            staticGateSegment = -1;
        } else {
            IFigure staticGateOwner = staticGateEP.getFigure();
            staticGate = this.findGatePosition(linkPoints, staticGateOwner);
            if (staticGate == null) {
                return null;
            }
            staticGateSegment = PointListUtilities.findNearestLineSegIndexOfPoint((PointList)linkPoints, (Point)staticGate);
        }
        PreserveGatesRequest preserveReq = new PreserveGatesRequest(link, linkPoints, outgoing, req);
        preserveReq.setMovingGate(hostGate, hostGateSegment);
        preserveReq.setStaticGate(staticGate, staticGateSegment);
        return this.createPreserveGatesCommand(preserveReq);
    }

    protected ICommand createPreserveGatesCommand(PreserveGatesRequest req) {
        return new PreserveGatesCommand(this.getDomain(), req);
    }

    protected boolean acceptAdjustingConnection(ConnectionEditPart link, Connection conn) {
        Edge edge = (Edge)link.getNotationView();
        if (edge == null) {
            return false;
        }
        return AbsoluteBendpointsConvention.getInstance().hasAbsoluteStoredAsRelativeBendpoints(edge) && conn.getConnectionRouter() instanceof OrthogonalRouter;
    }

    protected Point findGatePosition(PointList linkPointsAbs, IFigure gateOwner) {
        PointList distances;
        PointList intersections;
        Rectangle ownerBounds = AdjustLinksToIndirectlyMovedNodesEditPolicy.makeAbsolute(gateOwner, gateOwner.getBounds());
        PointList ownerPoints = PointListUtilities.createPointsFromRect((Rectangle)ownerBounds);
        boolean computed = PointListUtilities.findIntersections((PointList)ownerPoints, (PointList)linkPointsAbs, (PointList)(intersections = new PointList()), (PointList)(distances = new PointList()));
        if (!computed || intersections.size() == 0) {
            System.err.println("Can't compute intersections between: hostBounds: " + AdjustLinksToIndirectlyMovedNodesEditPolicy.pointList2String(ownerPoints) + " and link: " + AdjustLinksToIndirectlyMovedNodesEditPolicy.pointList2String(linkPointsAbs));
            return null;
        }
        if (intersections.size() > 1) {
            System.err.println("Expected exactly one intersection between: hostBounds: " + AdjustLinksToIndirectlyMovedNodesEditPolicy.pointList2String(ownerPoints) + " and link: " + AdjustLinksToIndirectlyMovedNodesEditPolicy.pointList2String(linkPointsAbs) + " actually: " + AdjustLinksToIndirectlyMovedNodesEditPolicy.pointList2String(intersections) + " will use the first one: " + intersections.getFirstPoint());
        }
        return intersections.getFirstPoint();
    }

    public void deactivate() {
        this.myLastRequest = null;
        this.myLastCommand = null;
        super.deactivate();
    }

    protected static EditPart findHighestDifferentAncestor(EditPart subj, EditPart other) {
        HashSet<EditPart> otherChainUp = new HashSet<EditPart>();
        EditPart cur = other;
        while (cur != null) {
            otherChainUp.add(cur);
            cur = cur.getParent();
        }
        EditPart result = subj;
        while (result != null) {
            EditPart parent = result.getParent();
            if (parent == null) {
                return null;
            }
            if (otherChainUp.contains(parent)) {
                return result;
            }
            result = parent;
        }
        throw new IllegalStateException();
    }

    protected static class PreserveGatesCommand
    extends AbstractTransactionalCommand {
        private static final String LABEL = "Adjusting link preserving implicit gates";
        private final PreserveGatesRequest myRequest;

        public PreserveGatesCommand(TransactionalEditingDomain domain, PreserveGatesRequest req) {
            super(domain, LABEL, PreserveGatesCommand.getWorkspaceFiles((EObject)req.getLink().getNotationView()));
            this.myRequest = req;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            int i;
            Point moveDelta = this.myRequest.getMoveDelta();
            if (moveDelta == null || moveDelta.x == 0 && moveDelta.y == 0) {
                return CommandResult.newOKCommandResult();
            }
            PointList oldPoints = this.myRequest.getLinkPointsBefore();
            PointList newPointsStart = new PointList(oldPoints.size());
            PointList newPointsEnd = new PointList(oldPoints.size() * 2);
            if (this.myRequest.isOutgoing()) {
                i = 0;
                while (i < this.myRequest.getMovingGateSegment()) {
                    newPointsStart.addPoint(oldPoints.getPoint(i));
                    ++i;
                }
                newPointsStart.addPoint(this.myRequest.getMovingGateAbs());
                newPointsStart.translate(moveDelta);
                if (this.myRequest.getStaticGateAbs() != null && this.myRequest.getStaticGateSegment() == this.myRequest.getMovingGateSegment()) {
                    newPointsEnd.addPoint(this.myRequest.getStaticGateAbs());
                }
                i = this.myRequest.getMovingGateSegment();
                while (i < oldPoints.size()) {
                    newPointsEnd.addPoint(oldPoints.getPoint(i));
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.myRequest.getMovingGateSegment()) {
                    newPointsStart.addPoint(oldPoints.getPoint(i));
                    ++i;
                }
                if (this.myRequest.getStaticGateAbs() != null && this.myRequest.getMovingGateSegment() == this.myRequest.getStaticGateSegment()) {
                    newPointsStart.addPoint(this.myRequest.getStaticGateAbs());
                }
                newPointsEnd.addPoint(this.myRequest.getMovingGateAbs());
                i = this.myRequest.getMovingGateSegment();
                while (i < oldPoints.size()) {
                    newPointsEnd.addPoint(oldPoints.getPoint(i));
                    ++i;
                }
                newPointsEnd.translate(moveDelta);
            }
            Point routeStart = newPointsStart.getLastPoint();
            Point routeEnd = newPointsEnd.getFirstPoint();
            int offSourceDirection = PreserveGatesUtil.getSegmentDirection(oldPoints, this.myRequest.getMovingGateSegment());
            int offTargetDirection = PreserveGatesUtil.getOppositeDirection(offSourceDirection);
            PointList middlePart = new PointList();
            middlePart.addPoint(routeStart);
            middlePart.addPoint(routeEnd);
            if (!OrthogonalRouterUtilities.isRectilinear((PointList)middlePart)) {
                SnapToGrid snapper = this.myRequest.getSnapToGrid();
                PreserveGatesUtil.insertPointsProducingNotAlignedRectilinearSegments(this.myRequest.getLink().getConnectionFigure(), middlePart, offSourceDirection, offTargetDirection, snapper);
                OrthogonalRouterUtilities.transformToOrthogonalPointList((PointList)middlePart, (int)PreserveGatesUtil.asVerticalOrHorizontal(offSourceDirection), (int)PreserveGatesUtil.asVerticalOrHorizontal(offTargetDirection));
            }
            if (middlePart.getFirstPoint().equals((Object)newPointsStart.getLastPoint())) {
                middlePart.removePoint(0);
            }
            if (middlePart.getLastPoint().equals((Object)newPointsEnd.getFirstPoint())) {
                middlePart.removePoint(middlePart.size() - 1);
            }
            PointList newPoints = new PointList(newPointsStart.size() + middlePart.size() + newPointsEnd.size());
            newPoints.addAll(newPointsStart);
            newPoints.addAll(middlePart);
            newPoints.addAll(newPointsEnd);
            PreserveGatesUtil.doRemoveRedundantPoints(newPoints);
            PointList relPoints = newPoints.getCopy();
            this.myRequest.getLink().getConnectionFigure().translateToRelative((Translatable)relPoints);
            if (newPoints != null) {
                SetAbsoluteBendpointsCommand.setAbsoluteBendpoints(this.myRequest.getEdge(), relPoints);
            }
            return CommandResult.newOKCommandResult();
        }
    }

    protected static class PreserveGatesRequest
    extends Request {
        private final ConnectionEditPart myLink;
        private final PointList myLinkPoints;
        private final boolean myIsOutgoing;
        private final ChangeBoundsRequest myHostRequest;
        private Point myStaticGateAbs;
        private Point myMovingGateAbs;
        private int myStaticGateSegment;
        private int myMovingGateSegment;

        public PreserveGatesRequest(ConnectionEditPart link, PointList linkPointsAbs, boolean outgoing, ChangeBoundsRequest hostRequest) {
            this.myLink = link;
            this.myLinkPoints = linkPointsAbs;
            this.myIsOutgoing = outgoing;
            this.myHostRequest = hostRequest;
        }

        public void setMovingGate(Point movingGateAbs, int segIndex) {
            this.myMovingGateAbs = movingGateAbs;
            this.myMovingGateSegment = segIndex;
        }

        public void setStaticGate(Point staticGateAbs, int segIndex) {
            this.myStaticGateAbs = staticGateAbs;
            this.myStaticGateSegment = segIndex;
        }

        public Point getMovingGateAbs() {
            return this.myMovingGateAbs;
        }

        public Point getStaticGateAbs() {
            return this.myStaticGateAbs;
        }

        public int getMovingGateSegment() {
            return this.myMovingGateSegment;
        }

        public int getStaticGateSegment() {
            return this.myStaticGateSegment;
        }

        public ConnectionEditPart getLink() {
            return this.myLink;
        }

        public Edge getEdge() {
            return (Edge)this.myLink.getNotationView();
        }

        public PointList getLinkPointsBefore() {
            return this.myLinkPoints;
        }

        public boolean isOutgoing() {
            return this.myIsOutgoing;
        }

        public GraphicalEditPart getStaticLinkEnd() {
            return (GraphicalEditPart)(this.isOutgoing() ? this.myLink.getTarget() : this.myLink.getSource());
        }

        public GraphicalEditPart getMovingLinkEnd() {
            return (GraphicalEditPart)(this.isOutgoing() ? this.myLink.getSource() : this.myLink.getTarget());
        }

        public Point getMoveDelta() {
            return this.myHostRequest.getMoveDelta();
        }

        public SnapToGrid getSnapToGrid() {
            PrecisionRectangle gridSpec = DiagramGridSpec.getAbsoluteGridSpec(this.getLink().getViewer());
            return gridSpec == null ? null : new SnapToGrid((GraphicalEditPart)this.getLink());
        }
    }

    private static class PreserveGatesUtil
    extends LinkLFRectilinearRouter {
        private static PreserveGatesUtil INSTANCE = new PreserveGatesUtil();

        private PreserveGatesUtil() {
        }

        public static boolean doRemoveRedundantPoints(PointList line) {
            return PreserveGatesUtil.removeRedundantPoints2(line);
        }

        public static int getOppositeDirection(int direction) {
            int result = 0;
            if ((direction & 0x10) != 0) {
                result |= 8;
            }
            if ((direction & 8) != 0) {
                result |= 0x10;
            }
            if ((direction & 1) != 0) {
                result |= 4;
            }
            if ((direction & 4) != 0) {
                result |= 1;
            }
            return result;
        }

        public static int getSegmentDirection(PointList points, int segment) {
            Point start = points.getPoint(segment - 1);
            Point end = points.getPoint(segment);
            if (start.x == end.x) {
                return start.y < end.y ? 4 : 1;
            }
            if (start.y == end.y) {
                return start.x < end.x ? 16 : 8;
            }
            return PreserveGatesUtil.getOutisePointOffRectanglePosition2(start, new Rectangle(end.x, end.y, 0, 0));
        }
    }
}

