/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf.policies;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.tooling.runtime.linklf.AbsoluteBendpointsConvention;
import org.eclipse.gmf.tooling.runtime.linklf.policies.AdjustAbsoluteBendpointsEditPolicyBase;
import org.eclipse.gmf.tooling.runtime.linklf.policies.SetAbsoluteBendpointsCommand;

public class AdjustImplicitlyMovedLinksEditPolicy
extends AdjustAbsoluteBendpointsEditPolicyBase {
    public static final String ROLE = String.valueOf(AdjustImplicitlyMovedLinksEditPolicy.class.getName()) + ":Role";

    @Override
    protected Command getAdjustLinksCommand(ChangeBoundsRequest req) {
        return this.getAdjustImplicitlyMovedLinksCommand(req);
    }

    protected Command getAdjustImplicitlyMovedLinksCommand(ChangeBoundsRequest req) {
        Point moveDelta = req.getMoveDelta();
        if (moveDelta.x == 0 && moveDelta.y == 0) {
            return null;
        }
        AdjustAbsoluteBendpointsEditPolicyBase.CachedEditPartsSet allMoved = AdjustImplicitlyMovedLinksEditPolicy.getMovedEditPartsSet(req);
        ICommand result = null;
        LinkedList<IGraphicalEditPart> queue = new LinkedList<IGraphicalEditPart>();
        queue.add(this.getHost());
        while (!queue.isEmpty()) {
            GraphicalEditPart cur = (GraphicalEditPart)queue.removeFirst();
            for (Object nextLink : cur.getSourceConnections()) {
                ConnectionEditPart nextLinkEP;
                EditPart target;
                AdjustAbsoluteBendpointsEditPolicyBase.MovedNodeKind move;
                if (!(nextLink instanceof ConnectionEditPart) || (move = allMoved.isMoved(target = (nextLinkEP = (ConnectionEditPart)nextLink).getTarget())) != AdjustAbsoluteBendpointsEditPolicyBase.MovedNodeKind.DIRECTLY && move != AdjustAbsoluteBendpointsEditPolicyBase.MovedNodeKind.INDIRECTLY) continue;
                ICommand nextAdjustment = this.getAdjustOneLinkCommand(nextLinkEP, req);
                result = AdjustImplicitlyMovedLinksEditPolicy.compose(result, nextAdjustment);
            }
            List children = cur.getChildren();
            queue.addAll(children);
        }
        return result == null ? null : new ICommandProxy(result.reduce());
    }

    private ICommand getAdjustOneLinkCommand(ConnectionEditPart linkEP, ChangeBoundsRequest req) {
        SetAbsoluteBendpointsCommand result = null;
        Edge edge = (Edge)linkEP.getNotationView();
        if (AbsoluteBendpointsConvention.getInstance().hasAbsoluteStoredAsRelativeBendpoints(edge)) {
            PointList newPoints = AbsoluteBendpointsConvention.getInstance().getPointList(edge, linkEP.getConnectionFigure().getRoutingConstraint());
            newPoints.translate(req.getMoveDelta());
            result = new SetAbsoluteBendpointsCommand(this.getDomain());
            result.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)edge));
            result.setNewPointList(newPoints);
        }
        return result;
    }
}

