/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class IncludedFeaturesDetailsSection
extends PDESection
implements IPartSelectionListener {
    protected IFeatureChild fInput;
    private FormEntry fNameText;
    private FormEntry fVersionText;
    private Button fOptionalButton;
    private Button fSearchRootButton;
    private Button fSearchSelfButton;
    private Button fSearchBothButton;
    private boolean fBlockNotification;

    public IncludedFeaturesDetailsSection(PDEFormPage page, Composite parent) {
        this(page, parent, PDEUIMessages.SiteEditor_IncludedFeaturesDetailsSection_title, PDEUIMessages.SiteEditor_IncludedFeaturesDetailsSection_desc, 0);
    }

    public IncludedFeaturesDetailsSection(PDEFormPage page, Composite parent, String title, String desc, int toggleStyle) {
        super(page, parent, 0x80 | toggleStyle);
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    @Override
    public void cancelEdit() {
        this.fNameText.cancelEdit();
        this.fVersionText.cancelEdit();
        super.cancelEdit();
    }

    public void commit(boolean onSave) {
        this.fNameText.commit();
        this.fVersionText.commit();
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(770);
        section.setLayoutData((Object)data);
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 2));
        this.fNameText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_IncludedFeaturesDetailsSection_featureLabel, null, false);
        this.fNameText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                if (IncludedFeaturesDetailsSection.this.fInput != null) {
                    try {
                        IncludedFeaturesDetailsSection.this.fInput.setName(text.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.fNameText.setEditable(this.isEditable());
        this.fVersionText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_version, null, false);
        this.fVersionText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                if (IncludedFeaturesDetailsSection.this.fInput != null) {
                    try {
                        IncludedFeaturesDetailsSection.this.fInput.setVersion(text.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.fVersionText.setEditable(this.isEditable());
        this.fOptionalButton = toolkit.createButton(container, PDEUIMessages.SiteEditor_IncludedFeaturesDetailsSection_optional, 32);
        TableWrapData gd = new TableWrapData(128);
        gd.colspan = 2;
        this.fOptionalButton.setLayoutData((Object)gd);
        this.fOptionalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!IncludedFeaturesDetailsSection.this.fBlockNotification) {
                    try {
                        IncludedFeaturesDetailsSection.this.fInput.setOptional(IncludedFeaturesDetailsSection.this.fOptionalButton.getSelection());
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
        Label fSearchLocationDescLabel = toolkit.createLabel(container, PDEUIMessages.SiteEditor_IncludedFeaturesDetailsSection_searchLocation, 64);
        gd = new TableWrapData(128);
        gd.colspan = 2;
        fSearchLocationDescLabel.setLayoutData((Object)gd);
        this.fSearchRootButton = toolkit.createButton(container, PDEUIMessages.SiteEditor_IncludedFeaturesDetailsSection_root, 16);
        this.fSearchRootButton.setSelection(true);
        gd = new TableWrapData(128);
        gd.colspan = 2;
        gd.indent = 5;
        this.fSearchRootButton.setLayoutData((Object)gd);
        this.fSearchRootButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!IncludedFeaturesDetailsSection.this.fBlockNotification) {
                    try {
                        if (IncludedFeaturesDetailsSection.this.fSearchRootButton.getSelection()) {
                            IncludedFeaturesDetailsSection.this.fInput.setSearchLocation(0);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
        this.fSearchSelfButton = toolkit.createButton(container, PDEUIMessages.SiteEditor_IncludedFeaturesDetailsSection_self, 16);
        this.fSearchSelfButton.setSelection(true);
        gd = new TableWrapData(128);
        gd.colspan = 2;
        gd.indent = 5;
        this.fSearchSelfButton.setLayoutData((Object)gd);
        this.fSearchSelfButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!IncludedFeaturesDetailsSection.this.fBlockNotification) {
                    try {
                        if (IncludedFeaturesDetailsSection.this.fSearchSelfButton.getSelection()) {
                            IncludedFeaturesDetailsSection.this.fInput.setSearchLocation(1);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
        this.fSearchBothButton = toolkit.createButton(container, PDEUIMessages.SiteEditor_IncludedFeaturesDetailsSection_both, 16);
        this.fSearchBothButton.setSelection(true);
        gd = new TableWrapData(128);
        gd.colspan = 2;
        gd.indent = 5;
        this.fSearchBothButton.setLayoutData((Object)gd);
        this.fSearchBothButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!IncludedFeaturesDetailsSection.this.fBlockNotification) {
                    try {
                        if (IncludedFeaturesDetailsSection.this.fSearchBothButton.getSelection()) {
                            IncludedFeaturesDetailsSection.this.fInput.setSearchLocation(2);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize(IManagedForm form) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
        super.initialize(form);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    public void refresh() {
        this.update();
        super.refresh();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object o;
        this.fInput = selection instanceof IStructuredSelection && !selection.isEmpty() ? ((o = ((IStructuredSelection)selection).getFirstElement()) instanceof IFeatureChild ? (IFeatureChild)o : null) : null;
        this.update();
    }

    public void setFocus() {
        if (this.fNameText != null) {
            this.fNameText.getText().setFocus();
        }
    }

    private void update() {
        this.fBlockNotification = true;
        if (this.fInput != null) {
            this.fNameText.setValue(this.fInput.getName(), true);
            this.fVersionText.setValue(this.fInput.getVersion(), true);
            this.fOptionalButton.setSelection(this.fInput.isOptional());
            int searchLocation = this.fInput.getSearchLocation();
            this.fSearchRootButton.setSelection(searchLocation == 0);
            this.fSearchSelfButton.setSelection(searchLocation == 1);
            this.fSearchBothButton.setSelection(searchLocation == 2);
        } else {
            this.fNameText.setValue(null, true);
            this.fVersionText.setValue(null, true);
            this.fOptionalButton.setSelection(false);
            this.fSearchRootButton.setSelection(true);
            this.fSearchSelfButton.setSelection(false);
            this.fSearchBothButton.setSelection(false);
        }
        boolean editable = this.fInput != null && this.isEditable();
        this.fNameText.setEditable(editable);
        this.fVersionText.setEditable(editable);
        this.fOptionalButton.setEnabled(editable);
        this.fSearchRootButton.setEnabled(editable);
        this.fSearchSelfButton.setEnabled(editable);
        this.fSearchBothButton.setEnabled(editable);
        this.fBlockNotification = false;
    }

    @Override
    public boolean isEditable() {
        return this.getPage().getPDEEditor().getAggregateModel().isEditable();
    }
}

