/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.requirement.provider;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.diagram.requirement.Activator;
import org.eclipse.papyrus.sysml.diagram.requirement.provider.ElementTypes;
import org.eclipse.papyrus.sysml.diagram.requirement.provider.GraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.requirement.provider.IGraphicalTypeRegistry;
import org.eclipse.papyrus.uml.diagram.clazz.providers.UMLViewProvider;

public class InheritedClassDiagramViewProvider
extends UMLViewProvider {
    protected IGraphicalTypeRegistry registry = new GraphicalTypeRegistry();

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge createdEdge = null;
        IElementType elementType = (IElementType)semanticAdapter.getAdapter(IElementType.class);
        if (elementType != null) {
            createdEdge = super.createEdge(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
        } else {
            EObject domainElement = (EObject)semanticAdapter.getAdapter(EObject.class);
            String domainElementGraphicalType = semanticHint;
            if (domainElementGraphicalType == null) {
                domainElementGraphicalType = this.registry.getEdgeGraphicalType(domainElement);
            }
            if (!"undefined_type".equals(domainElementGraphicalType) && this.registry.isKnownEdgeType(domainElementGraphicalType)) {
                if (ElementTypes.ABSTRACTION.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createAbstraction_Edge(domainElement, containerView, index, persisted, preferencesHint);
                }
                if (ElementTypes.CONTAINMENT_LINK.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createElement_ContainmentEdge(containerView, index, persisted, preferencesHint);
                }
                if (ElementTypes.DEPENDENCY.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createDependency_Edge(domainElement, containerView, index, persisted, preferencesHint);
                }
                if (ElementTypes.COMMENT_ANNOTATED_ELEMENT.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createComment_AnnotatedElementEdge(containerView, index, persisted, preferencesHint);
                }
                if (ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createConstraint_ConstrainedElementEdge(containerView, index, persisted, preferencesHint);
                }
                if (ElementTypes.REALIZATION.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createRealization_Edge(domainElement, containerView, index, persisted, preferencesHint);
                }
                if (ElementTypes.PACKAGE_IMPORT.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createPackageImport_Edge(domainElement, containerView, index, persisted, preferencesHint);
                }
            }
        }
        if (createdEdge == null) {
            Activator.log.error((Throwable)new Exception("Could not create Edge."));
        }
        return createdEdge;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String diagramType = op.getContainerView().getDiagram().getType();
        return "RequirementDiagram".equals(diagramType);
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        if (op.getContainerView() == null) {
            return false;
        }
        String diagramType = op.getContainerView().getDiagram().getType();
        if (!"RequirementDiagram".equals(diagramType)) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (elementType == ElementTypes.ABSTRACTION) {
            return true;
        }
        if (elementType == ElementTypes.CONTAINMENT_LINK) {
            return true;
        }
        if (elementType == ElementTypes.DEPENDENCY) {
            return true;
        }
        if (elementType == ElementTypes.COMMENT_ANNOTATED_ELEMENT) {
            return true;
        }
        if (elementType == ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT) {
            return true;
        }
        if (elementType == ElementTypes.REALIZATION) {
            return true;
        }
        if (elementType == ElementTypes.PACKAGE_IMPORT) {
            return true;
        }
        if (elementType == null) {
            EObject domainElement = (EObject)op.getSemanticAdapter().getAdapter(EObject.class);
            String domainElementGraphicalType = op.getSemanticHint();
            if (domainElementGraphicalType == null) {
                domainElementGraphicalType = this.registry.getEdgeGraphicalType(domainElement);
            }
            if (!"undefined_type".equals(domainElementGraphicalType) && this.registry.isKnownEdgeType(domainElementGraphicalType)) {
                return true;
            }
        }
        return false;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        if (op.getContainerView() == null) {
            return false;
        }
        String containerGraphicalType = op.getContainerView().getType();
        String diagramType = op.getContainerView().getDiagram().getType();
        if (!"RequirementDiagram".equals(diagramType)) {
            return false;
        }
        IElementType elementType = (IElementType)op.getSemanticAdapter().getAdapter(IElementType.class);
        if (elementType == ElementTypes.PACKAGE && "RequirementDiagram".equals(containerGraphicalType)) {
            return true;
        }
        if (elementType == ElementTypes.PACKAGE_CN) {
            if ("Package_PackagedElementCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
            if ("Package_PackagedElementCompartment".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CLASS && "RequirementDiagram".equals(containerGraphicalType)) {
            return true;
        }
        if (elementType == ElementTypes.CLASS_CN) {
            if ("Package_PackagedElementCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
            if ("Package_PackagedElementCompartment".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.DEFAULT_NAMED_ELEMENT && "RequirementDiagram".equals(containerGraphicalType)) {
            return true;
        }
        if (elementType == ElementTypes.COMMENT && "RequirementDiagram".equals(containerGraphicalType)) {
            return true;
        }
        if (elementType == ElementTypes.COMMENT_CN) {
            if ("Package_PackagedElementCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
            if ("Package_PackagedElementCompartment".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CONSTRAINT && "RequirementDiagram".equals(containerGraphicalType)) {
            return true;
        }
        if (elementType == ElementTypes.CONSTRAINT_CN) {
            if ("Package_PackagedElementCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
            if ("Package_PackagedElementCompartment".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CLASS_PROPERTY_CLN) {
            if ("Class_AttributeCompartment".equals(containerGraphicalType)) {
                return true;
            }
            if ("Class_AttributeCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CLASS_RECEPTION_CLN) {
            if ("Class_OperationCompartment".equals(containerGraphicalType)) {
                return true;
            }
            if ("Class_OperationCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CLASS_OPERATION_CLN) {
            if ("Class_OperationCompartment".equals(containerGraphicalType)) {
                return true;
            }
            if ("Class_OperationCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CLASS_CLASS_CLN) {
            if ("Class_NestedClassifierCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
            if ("Class_NestedClassifierCompartment".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CLASS_INTERFACE_CLN) {
            if ("Class_NestedClassifierCompartment".equals(containerGraphicalType)) {
                return true;
            }
            if ("Class_NestedClassifierCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CLASS_ENUMERATION_CLN) {
            if ("Class_NestedClassifierCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
            if ("Class_NestedClassifierCompartment".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CLASS_PRIMITIVE_TYPE_CLN) {
            if ("Class_NestedClassifierCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
            if ("Class_NestedClassifierCompartment".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CLASS_DATA_TYPE_CLN) {
            if ("Class_NestedClassifierCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
            if ("Class_NestedClassifierCompartment".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CLASS_SIGNAL_CLN) {
            if ("Class_NestedClassifierCompartment_CN".equals(containerGraphicalType)) {
                return true;
            }
            if ("Class_NestedClassifierCompartment".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == null) {
            EObject domainElement = (EObject)op.getSemanticAdapter().getAdapter(EObject.class);
            String domainElementGraphicalType = op.getSemanticHint();
            domainElementGraphicalType = domainElementGraphicalType == null ? this.registry.getNodeGraphicalType(domainElement, containerGraphicalType) : this.registry.getNodeGraphicalType(domainElementGraphicalType, containerGraphicalType);
            if (!"undefined_type".equals(domainElementGraphicalType) && this.registry.isKnownNodeType(domainElementGraphicalType)) {
                return true;
            }
        }
        return false;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        if (semanticHint != null) {
            return super.createNode(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
        }
        String containerGraphicalType = containerView.getType();
        EObject domainElement = (EObject)semanticAdapter.getAdapter(EObject.class);
        String domainElementGraphicalType = this.registry.getNodeGraphicalType(domainElement, containerGraphicalType);
        if (!"undefined_type".equals(domainElementGraphicalType)) {
            return super.createNode(semanticAdapter, containerView, domainElementGraphicalType, index, persisted, preferencesHint);
        }
        Activator.log.error((Throwable)new Exception("Could not create Node."));
        return null;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"RequirementDiagram".equals(containerView.getDiagram().getType())) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"RequirementDiagram");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }
}

