/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.TreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IPasteConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.provider.PasteInSelectionNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.InsertedElementInNattable;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class PasteInSelectionTreeNattableCommandProvider
extends PasteInSelectionNattableCommandProvider {
    public PasteInSelectionTreeNattableCommandProvider(INattableModelManager tableManager, boolean pasteColumn, boolean isInsert, Reader reader, CSVPasteHelper pasteHelper, TableSelectionWrapper tableSelectionWrapper, int preferredUserAction, long totalSize) {
        super(tableManager, pasteColumn, isInsert, reader, pasteHelper, tableSelectionWrapper, preferredUserAction, totalSize);
    }

    @Override
    protected void init() {
        super.init();
        this.detachedMode = this.isPasteInDetachedMode(this.table);
    }

    protected PasteEObjectConfiguration getPasteConfigurationsFor(Table table, int depth, String categoryName) {
        if (depth == 0 && !FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(table, 0)) {
            LocalTableHeaderAxisConfiguration conf = table.getLocalRowHeaderAxisConfiguration();
            if (conf != null) {
                conf = table.getTableConfiguration().getRowHeaderAxisConfiguration();
            }
            List<TreeFillingConfiguration> filling = FillingConfigurationUtils.getAllTreeFillingConfigurationForDepth(table, depth);
            ArrayList<PasteEObjectConfiguration> referencedPasteConf = new ArrayList<PasteEObjectConfiguration>();
            for (TreeFillingConfiguration tmp : filling) {
                if (tmp.getPasteConfiguration() == null) continue;
                referencedPasteConf.add(tmp.getPasteConfiguration());
            }
            for (IAxisConfiguration axisConf : conf.getOwnedAxisConfigurations()) {
                if (!(axisConf instanceof PasteEObjectConfiguration) || referencedPasteConf.contains(axisConf)) continue;
                return (PasteEObjectConfiguration)axisConf;
            }
        }
        for (TreeFillingConfiguration curr : FillingConfigurationUtils.getAllTreeFillingConfiguration(table)) {
            Object element;
            if (curr.getDepth() != depth) continue;
            if (categoryName == null || categoryName.isEmpty()) {
                return curr.getPasteConfiguration();
            }
            String featureName = curr.getAxisUsedAsAxisProvider().getAlias();
            if ((featureName == null || "".equals(featureName)) && (element = curr.getAxisUsedAsAxisProvider().getElement()) instanceof EStructuralFeature) {
                featureName = ((EStructuralFeature)element).getName();
            }
            if (!categoryName.equals(featureName)) continue;
            return curr.getPasteConfiguration();
        }
        return null;
    }

    @Override
    protected PasteEObjectConfiguration getPasteConfiguration(Table table, int currentDepth, String categoryName) {
        return this.getPasteConfigurationsFor(table, currentDepth, categoryName);
    }

    protected PasteEObjectConfiguration getPasteConfigurationForFullSynchroTable(Table table) {
        PasteEObjectConfiguration pasteEObjectConfiguration = null;
        IPasteConfiguration pasteConfiguration = (IPasteConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(table, NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), false);
        if (pasteConfiguration instanceof PasteEObjectConfiguration) {
            pasteEObjectConfiguration = (PasteEObjectConfiguration)pasteConfiguration;
        }
        return pasteEObjectConfiguration;
    }

    @Override
    protected PasteEObjectConfiguration getPasteconfigurationTopLevel(Table table) {
        if (this.pasteConfigurationTopLevel == null) {
            boolean fullSynchro = FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.tableManager.getTable(), 0);
            this.pasteConfigurationTopLevel = fullSynchro ? this.getPasteConfigurationForFullSynchroTable(this.tableManager.getTable()) : this.getPasteConfigurationsFor(table, 0, null);
        }
        return this.pasteConfigurationTopLevel;
    }

    @Override
    protected int getDepthFromObject(Object object) {
        int depth = -1;
        if (object instanceof ITreeItemAxis) {
            depth = ((TreeNattableModelManager)this.tableManager).getSemanticDepth((ITreeItemAxis)object);
        }
        return -1 == depth ? super.getDepthFromObject(object) : depth;
    }

    @Override
    protected String getCategoryFromObject(Object object) {
        String category = "";
        if (object instanceof ITreeItemAxis) {
            if (((ITreeItemAxis)object).getElement() instanceof TreeFillingConfiguration) {
                Object element;
                TreeFillingConfiguration configuration = (TreeFillingConfiguration)((ITreeItemAxis)object).getElement();
                category = configuration.getAxisUsedAsAxisProvider().getAlias();
                if ((category == null || "".equals(category)) && (element = configuration.getAxisUsedAsAxisProvider().getElement()) instanceof EStructuralFeature) {
                    category = ((EStructuralFeature)element).getName();
                }
            } else if (((ITreeItemAxis)object).getParent() != null) {
                ITreeItemAxis parentAxis = ((ITreeItemAxis)object).getParent();
                category = this.getCategoryFromObject(parentAxis);
            }
        }
        return category;
    }

    @Override
    protected Object getRowElementCreatedInAttachedMode(EObject context, EStructuralFeature containmentFeature, IElementType typeToCreate, IProgressMonitor monitor, IAdaptable info, CompoundCommand compoundCommand) {
        Object createdElement = null;
        if (!containmentFeature.isDerived() && containmentFeature.isChangeable()) {
            CreateElementRequest createRequest1 = new CreateElementRequest(this.contextEditingDomain, context, typeToCreate, (EReference)containmentFeature);
            IElementEditService creationContextCommandProvider = ElementEditServiceUtils.getCommandProvider((Object)context);
            ICommand commandCreation = creationContextCommandProvider.getEditCommand((IEditCommandRequest)createRequest1);
            if (commandCreation != null && commandCreation.canExecute()) {
                Command emfCommandCreation = GMFtoEMFCommandWrapper.wrap((ICommand)commandCreation);
                emfCommandCreation.execute();
                compoundCommand.append(emfCommandCreation);
                CommandResult res = commandCreation.getCommandResult();
                createdElement = res.getReturnValue();
            }
        }
        return createdElement;
    }

    @Override
    protected void createTableRowInAttachedModeCommand(CompoundCommand compoundCommand, List<InsertedElementInNattable> createdElements) throws ExecutionException {
        CompoundCommand addCommand = new CompoundCommand("Create table row");
        int insertedElementIndex = createdElements.size() - 1;
        while (insertedElementIndex >= 0) {
            InsertedElementInNattable currentInsertedElement = createdElements.get(insertedElementIndex);
            if (-1 != currentInsertedElement.getIndexInParent()) {
                int addedIndex = 0;
                for (Object createdElement : currentInsertedElement.getCreatedElements()) {
                    addCommand.append(MoveCommand.create((EditingDomain)this.contextEditingDomain, (Object)currentInsertedElement.getContext(), (Object)currentInsertedElement.getContainementFeature(), (Object)createdElement, (int)(currentInsertedElement.getIndexInParent() + addedIndex)));
                    ++addedIndex;
                }
            }
            --insertedElementIndex;
        }
        if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0)) {
            for (InsertedElementInNattable currentInsertedElement : createdElements) {
                if (-1 != currentInsertedElement.getIndexInTable()) {
                    if (this.pasteColumn) {
                        Command addColumnElementCommand = this.tableManager.getAddColumnElementCommand(currentInsertedElement.getCreatedElements(), currentInsertedElement.getIndexInTable());
                        if (!addColumnElementCommand.canExecute()) continue;
                        addCommand.append(addColumnElementCommand);
                        continue;
                    }
                    Command addRowElementCommand = this.tableManager.getAddRowElementCommand(currentInsertedElement.getCreatedElements(), currentInsertedElement.getIndexInTable());
                    if (!addRowElementCommand.canExecute()) continue;
                    addCommand.append(addRowElementCommand);
                    continue;
                }
                if (this.pasteColumn) {
                    Command addColumnElementCommand = this.tableManager.getAddColumnElementCommand(currentInsertedElement.getCreatedElements());
                    if (!addColumnElementCommand.canExecute()) continue;
                    addCommand.append(addColumnElementCommand);
                    continue;
                }
                Command addRowElementCommand = this.tableManager.getAddRowElementCommand(currentInsertedElement.getCreatedElements());
                if (!addRowElementCommand.canExecute()) continue;
                addCommand.append(addRowElementCommand);
            }
        }
        if (!addCommand.isEmpty()) {
            compoundCommand.append((Command)addCommand);
        }
    }

    @Override
    protected Object getRowElementCreatedInDetachedMode(EStructuralFeature containmentFeature, IElementType typeToCreate, IProgressMonitor monitor, IAdaptable info, CompoundCommand compoundCommand) {
        EObject result = null;
        if (!containmentFeature.isDerived() && containmentFeature.isChangeable()) {
            EClass eClassToCreate = typeToCreate.getEClass();
            EFactory eFactory = eClassToCreate.getEPackage().getEFactoryInstance();
            result = eFactory.create(eClassToCreate);
        }
        return result;
    }

    @Override
    protected void createTableRowInDetachedModeCommand(CompoundCommand compoundCommand, List<InsertedElementInNattable> createdElements) throws ExecutionException {
        CompoundCommand addCommand = new CompoundCommand("Create table row");
        int insertedElementIndex = createdElements.size() - 1;
        while (insertedElementIndex >= 0) {
            InsertedElementInNattable currentInsertedElement = createdElements.get(insertedElementIndex);
            if (currentInsertedElement.getContainementFeature().isMany()) {
                if (-1 != currentInsertedElement.getIndexInParent()) {
                    addCommand.append(AddCommand.create((EditingDomain)this.contextEditingDomain, (Object)currentInsertedElement.getContext(), (Object)currentInsertedElement.getContainementFeature(), currentInsertedElement.getCreatedElements(), (int)currentInsertedElement.getIndexInParent()));
                } else {
                    addCommand.append(AddCommand.create((EditingDomain)this.contextEditingDomain, (Object)currentInsertedElement.getContext(), (Object)currentInsertedElement.getContainementFeature(), currentInsertedElement.getCreatedElements()));
                }
            } else {
                addCommand.append(SetCommand.create((EditingDomain)this.contextEditingDomain, (Object)currentInsertedElement.getContext(), (Object)currentInsertedElement.getContainementFeature(), (Object)currentInsertedElement.getCreatedElements().get(0)));
            }
            --insertedElementIndex;
        }
        if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0)) {
            for (InsertedElementInNattable currentInsertedElement : createdElements) {
                Command addRowElementCommand;
                Command addColumnElementCommand;
                if (-1 != currentInsertedElement.getIndexInTable()) {
                    if (this.pasteColumn) {
                        addColumnElementCommand = this.tableManager.getAddColumnElementCommand(currentInsertedElement.getCreatedElements(), currentInsertedElement.getIndexInTable());
                        if (!addColumnElementCommand.canExecute()) continue;
                        addCommand.append(addColumnElementCommand);
                        continue;
                    }
                    addRowElementCommand = this.tableManager.getAddRowElementCommand(currentInsertedElement.getCreatedElements(), currentInsertedElement.getIndexInTable());
                    if (!addRowElementCommand.canExecute()) continue;
                    addCommand.append(addRowElementCommand);
                    continue;
                }
                if (this.pasteColumn) {
                    addColumnElementCommand = this.tableManager.getAddColumnElementCommand(currentInsertedElement.getCreatedElements());
                    if (!addColumnElementCommand.canExecute()) continue;
                    addCommand.append(addColumnElementCommand);
                    continue;
                }
                addRowElementCommand = this.tableManager.getAddRowElementCommand(currentInsertedElement.getCreatedElements());
                if (!addRowElementCommand.canExecute()) continue;
                addCommand.append(addRowElementCommand);
            }
        }
        if (!addCommand.isEmpty()) {
            compoundCommand.append((Command)addCommand);
        }
    }

    @Override
    protected int getFirstSelectedElementIndexOfTableContext(Map<Integer, Object> rows, int currentRowIndex, EObject context) {
        Object axis;
        Object object;
        int initialFirstIndexInParent = -1;
        if (this.isInsert && (object = AxisUtils.getRepresentedElement(axis = rows.get(currentRowIndex))) instanceof EObject) {
            initialFirstIndexInParent = object instanceof TreeFillingConfiguration ? 0 : super.getFirstSelectedElementIndexOfTableContext(rows, currentRowIndex, context);
        }
        return initialFirstIndexInParent;
    }

    @Override
    protected Object getColumnElement(int realColumnIndex) {
        return AxisUtils.getRepresentedElement(this.tableManager.getColumnElement(realColumnIndex));
    }

    @Override
    protected EObject getContentOfSelection(Map<Integer, Object> rows, int currentRowIndex) {
        EObject context = null;
        if (currentRowIndex == 0) {
            context = this.table.getContext();
        } else {
            Object axis = rows.get(currentRowIndex);
            Object object = AxisUtils.getRepresentedElement(axis);
            if (object instanceof TreeFillingConfiguration && axis instanceof ITreeItemAxis) {
                if ((axis = ((ITreeItemAxis)axis).getParent()) != null) {
                    context = (EObject)AxisUtils.getRepresentedElement(axis);
                }
            } else if (object instanceof EObject) {
                context = ((EObject)object).eContainer();
            }
        }
        return context;
    }
}

