/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.pkm.refframework.refframework.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewDiagramResourceWizardPage;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewResourceWizardPage;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.DawnRefframeworkDiagramEditorUtil;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.Messages;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkCreationWizard;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkDiagramEditorPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DawnRefframeworkCreationWizard
extends RefframeworkCreationWizard {
    private CDOView view;
    private DawnCreateNewDiagramResourceWizardPage dawnDiagramModelFilePage;
    private DawnCreateNewResourceWizardPage dawnDomainModelFilePage;

    public DawnRefframeworkCreationWizard() {
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession session = CDOConnectionUtil.instance.openSession();
        this.view = CDOConnectionUtil.instance.openView(session);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                URI diagramResourceURI = DawnRefframeworkCreationWizard.this.dawnDiagramModelFilePage.getURI();
                URI domainModelResourceURI = DawnRefframeworkCreationWizard.this.dawnDomainModelFilePage.getURI();
                DawnRefframeworkCreationWizard.this.diagram = DawnRefframeworkDiagramEditorUtil.createDiagram(diagramResourceURI, domainModelResourceURI, monitor);
                if (DawnRefframeworkCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && DawnRefframeworkCreationWizard.this.diagram != null) {
                    try {
                        DawnRefframeworkDiagramEditorUtil.openDiagram(DawnRefframeworkCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)DawnRefframeworkCreationWizard.this.getContainer().getShell(), (String)Messages.RefframeworkCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.RefframeworkCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                RefframeworkDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public void addPages() {
        this.dawnDiagramModelFilePage = new DawnCreateNewDiagramResourceWizardPage("refframework_diagram", false, this.view);
        this.dawnDiagramModelFilePage.setTitle(Messages.RefframeworkCreationWizard_DiagramModelFilePageTitle);
        this.dawnDiagramModelFilePage.setDescription(Messages.RefframeworkCreationWizard_DiagramModelFilePageDescription);
        this.dawnDiagramModelFilePage.setCreateAutomaticResourceName(true);
        this.addPage((IWizardPage)this.dawnDiagramModelFilePage);
        this.dawnDomainModelFilePage = new DawnCreateNewResourceWizardPage("refframework", false, this.view){

            public void setVisible(boolean visible) {
                if (visible) {
                    URI uri = DawnRefframeworkCreationWizard.this.dawnDiagramModelFilePage.getURI();
                    String fileName = uri.lastSegment();
                    fileName = fileName.substring(0, fileName.length() - ".refframework_diagram".length());
                    fileName = String.valueOf(fileName) + ".refframework";
                    DawnRefframeworkCreationWizard.this.dawnDomainModelFilePage.setResourceNamePrefix(fileName);
                    DawnRefframeworkCreationWizard.this.dawnDomainModelFilePage.setResourcePath(DawnRefframeworkCreationWizard.this.dawnDiagramModelFilePage.getResourcePath());
                }
                super.setVisible(visible);
            }
        };
        this.dawnDomainModelFilePage.setTitle(Messages.RefframeworkCreationWizard_DomainModelFilePageTitle);
        this.dawnDomainModelFilePage.setDescription(Messages.RefframeworkCreationWizard_DomainModelFilePageDescription);
        this.dawnDomainModelFilePage.setResourceValidationType(1);
        this.addPage((IWizardPage)this.dawnDomainModelFilePage);
    }

    public void dispose() {
        this.view.close();
    }
}

