/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors.richtext;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.richtext.BaseDialog;
import org.eclipse.papyrus.infra.widgets.editors.richtext.SpellChecker;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CheckSpellDialog
extends BaseDialog {
    private SpellChecker spellChecker;
    private Queue<String> misspelledWords = new LinkedList<String>();
    private Text wrongWord;
    private org.eclipse.swt.widgets.List suggestedWords;
    private Button ignoreButton;
    private Button changeButton;
    private IgnoreButtonListener ignoreButtonListener = new IgnoreButtonListener();
    private ChangeButtonListener changeButtonListener = new ChangeButtonListener();
    private ModifiedChangeButtonListener modifiedChangeButtonListener = new ModifiedChangeButtonListener();
    private ModifiedIgnoreButtonListener modifiedIgnoreButtonListener = new ModifiedIgnoreButtonListener();
    private String oldWrongWord;
    private int currentWord = 1;
    private int totalWords;
    private RichTextEditor richText;
    private String noHTMLString;

    public CheckSpellDialog(Shell parent, RichTextEditor richText) {
        super(parent);
        this.setShellStyle(0x860 | CheckSpellDialog.getDefaultOrientation());
        this.richText = richText;
        if (richText != null) {
            try {
                this.spellChecker = new SpellChecker();
                this.findMisspelledWords();
            }
            catch (URISyntaxException e) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.CheckSpellDialog_DictionaryFileNotFound, (String)e.getMessage());
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Dictionary file for rich text editor not found", (String)e.getMessage());
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(composite, 0).setText(Messages.CheckSpellDialog_NotInDictionary);
        new Label(composite, 0);
        this.wrongWord = new Text(composite, 2626);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 75;
        gd.minimumHeight = 75;
        this.wrongWord.setLayoutData((Object)gd);
        this.wrongWord.addKeyListener((KeyListener)new WrongWordKeyListener());
        this.wrongWord.addFocusListener((FocusListener)new WrongWordFocusListener());
        GridData buttonCompositeGridData = new GridData(4, 4, false, true);
        buttonCompositeGridData.widthHint = 125;
        Composite topButtonActionsComposite = new Composite(composite, 0);
        topButtonActionsComposite.setLayout((Layout)new GridLayout());
        topButtonActionsComposite.setLayoutData((Object)buttonCompositeGridData);
        this.ignoreButton = new Button(topButtonActionsComposite, 8);
        this.ignoreButton.setText(Messages.CheckSpellDialog_Ignore);
        this.ignoreButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ignoreButton.addSelectionListener((SelectionListener)this.ignoreButtonListener);
        new Label(composite, 0).setText(Messages.CheckSpellDialog_Suggestions);
        new Label(composite, 0);
        this.suggestedWords = new org.eclipse.swt.widgets.List(composite, 2564);
        this.suggestedWords.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite bottomButtonActionsComposite = new Composite(composite, 0);
        bottomButtonActionsComposite.setLayout((Layout)new GridLayout());
        bottomButtonActionsComposite.setLayoutData((Object)buttonCompositeGridData);
        this.changeButton = new Button(bottomButtonActionsComposite, 8);
        this.changeButton.setText(Messages.CheckSpellDialog_Change);
        this.changeButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.changeButton.addSelectionListener((SelectionListener)this.changeButtonListener);
        this.startSpellChecking();
        return composite;
    }

    private void startSpellChecking() {
        if (!this.misspelledWords.isEmpty()) {
            super.getShell().setText(String.valueOf(Messages.CheckSpellDialog_SpellChecker) + " (" + this.currentWord + "/" + this.totalWords + ")");
            String firstWord = this.misspelledWords.poll();
            HashMap<Integer, String> suggestions = this.spellChecker.suggestions(firstWord);
            List<Integer> sortedKeys = CheckSpellDialog.asSortedList(suggestions.keySet());
            this.wrongWord.setText(firstWord);
            this.suggestedWords.removeAll();
            for (Integer i : sortedKeys) {
                this.suggestedWords.add(suggestions.get(i));
            }
            if (suggestions.size() == 0) {
                this.suggestedWords.add(Messages.CheckSpellDialog_NoSuggestions);
                this.changeButton.setEnabled(false);
            } else {
                this.changeButton.setEnabled(true);
            }
            this.suggestedWords.select(0);
            ++this.currentWord;
        } else {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.CheckSpellDialog_NoMisspellings, (String)Messages.CheckSpellDialog_NoMoreMisspelledWord);
            super.close();
        }
    }

    private void findMisspelledWords() {
        String[] cleanWords;
        this.misspelledWords.clear();
        String[] stringArray = cleanWords = this.cleanText(this.richText.getText());
        int n = cleanWords.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (!(word.equals(" ") || word.isEmpty() || this.spellChecker.isInDictionary(word))) {
                this.misspelledWords.add(word);
            }
            ++n2;
        }
        this.totalWords = this.misspelledWords.size();
    }

    protected String[] cleanText(String text) {
        this.noHTMLString = text;
        this.noHTMLString = this.noHTMLString.replaceAll("\\<.*?>", "");
        this.noHTMLString = this.noHTMLString.replaceAll("&.*?;", "");
        if (this.noHTMLString.contains("<")) {
            int length = 0;
            while (this.noHTMLString.length() != length) {
                length = this.htmlTagRemoval(this.noHTMLString);
            }
        }
        this.noHTMLString = this.noHTMLString.replaceAll("[\\t\\n\\r]", " ");
        String[] allWords = this.noHTMLString.split(" ");
        ArrayList<String> cleanedAllWords = new ArrayList<String>();
        String[] stringArray = allWords;
        int n = allWords.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (!this.containsOnlyLetters(word = word.trim())) {
                word = this.removeNonLetters(word);
            }
            cleanedAllWords.add(word);
            ++n2;
        }
        int i = 0;
        while (i < cleanedAllWords.size()) {
            cleanedAllWords.set(i, ((String)cleanedAllWords.get(i)).toLowerCase());
            ++i;
        }
        return cleanedAllWords.toArray(new String[cleanedAllWords.size()]);
    }

    private int htmlTagRemoval(String string) {
        int i = 0;
        Integer start = null;
        Integer end = null;
        i = 0;
        while (i < string.length()) {
            if (string.toCharArray()[i] == '<') {
                start = i;
            }
            if (start != null && string.toCharArray()[i] == '>') {
                end = i;
                this.noHTMLString = string.replace(string.subSequence(start, end + 1), "");
                break;
            }
            ++i;
        }
        return i;
    }

    private boolean containsOnlyLetters(String s) {
        return Pattern.matches("[a-zA-Z]+", s);
    }

    private String removeNonLetters(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (Character.isLetter(s.charAt(i)) || s.charAt(i) == '\'') {
                sb = sb.append(s.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    private static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        Collections.reverse(list);
        return list;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = 500;
        size.y = 350;
        return size;
    }

    private class ChangeButtonListener
    extends SelectionAdapter {
        private ChangeButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String newWord = CheckSpellDialog.this.suggestedWords.getSelection()[0];
            String correctedChanges = CheckSpellDialog.this.richText.getText().replace(CheckSpellDialog.this.wrongWord.getText(), newWord);
            CheckSpellDialog.this.richText.setText(correctedChanges);
            CheckSpellDialog.this.startSpellChecking();
        }
    }

    private class IgnoreButtonListener
    extends SelectionAdapter {
        private IgnoreButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            CheckSpellDialog.this.startSpellChecking();
        }
    }

    private class ModifiedChangeButtonListener
    extends SelectionAdapter {
        private ModifiedChangeButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String newWord = CheckSpellDialog.this.wrongWord.getText();
            String correctedChanges = CheckSpellDialog.this.richText.getText().replace(CheckSpellDialog.this.oldWrongWord, newWord);
            CheckSpellDialog.this.richText.setText(correctedChanges);
            CheckSpellDialog.this.ignoreButton.setText(Messages.CheckSpellDialog_Ignore);
            CheckSpellDialog.this.ignoreButton.removeSelectionListener((SelectionListener)CheckSpellDialog.this.modifiedIgnoreButtonListener);
            CheckSpellDialog.this.ignoreButton.addSelectionListener((SelectionListener)CheckSpellDialog.this.ignoreButtonListener);
            CheckSpellDialog.this.changeButton.removeSelectionListener((SelectionListener)CheckSpellDialog.this.modifiedChangeButtonListener);
            CheckSpellDialog.this.changeButton.addSelectionListener((SelectionListener)CheckSpellDialog.this.changeButtonListener);
            CheckSpellDialog.this.suggestedWords.setEnabled(true);
            CheckSpellDialog.this.wrongWord.addKeyListener((KeyListener)new WrongWordKeyListener());
            CheckSpellDialog.this.startSpellChecking();
        }
    }

    private class ModifiedIgnoreButtonListener
    extends SelectionAdapter {
        private ModifiedIgnoreButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            CheckSpellDialog.this.ignoreButton.setText(Messages.CheckSpellDialog_Ignore);
            CheckSpellDialog.this.ignoreButton.removeSelectionListener((SelectionListener)CheckSpellDialog.this.modifiedIgnoreButtonListener);
            CheckSpellDialog.this.ignoreButton.addSelectionListener((SelectionListener)CheckSpellDialog.this.ignoreButtonListener);
            CheckSpellDialog.this.changeButton.removeSelectionListener((SelectionListener)CheckSpellDialog.this.modifiedChangeButtonListener);
            CheckSpellDialog.this.changeButton.addSelectionListener((SelectionListener)CheckSpellDialog.this.changeButtonListener);
            CheckSpellDialog.this.suggestedWords.setEnabled(true);
            CheckSpellDialog.this.wrongWord.setText(CheckSpellDialog.this.oldWrongWord);
            CheckSpellDialog.this.wrongWord.addKeyListener((KeyListener)new WrongWordKeyListener());
            if (CheckSpellDialog.this.suggestedWords.getItem(0).equals(Messages.CheckSpellDialog_NoSuggestions)) {
                CheckSpellDialog.this.changeButton.setEnabled(false);
            }
        }
    }

    private class WrongWordFocusListener
    extends FocusAdapter {
        private WrongWordFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            CheckSpellDialog.this.oldWrongWord = CheckSpellDialog.this.wrongWord.getText();
            super.focusGained(e);
        }
    }

    private class WrongWordKeyListener
    extends KeyAdapter {
        private WrongWordKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            CheckSpellDialog.this.suggestedWords.setEnabled(false);
            CheckSpellDialog.this.ignoreButton.setEnabled(true);
            CheckSpellDialog.this.ignoreButton.setText(Messages.CheckSpellDialog_UndoEdit);
            CheckSpellDialog.this.ignoreButton.removeSelectionListener((SelectionListener)CheckSpellDialog.this.ignoreButtonListener);
            CheckSpellDialog.this.ignoreButton.addSelectionListener((SelectionListener)CheckSpellDialog.this.modifiedIgnoreButtonListener);
            CheckSpellDialog.this.changeButton.setEnabled(true);
            CheckSpellDialog.this.changeButton.removeSelectionListener((SelectionListener)CheckSpellDialog.this.changeButtonListener);
            CheckSpellDialog.this.changeButton.addSelectionListener((SelectionListener)CheckSpellDialog.this.modifiedChangeButtonListener);
            CheckSpellDialog.this.wrongWord.removeKeyListener((KeyListener)this);
        }
    }
}

