/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.importer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.cdo.core.importer.IModelDependentsProvider;
import org.eclipse.papyrus.cdo.internal.core.Activator;
import org.eclipse.papyrus.cdo.internal.core.importer.DependencyAdapter;

public class WorkspaceDIDependentsProvider
implements IModelDependentsProvider {
    private boolean completedScan;

    @Override
    public Collection<URI> getDependents(Resource resource, IProgressMonitor monitor) {
        if (!this.completedScan) {
            this.scanWorkspace(resource.getResourceSet());
        }
        HashSet result = Sets.newHashSet();
        Resource di = DependencyAdapter.getDIResource(resource);
        if (di != null) {
            for (Resource component : DependencyAdapter.getDependencies(di)) {
                for (Resource next : DependencyAdapter.getDependents(component)) {
                    Resource dependentDI = DependencyAdapter.getDIResource(next);
                    if (dependentDI == null || dependentDI == di) continue;
                    result.add(dependentDI.getURI());
                }
            }
        }
        return result;
    }

    @Override
    public Collection<URI> getComponents(Resource diResource, IProgressMonitor monitor) {
        ImmutableList result;
        if (!diResource.getURI().isPlatformResource()) {
            result = Collections.emptyList();
        } else {
            ImmutableList.Builder uris = ImmutableList.builder();
            URI baseURI = diResource.getURI().trimSegments(1);
            String baseName = diResource.getURI().trimFileExtension().lastSegment();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(diResource.getURI().toPlatformString(true)));
            IContainer container = file.getParent();
            try {
                for (IFile next : Iterables.filter(Arrays.asList(container.members()), IFile.class)) {
                    if (next.equals((Object)file) || !baseName.equals(next.getFullPath().removeFileExtension().lastSegment())) continue;
                    uris.add((Object)baseURI.appendSegment(next.getName()));
                }
            }
            catch (CoreException e) {
                Activator.log.error("Could not determine components of model " + diResource.getURI(), (Throwable)e);
            }
            result = uris.build();
        }
        return result;
    }

    private void scanWorkspace(final ResourceSet resourceSet) {
        this.completedScan = true;
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                block4: {
                    if (proxy.getType() == 1 && proxy.getName().endsWith(".di")) {
                        String path = proxy.requestFullPath().toString();
                        try {
                            Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)path, (boolean)true), true);
                            if (resource != null && DependencyAdapter.isDIResource(resource)) {
                                DependencyAdapter.getInstance(resource);
                            }
                        }
                        catch (Exception e) {
                            Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)path, (boolean)true), false);
                            if (resource == null) break block4;
                            resource.unload();
                            resourceSet.getResources().remove((Object)resource);
                            resource.eAdapters().clear();
                        }
                    }
                }
                return true;
            }
        };
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(visitor, 0);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

