/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.completeocl.as2cs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.util.PivotSwitch;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class CompleteOCLSplitter {
    public static @Nullable ASResource separate(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Resource asResource) {
        ArrayList<Constraint> allConstraints = new ArrayList<Constraint>();
        ArrayList<LanguageExpression> allExpressionInOCLs = new ArrayList<LanguageExpression>();
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            LanguageExpression bodyExpression;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof Constraint) {
                allConstraints.add((Constraint)eObject);
                continue;
            }
            if (eObject instanceof Operation) {
                bodyExpression = ((Operation)eObject).getBodyExpression();
                if (bodyExpression == null) continue;
                allExpressionInOCLs.add(bodyExpression);
                continue;
            }
            if (eObject instanceof Property) {
                bodyExpression = ((Property)eObject).getOwnedExpression();
                if (bodyExpression == null) continue;
                allExpressionInOCLs.add(bodyExpression);
                continue;
            }
            if (!(eObject instanceof Annotation)) continue;
            tit.prune();
        }
        if (allConstraints.isEmpty()) {
            return null;
        }
        URI uri = asResource.getURI();
        @NonNull URI oclURI = PivotUtilInternal.getNonASURI((URI)uri).appendFileExtension("ocl");
        URI oclASuri = PivotUtilInternal.getASURI((URI)oclURI);
        ASResource oclResource = (ASResource)asResource.getResourceSet().createResource(oclASuri, "org.eclipse.ocl.oclas.ocl");
        if (oclResource != null) {
            PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
            Separator separator = new Separator(metamodelManager, (Resource)oclResource);
            for (Constraint constraint : allConstraints) {
                separator.doSwitch((EObject)constraint);
            }
            for (LanguageExpression opaqueExpression : allExpressionInOCLs) {
                separator.doSwitch((EObject)opaqueExpression);
            }
            metamodelManager.installResource((Resource)oclResource);
        }
        return oclResource;
    }

    public static class Separator
    extends PivotSwitch<EObject> {
        protected final @NonNull PivotMetamodelManager metamodelManager;
        protected final @NonNull Resource separateResource;
        private final @NonNull Map<NamedElement, NamedElement> map = new HashMap<NamedElement, NamedElement>();

        public Separator(@NonNull PivotMetamodelManager metamodelManager, @NonNull Resource separateResource) {
            this.metamodelManager = metamodelManager;
            this.separateResource = separateResource;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public EObject caseClass(Class object) {
            Package parent = object.getOwningPackage();
            Package separateParent = this.getSeparate(parent);
            @NonNull List separateSiblings = ClassUtil.nullFree((List)separateParent.getOwnedClasses());
            return this.cloneNamedElement(separateSiblings, object);
        }

        public EObject caseConstraint(Constraint object) {
            NamedElement parent = (NamedElement)object.eContainer();
            NamedElement separateParent = this.getSeparate(parent);
            EStructuralFeature eContainingFeature = object.eContainingFeature();
            PivotUtilInternal.resetContainer((EObject)object);
            if (!eContainingFeature.isMany()) {
                separateParent.eSet(eContainingFeature, (Object)object);
            } else {
                List eGet = (List)separateParent.eGet(eContainingFeature);
                eGet.add(object);
            }
            return object;
        }

        public EObject caseExpressionInOCL(ExpressionInOCL object) {
            NamedElement parent = (NamedElement)object.eContainer();
            NamedElement separateParent = this.getSeparate(parent);
            if (separateParent instanceof Operation) {
                PivotUtilInternal.resetContainer((EObject)object);
                ((Operation)separateParent).setBodyExpression((LanguageExpression)object);
            }
            if (separateParent instanceof Property) {
                PivotUtilInternal.resetContainer((EObject)object);
                ((Property)separateParent).setOwnedExpression((LanguageExpression)object);
            }
            return object;
        }

        public EObject caseModel(Model object) {
            String name = object.getName();
            EObject container = object.eContainer();
            assert (container == null);
            EList separateSiblings = this.separateResource.getContents();
            Model separateObject = (Model)this.getElementByName((Iterable<? extends EObject>)separateSiblings, name);
            if (separateObject == null) {
                separateObject = PivotFactory.eINSTANCE.createModel();
                separateObject.setExternalURI(this.separateResource.getURI().toString());
                separateSiblings.add(separateObject);
            }
            return separateObject;
        }

        public EObject caseOperation(Operation object) {
            Class parent = object.getOwningClass();
            Class separateParent = this.getSeparate(parent);
            List separateSiblings = separateParent.getOwnedOperations();
            EcoreUtil.Copier copier = new EcoreUtil.Copier(false, true){

                protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
                    if (eReference == PivotPackage.Literals.OPERATION__OWNED_PARAMETERS) {
                        super.copyContainment(eReference, eObject, copyEObject);
                    }
                }
            };
            Operation clone = (Operation)copier.copy((EObject)object);
            copier.copyReferences();
            separateSiblings.add(clone);
            return clone;
        }

        public EObject casePackage(Package object) {
            List separateSiblings;
            Package separateObject;
            String name = object.getName();
            EObject container = object.eContainer();
            assert (container instanceof Namespace);
            Namespace parent = (Namespace)container;
            Namespace separateParent = (Namespace)this.map.get(parent);
            if (separateParent == null) {
                separateParent = (Namespace)this.doSwitch((EObject)parent);
                this.map.put((NamedElement)parent, (NamedElement)separateParent);
            }
            if ((separateObject = (Package)NameUtil.getNameable((Iterable)(separateSiblings = separateParent instanceof Model ? ((Model)separateParent).getOwnedPackages() : (separateParent != null ? ((Package)separateParent).getOwnedPackages() : Collections.emptyList())), (String)name)) == null) {
                separateObject = (Package)object.eClass().getEPackage().getEFactoryInstance().create(object.eClass());
                separateObject.setName(name);
                separateObject.setURI(object.getURI());
                separateObject.setNsPrefix(object.getNsPrefix());
                separateSiblings.add(separateObject);
            }
            return separateObject;
        }

        public EObject caseProperty(Property object) {
            Class parent = object.getOwningClass();
            Class separateParent = this.getSeparate(parent);
            List separateSiblings = separateParent.getOwnedProperties();
            EcoreUtil.Copier copier = new EcoreUtil.Copier(false, true){

                protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
                }
            };
            Property clone = (Property)copier.copy((EObject)object);
            copier.copyReferences();
            separateSiblings.add(clone);
            return clone;
        }

        protected <T extends NamedElement> T cloneNamedElement(List<T> separateSiblings, T object) {
            String name = object.getName();
            @Nullable NamedElement separateObject = (NamedElement)NameUtil.getNameable(separateSiblings, (String)name);
            if (separateObject == null) {
                NamedElement castObject;
                separateObject = castObject = (NamedElement)object.eClass().getEPackage().getEFactoryInstance().create(object.eClass());
                separateObject.setName(name);
                separateSiblings.add(separateObject);
            }
            return (T)separateObject;
        }

        public NamedElement getElementByName(Iterable<? extends EObject> elements, String name) {
            if (elements == null) {
                return null;
            }
            for (EObject eObject : elements) {
                if (!(eObject instanceof NamedElement) || !ClassUtil.safeEquals((Object)name, (Object)((NamedElement)eObject).getName())) continue;
                return (NamedElement)eObject;
            }
            return null;
        }

        protected <T extends NamedElement> T getSeparate(T element) {
            NamedElement separate = this.map.get(element);
            if (separate == null) {
                separate = (NamedElement)this.doSwitch((EObject)element);
                this.map.put(element, separate);
            }
            NamedElement castSeparate = separate;
            return (T)castSeparate;
        }

        protected Package getSeparatePackage(Package element) {
            Package separate = (Package)this.map.get(element);
            if (separate == null) {
                separate = (Package)this.doSwitch((EObject)element);
                this.map.put((NamedElement)element, (NamedElement)separate);
            }
            return separate;
        }
    }
}

