/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jms.Destination;
import javax.jms.Message;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.net4j.internal.jms.ConnectionFactoryImpl;
import org.eclipse.net4j.internal.jms.JMSDestination;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.jms.internal.server.ServerConnection;
import org.eclipse.net4j.jms.internal.server.ServerConsumer;
import org.eclipse.net4j.jms.internal.server.ServerDestination;
import org.eclipse.net4j.jms.internal.server.bundle.OM;
import org.eclipse.net4j.jms.internal.server.messages.Messages;
import org.eclipse.net4j.jms.server.IDestination;
import org.eclipse.net4j.jms.server.IServer;
import org.eclipse.net4j.jms.server.IStore;
import org.eclipse.net4j.jms.server.IStoreTransaction;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.concurrent.NonBlockingLongCounter;
import org.eclipse.net4j.util.concurrent.QueueWorker;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.om.OMPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends QueueWorker<MessageImpl>
implements IServer {
    public static final Server INSTANCE = new Server();
    private static final boolean REBIND_DESTINATIONS = true;
    private NonBlockingLongCounter messageIDCounter = new NonBlockingLongCounter();
    private NonBlockingLongCounter consumerIDCounter = new NonBlockingLongCounter();
    private IStore store = null;
    private Context jndiContext;
    private ConcurrentMap<String, ServerDestination> destinations = new ConcurrentHashMap<String, ServerDestination>();
    private Set<ServerConnection> connections = new HashSet<ServerConnection>();
    private ConcurrentMap<Long, ServerConsumer> consumers = new ConcurrentHashMap<Long, ServerConsumer>();

    public IStore getStore() {
        return this.store;
    }

    public void setStore(IStore store) {
        this.store = store;
    }

    @Override
    public IDestination createDestination(String name, IDestination.Type type) {
        ServerDestination destination = new ServerDestination(name, type);
        ServerDestination existing = this.destinations.putIfAbsent(name, destination);
        if (existing != null) {
            throw new IllegalStateException("Destination " + (Object)((Object)type) + " " + name + " does already exist");
        }
        IStoreTransaction transaction = this.store.startTransaction();
        transaction.destinationAdded(destination);
        this.store.commitTransaction(transaction);
        try {
            destination.bind(this.jndiContext, true);
        }
        catch (NamingException ex) {
            OM.LOG.error((Throwable)ex);
            this.destinations.remove(name);
            destination = null;
        }
        return destination;
    }

    public ServerDestination getDestination(String name) {
        return (ServerDestination)this.destinations.get(name);
    }

    public ServerDestination getServerDestination(Destination jmsDestination) {
        String name = ((JMSDestination)jmsDestination).getName();
        ServerDestination destination = (ServerDestination)this.destinations.get(name);
        if (destination == null) {
            OM.LOG.error(String.valueOf(Messages.getString("Server.3")) + name);
            return null;
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerConnection logon(String userName, String password) {
        ServerConnection connection = new ServerConnection(this, userName);
        Set<ServerConnection> set = this.connections;
        synchronized (set) {
            this.connections.add(connection);
        }
        return connection;
    }

    public ServerConsumer createConsumer(ServerDestination destination, String messageSelector, boolean noLocal, boolean durable) {
        long consumerID = this.consumerIDCounter.increment();
        ServerConsumer consumer = new ServerConsumer(consumerID, destination, messageSelector, noLocal, durable);
        this.consumers.put(consumer.getID(), consumer);
        return consumer;
    }

    public ServerConsumer getConsumer(long consumerID) {
        return (ServerConsumer)this.consumers.get(consumerID);
    }

    public String[] handleClientMessages(MessageImpl[] messages) {
        IStoreTransaction transaction = this.store.startTransaction();
        String[] messageIDs = this.handleClientMessagesInTransaction(transaction, messages);
        this.store.commitTransaction(transaction);
        return messageIDs;
    }

    public String[] handleClientMessagesInTransaction(IStoreTransaction transaction, MessageImpl[] messages) {
        String[] messageIDs = new String[messages.length];
        int i = 0;
        while (i < messages.length) {
            MessageImpl message = messages[i];
            if (this.getServerDestination(message.getJMSDestination()) == null) {
                return null;
            }
            messageIDs[i] = "ID:NET4J:" + HexUtil.longToHex((long)this.messageIDCounter.increment());
            message.setJMSMessageID(messageIDs[i]);
            ++i;
        }
        MessageImpl[] messageImplArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            MessageImpl message = messageImplArray[n2];
            transaction.messageReceived((Message)message);
            this.addWork(message);
            ++n2;
        }
        return messageIDs;
    }

    protected String getThreadName() {
        return "jms-server";
    }

    protected void work(Worker.WorkContext context, MessageImpl message) {
        ServerDestination destination = this.getServerDestination(message.getJMSDestination());
        IStoreTransaction transaction = this.store.startTransaction();
        destination.handleClientMessage(transaction, message);
        this.store.commitTransaction(transaction);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.store == null) {
            throw new IllegalStateException("store == null");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        String name = OMPlatform.INSTANCE.getProperty("net4j.jms.connection.factory.name", "net4j.jms.ConnectionFactory");
        String type = OMPlatform.INSTANCE.getProperty("net4j.jms.connector.type", "tcp");
        String desc = OMPlatform.INSTANCE.getProperty("net4j.jms.connector.description", "localhost");
        this.jndiContext = new InitialContext();
        this.jndiContext.rebind(name, (Object)new ConnectionFactoryImpl(type, desc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeactivate() throws Exception {
        Set<ServerConnection> set = this.connections;
        synchronized (set) {
            for (ServerConnection connection : this.connections) {
                try {
                    connection.close();
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        this.jndiContext.close();
        this.jndiContext = null;
        super.doDeactivate();
    }
}

