/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.arg.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewDiagramResourceWizardPage;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewResourceWizardPage;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgCreationWizard;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramEditorPlugin;
import org.eclipse.opencert.sam.arg.arg.diagram.part.DawnArgDiagramEditorUtil;
import org.eclipse.opencert.sam.arg.arg.diagram.part.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DawnArgCreationWizard
extends ArgCreationWizard {
    private CDOView view;
    private DawnCreateNewDiagramResourceWizardPage dawnDiagramModelFilePage;
    private DawnCreateNewResourceWizardPage dawnDomainModelFilePage;

    public DawnArgCreationWizard() {
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession session = CDOConnectionUtil.instance.openSession();
        this.view = CDOConnectionUtil.instance.openView(session);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                URI diagramResourceURI = DawnArgCreationWizard.this.dawnDiagramModelFilePage.getURI();
                URI domainModelResourceURI = DawnArgCreationWizard.this.dawnDomainModelFilePage.getURI();
                DawnArgCreationWizard.this.diagram = DawnArgDiagramEditorUtil.createDiagram(diagramResourceURI, domainModelResourceURI, monitor);
                if (DawnArgCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && DawnArgCreationWizard.this.diagram != null) {
                    try {
                        DawnArgDiagramEditorUtil.openDiagram(DawnArgCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)DawnArgCreationWizard.this.getContainer().getShell(), (String)Messages.ArgCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.ArgCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                ArgDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public void addPages() {
        this.dawnDiagramModelFilePage = new DawnCreateNewDiagramResourceWizardPage("arg_diagram", false, this.view);
        this.dawnDiagramModelFilePage.setTitle(Messages.ArgCreationWizard_DiagramModelFilePageTitle);
        this.dawnDiagramModelFilePage.setDescription(Messages.ArgCreationWizard_DiagramModelFilePageDescription);
        this.dawnDiagramModelFilePage.setCreateAutomaticResourceName(true);
        this.addPage((IWizardPage)this.dawnDiagramModelFilePage);
        this.dawnDomainModelFilePage = new DawnCreateNewResourceWizardPage("arg", false, this.view){

            public void setVisible(boolean visible) {
                if (visible) {
                    URI uri = DawnArgCreationWizard.this.dawnDiagramModelFilePage.getURI();
                    String fileName = uri.lastSegment();
                    fileName = fileName.substring(0, fileName.length() - ".arg_diagram".length());
                    fileName = String.valueOf(fileName) + ".arg";
                    DawnArgCreationWizard.this.dawnDomainModelFilePage.setResourceNamePrefix(fileName);
                    DawnArgCreationWizard.this.dawnDomainModelFilePage.setResourcePath(DawnArgCreationWizard.this.dawnDiagramModelFilePage.getResourcePath());
                }
                super.setVisible(visible);
            }
        };
        this.dawnDomainModelFilePage.setTitle(Messages.ArgCreationWizard_DomainModelFilePageTitle);
        this.dawnDomainModelFilePage.setDescription(Messages.ArgCreationWizard_DomainModelFilePageDescription);
        this.dawnDomainModelFilePage.setResourceValidationType(1);
        this.addPage((IWizardPage)this.dawnDomainModelFilePage);
    }

    public void dispose() {
        this.view.close();
    }
}

