/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.importer.importWizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class ImportWizardPage
extends WizardNewFileCreationPage {
    protected FileFieldEditor editor;

    public ImportWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(pageName);
        this.setDescription("Import a vocabulary from the local file system");
    }

    protected void createAdvancedControls(Composite parent) {
        Composite fileSelectionArea = new Composite(parent, 0);
        GridData fileSelectionData = new GridData(768);
        fileSelectionArea.setLayoutData((Object)fileSelectionData);
        GridLayout fileSelectionLayout = new GridLayout();
        fileSelectionLayout.numColumns = 3;
        fileSelectionLayout.makeColumnsEqualWidth = false;
        fileSelectionLayout.marginWidth = 0;
        fileSelectionLayout.marginHeight = 0;
        fileSelectionArea.setLayout((Layout)fileSelectionLayout);
        this.editor = new FileFieldEditor("fileSelect", "Select Vocabulary XML File: ", fileSelectionArea);
        this.editor.getTextControl(fileSelectionArea).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Path path = new Path(ImportWizardPage.this.editor.getStringValue());
                ImportWizardPage.this.setFileName(path.lastSegment());
            }
        });
        String[] extensions = new String[]{"*.xml"};
        this.editor.setFileExtensions(extensions);
        fileSelectionArea.moveAbove(null);
    }

    protected void createLinkTarget() {
    }

    protected InputStream getInitialContents() {
        try {
            return new FileInputStream(new File(this.editor.getStringValue()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected String getNewFileLabel() {
        return "New File Name:";
    }

    protected IStatus validateLinkedResource() {
        return new Status(0, "org.eclipse.opencert.vocabulary.importer", 0, "", null);
    }
}

