/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.internal.l10n.DiagramCoreMessages;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class ChangeParentCommand
extends AbstractTransactionalCommand {
    private IAdaptable parent;
    private IAdaptable child;
    private int index;

    public ChangeParentCommand(TransactionalEditingDomain editingDomain, IAdaptable parent, IAdaptable child) {
        this(editingDomain, parent, child, -1);
    }

    public ChangeParentCommand(TransactionalEditingDomain editingDomain, IAdaptable parent, IAdaptable child, int index) {
        super(editingDomain, DiagramCoreMessages.AddCommand_Label, null);
        assert (parent != null) : "Null parent in AddCommand";
        assert (child != null) : "Null child in AddCommand";
        this.parent = parent;
        this.child = child;
        this.index = index;
    }

    public List getAffectedFiles() {
        View view = (View)this.parent.getAdapter(View.class);
        if (view != null) {
            ArrayList<IFile> result = new ArrayList<IFile>();
            IFile file = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            if (file != null) {
                result.add(file);
            }
            return result;
        }
        return super.getAffectedFiles();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View childView = (View)this.child.getAdapter(View.class);
        View parentView = (View)this.parent.getAdapter(View.class);
        EObject oldParent = childView.eContainer();
        if (oldParent instanceof View) {
            ((View)oldParent).removeChild(childView);
        }
        if (this.index == -1) {
            parentView.insertChild(childView);
        } else {
            parentView.insertChildAt(childView, this.index);
        }
        Point childViewCoordinate = this.getLocation(childView);
        Point parentViewCoordinate = this.getLocation(parentView);
        ViewUtil.setStructuralFeatureValue((View)childView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)110);
        ViewUtil.setStructuralFeatureValue((View)childView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)110);
        return CommandResult.newOKCommandResult();
    }

    public String getLabel() {
        return DiagramCoreMessages.AddCommand_Label;
    }

    protected Point getAbsoluteLocation(View v) {
        Point result = this.getLocation(v);
        EObject container = v.eContainer();
        while (container instanceof View) {
            View parentView = (View)container;
            Point parentCoordinate = this.getLocation(parentView);
            if (parentCoordinate != null) {
                result.translate(parentCoordinate);
            }
            container = parentView.eContainer();
        }
        return result;
    }

    protected Point getLocation(View v) {
        Integer x = (Integer)ViewUtil.getStructuralFeatureValue((View)v, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        Integer y = (Integer)ViewUtil.getStructuralFeatureValue((View)v, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        return new Point(x.intValue(), y.intValue());
    }
}

