/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.gmf.tooling.runtime.draw2d.CenterLayout;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class CompactStateFigure
extends PapyrusNodeFigure
implements IPapyrusUMLElementFigure {
    public static final int PREFERRED_HEIGHT = 32;
    private final WrappingLabel label;
    private boolean infinite;

    public void setInfinite(boolean infinite) {
        this.infinite = infinite;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public CompactStateFigure() {
        this.setLayoutManager((LayoutManager)new CenterLayout());
        this.label = new WrappingLabel();
        this.label.setAlignment(2);
        this.add((IFigure)this.label);
    }

    public void paintFigure(Graphics g) {
        g.pushState();
        int height = Math.min(32, this.bounds.height);
        int middleY = this.bounds.y + this.bounds.height / 2;
        int x = this.bounds.x;
        int w = this.bounds.width - 1;
        int y = middleY - height / 2;
        int h = height - 1;
        g.setLineWidth(1);
        int cornerSize = Math.min(h / 3, w / 3);
        int[] polygon = this.infinite ? new int[]{x, middleY, x + cornerSize, y, x + w + 1, y, x + w + 1, y + h, x + cornerSize, y + h} : new int[]{x, middleY, x + cornerSize, y, x + w - cornerSize, y, x + w, middleY, x + w - cornerSize, y + h, x + cornerSize, y + h};
        g.setAntialias(1);
        if (this.isUsingGradient()) {
            this.applyTransparency(g);
            double scale = g.getAbsoluteScale();
            int xScaled = (int)((double)this.bounds.x * scale);
            int yScaled = (int)((double)this.bounds.y * scale);
            int widthScaled = (int)((double)this.bounds.width * scale);
            int heightScaled = (int)((double)height * scale);
            Pattern pattern = this.getGradientStyle() == 0 ? new Pattern((Device)Display.getCurrent(), (float)xScaled, (float)yScaled, (float)xScaled, (float)(yScaled + heightScaled), ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())), ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1()))) : new Pattern((Device)Display.getCurrent(), (float)xScaled, (float)yScaled, (float)(xScaled + widthScaled), (float)this.bounds.y, ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())), ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
            g.setBackgroundPattern(pattern);
            g.fillPolygon(polygon);
            g.drawPolygon(polygon);
            pattern.dispose();
        } else {
            g.setBackgroundColor(this.getBackgroundColor());
            g.setForegroundColor(this.getForegroundColor());
            g.drawPolygon(polygon);
        }
        g.popState();
    }

    public static int computeHalfHeightAtAbscissa(int x, int figureWidth, int figureHeight, boolean infinite) {
        int resultY;
        int height = Math.min(32, figureHeight);
        int width = figureWidth;
        int halfHeight = figureHeight / 2;
        int cornerSize = Math.min(height / 3, width / 3);
        if (x < cornerSize) {
            double slope = (double)height / 2.0 / (double)cornerSize;
            resultY = (int)((double)x * slope);
        } else if (infinite) {
            resultY = halfHeight;
        } else if (x < width - cornerSize) {
            resultY = halfHeight;
        } else {
            double slope = (double)halfHeight / (double)cornerSize;
            resultY = (int)((double)halfHeight - (double)(x - width + cornerSize) * slope);
        }
        return resultY;
    }

    public WrappingLabel getCompactStateInvariantLabel() {
        return this.label;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(-1, 32);
    }

    protected void paintBorder(Graphics graphics) {
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
    }
}

