/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.pkm.refframework.refframework.diagram.part;

import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.Messages;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkDiagramEditorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RefframeworkElementChooserDialog
extends Dialog {
    private TreeViewer myTreeViewer;
    private URI mySelectedModelElementURI;
    private View myView;
    private TransactionalEditingDomain myEditingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();

    public RefframeworkElementChooserDialog(Shell parentShell, View view) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.myView = view;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Messages.RefframeworkElementChooserDialog_SelectModelElementTitle);
        this.createModelBrowser(composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.setOkButtonEnabled(false);
        return buttonBar;
    }

    private void createModelBrowser(Composite composite) {
        this.myTreeViewer = new TreeViewer(composite, 2820);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.myTreeViewer.getTree().setLayoutData((Object)layoutData);
        this.myTreeViewer.setContentProvider((IContentProvider)new ModelElementsTreeContentProvider());
        this.myTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelElementsTreeLabelProvider());
        this.myTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.myTreeViewer.addFilter((ViewerFilter)new ModelFilesFilter());
        this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new OkButtonEnabler());
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    private boolean isValidModelFile(IFile file) {
        String fileExtension = file.getFullPath().getFileExtension();
        return "refframework".equals(fileExtension);
    }

    public URI getSelectedModelElementURI() {
        return this.mySelectedModelElementURI;
    }

    public int open() {
        int result = super.open();
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        this.myEditingDomain.dispose();
        return result;
    }

    private class ModelElementsTreeContentProvider
    implements ITreeContentProvider {
        private ITreeContentProvider myWorkbenchContentProvider = new WorkbenchContentProvider();
        private AdapterFactoryContentProvider myAdapterFctoryContentProvier = new AdapterFactoryContentProvider(RefframeworkDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());

        private ModelElementsTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = this.myWorkbenchContentProvider.getChildren(parentElement);
            if (result != null && result.length > 0) {
                return result;
            }
            if (parentElement instanceof IFile) {
                IFile modelFile = (IFile)parentElement;
                IPath resourcePath = modelFile.getFullPath();
                ResourceSet resourceSet = RefframeworkElementChooserDialog.this.myEditingDomain.getResourceSet();
                try {
                    Resource modelResource = resourceSet.getResource(URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)true), true);
                    return this.myAdapterFctoryContentProvier.getChildren((Object)modelResource);
                }
                catch (WrappedException e) {
                    RefframeworkDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + resourcePath.toString(), e);
                    return Collections.EMPTY_LIST.toArray();
                }
            }
            return this.myAdapterFctoryContentProvier.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            Object parent = this.myWorkbenchContentProvider.getParent(element);
            if (parent != null) {
                return parent;
            }
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                if (eObject.eContainer() == null && eObject.eResource().getURI().isFile()) {
                    String path = eObject.eResource().getURI().path();
                    return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
                }
                return this.myAdapterFctoryContentProvier.getParent((Object)eObject);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFile) {
                return RefframeworkElementChooserDialog.this.isValidModelFile((IFile)element);
            }
            return this.myWorkbenchContentProvider.hasChildren(element) || this.myAdapterFctoryContentProvier.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.myWorkbenchContentProvider.getElements(inputElement);
            return elements;
        }

        public void dispose() {
            this.myWorkbenchContentProvider.dispose();
            this.myAdapterFctoryContentProvier.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.myWorkbenchContentProvider.inputChanged(viewer, oldInput, newInput);
            this.myAdapterFctoryContentProvier.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class ModelElementsTreeLabelProvider
    implements ILabelProvider {
        private WorkbenchLabelProvider myWorkbenchLabelProvider = new WorkbenchLabelProvider();
        private AdapterFactoryLabelProvider myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(RefframeworkDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());

        private ModelElementsTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            Image result = this.myWorkbenchLabelProvider.getImage(element);
            return result != null ? result : this.myAdapterFactoryLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            String result = this.myWorkbenchLabelProvider.getText(element);
            return result != null && result.length() > 0 ? result : this.myAdapterFactoryLabelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.addListener(listener);
            this.myAdapterFactoryLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.myWorkbenchLabelProvider.dispose();
            this.myAdapterFactoryLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myWorkbenchLabelProvider.isLabelProperty(element, property) || this.myAdapterFactoryLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.removeListener(listener);
            this.myAdapterFactoryLabelProvider.removeListener(listener);
        }
    }

    private class ModelFilesFilter
    extends ViewerFilter {
        private ModelFilesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IContainer) {
                return true;
            }
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return RefframeworkElementChooserDialog.this.isValidModelFile(file);
            }
            return true;
        }
    }

    private class OkButtonEnabler
    implements ISelectionChangedListener {
        private OkButtonEnabler() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1) {
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof IWrapperItemProvider) {
                    selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
                }
                if (selectedElement instanceof FeatureMap.Entry) {
                    selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
                }
                if (selectedElement instanceof EObject) {
                    EObject selectedModelElement = (EObject)selectedElement;
                    RefframeworkElementChooserDialog.this.setOkButtonEnabled(ViewService.getInstance().provides(Node.class, (IAdaptable)new EObjectAdapter(selectedModelElement), RefframeworkElementChooserDialog.this.myView, null, -1, true, RefframeworkDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT));
                    RefframeworkElementChooserDialog.this.mySelectedModelElementURI = EcoreUtil.getURI((EObject)selectedModelElement);
                    return;
                }
            }
            RefframeworkElementChooserDialog.this.mySelectedModelElementURI = null;
            RefframeworkElementChooserDialog.this.setOkButtonEnabled(false);
        }
    }
}

