/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.node;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.figures.ScalableImageFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ScalableCompartmentFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;

public class BorderedScalableImageFigure
extends ScalableImageFigure {
    private RenderedImage lastRenderedImage;

    public BorderedScalableImageFigure(RenderedImage renderedImage, boolean useDefaultImageSize, boolean useOriginalColors, boolean antiAlias) {
        super(renderedImage, useDefaultImageSize, useOriginalColors, antiAlias);
        this.setLayoutManager((LayoutManager)new BorderedLayoutManager());
        this.lastRenderedImage = renderedImage;
        this.setPreferredImageSize(renderedImage.getSWTImage().getBounds().width, renderedImage.getSWTImage().getBounds().height);
    }

    protected void paintFigure(Graphics graphics) {
        if (!this.lastRenderedImage.getSWTImage().isDisposed()) {
            Rectangle parentBounds = this.getParent().getBounds().getCopy();
            IRoundedRectangleFigure roundedCompartmentFigure = this.getMainFigure();
            if (roundedCompartmentFigure != null) {
                this.setBackgroundColor(roundedCompartmentFigure.getBackgroundColor());
                this.setForegroundColor(roundedCompartmentFigure.getForegroundColor());
            } else {
                this.setBackgroundColor(this.getParent().getBackgroundColor());
                this.setForegroundColor(this.getParent().getForegroundColor());
            }
            graphics.setClip(parentBounds);
            super.paintFigure(graphics);
        }
    }

    private IRoundedRectangleFigure getMainFigure() {
        SVGNodePlateFigure svgNodePlate = FigureUtils.findParentFigureInstance((IFigure)this, SVGNodePlateFigure.class);
        return svgNodePlate == null ? null : FigureUtils.findChildFigureInstance((IFigure)svgNodePlate, IRoundedRectangleFigure.class);
    }

    class BorderedLayoutManager
    extends AbstractLayout {
        BorderedLayoutManager() {
        }

        public void layout(IFigure container) {
            ScrollPane scrollPaneFigure = FigureUtils.findParentFigureInstance(container, ScrollPane.class);
            if (scrollPaneFigure instanceof ScrollPane) {
                scrollPaneFigure.setScrollBarVisibility(0);
            }
            if (BorderedScalableImageFigure.this.isMaintainAspectRatio() && container.getParent().getChildren().size() == 1) {
                int height;
                int width;
                Rectangle scalableCompartmentBounds;
                ScalableCompartmentFigure scalableCompartmentFigure = FigureUtils.findParentFigureInstance(container, ScalableCompartmentFigure.class);
                ScalableImageFigure scalableImage = FigureUtils.findChildFigureInstance(BorderedScalableImageFigure.this.getParent(), ScalableImageFigure.class);
                RenderedImage renderedImage = scalableImage.getRenderedImage();
                scalableCompartmentBounds = scalableCompartmentFigure != null ? (scalableCompartmentBounds = scalableCompartmentFigure.getBounds()) : container.getBounds();
                double ratio = (double)renderedImage.getRenderInfo().getWidth() / (double)renderedImage.getRenderInfo().getHeight();
                Point center = new Point(scalableCompartmentBounds.x + scalableCompartmentBounds.width / 2, scalableCompartmentBounds.y + scalableCompartmentBounds.height / 2);
                if (scalableCompartmentBounds.width > scalableCompartmentBounds.height) {
                    if ((double)scalableCompartmentBounds.width > (double)scalableCompartmentBounds.height * ratio) {
                        width = (int)((double)scalableCompartmentBounds.height * ratio);
                        height = scalableCompartmentBounds.height;
                    } else {
                        width = scalableCompartmentBounds.width;
                        height = (int)((double)scalableCompartmentBounds.width / ratio);
                    }
                } else if ((double)scalableCompartmentBounds.height < (double)scalableCompartmentBounds.width / ratio) {
                    width = (int)((double)scalableCompartmentBounds.height * ratio);
                    height = scalableCompartmentBounds.height;
                } else {
                    width = scalableCompartmentBounds.width;
                    height = (int)((double)scalableCompartmentBounds.width / ratio);
                }
                int y = center.y - height / 2;
                int x = center.x - width / 2;
                container.setBounds(new Rectangle(x, y, width, height));
            } else if (scrollPaneFigure instanceof ScrollPane) {
                container.setBounds(scrollPaneFigure.getBounds());
            }
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return null;
        }
    }
}

