/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.utils.image;

import java.io.File;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.PlatformUI;

public class ImageUtils {
    private ImageRegistry imageRegister = new ImageRegistry();
    public final String IMGS_DIR_OPEN = "dir_open";
    public final String IMGS_DIR_CLOSED = "dir_closed";
    public final String IMGS_FILE = "file";

    public ImageUtils() {
        this.initImageRegister();
    }

    public void initImageRegister() {
        this.imageRegister.put("dir_closed", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        this.imageRegister.put("dir_open", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        this.imageRegister.put("file", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"));
    }

    public void PutImage(Item item, String theFile) {
        Image itemImage = null;
        Program program = null;
        File root = new File(theFile);
        if (root.isDirectory()) {
            itemImage = this.imageRegister.get("dir_closed");
        } else {
            int dot = root.getName().lastIndexOf(46);
            if (dot != -1) {
                String extension = root.getName().substring(dot);
                if (this.imageRegister.get(extension) == null) {
                    program = Program.findProgram((String)extension);
                    if (program != null) {
                        ImageData imageData = program.getImageData();
                        if (imageData != null) {
                            itemImage = new Image(null, imageData, imageData.getTransparencyMask());
                            this.imageRegister.put(extension, itemImage);
                        }
                    } else {
                        itemImage = this.imageRegister.get("file");
                    }
                } else {
                    itemImage = this.imageRegister.get(extension);
                }
            }
        }
        if (itemImage == null) {
            itemImage = this.imageRegister.get("file");
        }
        item.setImage(itemImage);
    }
}

