/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DuplicateStereotypeCommand
extends RecordingCommand {
    protected Element element;
    protected EObject stereotypeApplication;
    protected Stereotype stereotypeInTargetContext;

    public DuplicateStereotypeCommand(TransactionalEditingDomain domain, Element element, EObject stereotypeApplication) {
        super(domain);
        Stereotype stereotypeInTargetContext;
        this.element = element;
        this.stereotypeApplication = stereotypeApplication;
        Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication);
        this.stereotypeInTargetContext = stereotypeInTargetContext = (Stereotype)EMFHelper.reloadIntoContext((EObject)stereotype, (EObject)element);
    }

    public Stereotype getStereotypeInTargetContext() {
        return this.stereotypeInTargetContext;
    }

    protected void doExecute() {
        EObject applyStereotype = this.element.applyStereotype(this.stereotypeInTargetContext);
        EList eStructuralFeatures = applyStereotype.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eStructuralFeatures) {
            String name = eStructuralFeature.getName();
            if (name.startsWith("base_") || !eStructuralFeature.isChangeable()) continue;
            applyStereotype.eSet(eStructuralFeature, this.stereotypeApplication.eGet(eStructuralFeature));
        }
    }
}

