/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.impactanalysis.relations;

import org.eclipse.opencert.apm.assuranceassets.assuranceasset.EventKind;
import org.eclipse.opencert.impactanalysis.eventcreators.ChangeDrivenEventsCreatorsFactory;
import org.eclipse.opencert.impactanalysis.eventcreators.IChangeDrivenEventsCreator;
import org.eclipse.opencert.impactanalysis.relations.ArtefactRelationType;
import org.eclipse.opencert.impactanalysis.relations.IArtefactRelationImpact;
import org.eclipse.opencert.infra.general.general.ChangeEffectKind;

abstract class AbstractArtefactsRelationImpact
implements IArtefactRelationImpact {
    private final int recursionDepth;
    private ChangeEffectKind impactedChangeEffectKind;
    private final Long impactingArtefactCDOId;
    private final Long impactedArtefactCDOId;
    private final String impactingArtefactRelationUniqueId;
    private boolean suppressed;
    private EventKind impactingEventKind;
    private final ArtefactRelationType artefactRelationType;

    protected AbstractArtefactsRelationImpact(int recursionDepth, ArtefactRelationType artefactRelationType, ChangeEffectKind impactedChangeEffectKind, EventKind impactingEventKind, String impactingArtefactRelationUniqueId, Long impactingArtefactCDOId, Long impactedArtefactCDOId) {
        this.impactingArtefactRelationUniqueId = impactingArtefactRelationUniqueId;
        this.impactingArtefactCDOId = impactingArtefactCDOId;
        this.impactedArtefactCDOId = impactedArtefactCDOId;
        this.recursionDepth = recursionDepth;
        this.impactedChangeEffectKind = impactedChangeEffectKind;
        this.impactingEventKind = impactingEventKind;
        this.artefactRelationType = artefactRelationType;
    }

    @Override
    public EventKind generateNewEventBasedOnChangeEffectKindOrForwardCurrent(EventKind impactingEventKind) {
        IChangeDrivenEventsCreator changeDrivenEventsCreator = ChangeDrivenEventsCreatorsFactory.getProperChangeDrivenEventsCreator(this.getImpactedChangeEffectKind());
        if (changeDrivenEventsCreator == null) {
            return null;
        }
        return changeDrivenEventsCreator.getEventKind();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[" + this.getRecursionDepth() + "] ");
        stringBuilder.append(this.getRelationTypeExtraInfo());
        stringBuilder.append(String.valueOf(this.getUserFriendlyImpactingArtefactName()) + " (" + this.impactingArtefactCDOId + ")");
        stringBuilder.append(" : ");
        stringBuilder.append(this.impactingEventKind);
        stringBuilder.append(" ---- ");
        stringBuilder.append(String.valueOf(this.getUserFriendlyRelationName()) + " (" + this.impactingArtefactRelationUniqueId + ") : ");
        stringBuilder.append(this.getImpactedChangeEffectKind());
        stringBuilder.append(" ---> ");
        stringBuilder.append(String.valueOf(this.getUserFriendlyImpactedArtefactName()) + " (" + this.impactedArtefactCDOId + ")");
        return stringBuilder.toString();
    }

    protected String getRelationTypeExtraInfo() {
        return "";
    }

    @Override
    public ChangeEffectKind getImpactedChangeEffectKind() {
        return this.impactedChangeEffectKind;
    }

    @Override
    public int getRecursionDepth() {
        return this.recursionDepth;
    }

    @Override
    public Long getImpactingArtefactCDOId() {
        return this.impactingArtefactCDOId;
    }

    @Override
    public Long getImpactedArtefactCDOId() {
        return this.impactedArtefactCDOId;
    }

    @Override
    public String getImpactingArtefactRelationUniqueId() {
        return this.impactingArtefactRelationUniqueId;
    }

    @Override
    public boolean isSuppressed() {
        return this.suppressed;
    }

    @Override
    public void setSuppressed(boolean suppressed) {
        this.suppressed = suppressed;
    }

    @Override
    public EventKind getImpactingEventKind() {
        return this.impactingEventKind;
    }

    @Override
    public ArtefactRelationType getArtefactRelationType() {
        return this.artefactRelationType;
    }
}

