/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.wizards.ui.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.cdo.dawn.commands.CreateSemanticResourceRecordingCommand;
import org.eclipse.emf.cdo.dawn.transaction.DawnGMFEditingDomainFactory;
import org.eclipse.emf.cdo.dawn.ui.DawnEditorInput;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.opencert.apm.assurproj.assuranceproject.presentation.AssuranceprojectEditorPlugin;
import org.eclipse.opencert.apm.baseline.baseline.BaselineFactory;
import org.eclipse.opencert.apm.baseline.baseline.diagram.edit.commands.LoadViewLocations;
import org.eclipse.opencert.apm.baseline.baseline.diagram.edit.parts.BaseActivityBaseActivitySubActivityCompartment2EditPart;
import org.eclipse.opencert.apm.baseline.baseline.diagram.edit.parts.BaseActivityBaseActivitySubActivityCompartmentEditPart;
import org.eclipse.opencert.apm.baseline.baseline.diagram.edit.policies.DawnBaseFrameworkPersistedSemiCanonicalEditPolicy;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.BaselineDiagramEditorPlugin;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.DawnBaselineDiagramEditor;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.Messages;
import org.eclipse.swt.SWTException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DawnBaselineDiagramUtil {
    private CDOResource sourceDiagramResource;
    private URI modelURI;
    private URI diagramURI;
    protected Resource diagram;
    private CDOResourceFolder assuranceprojectFolder;
    private CDOTransaction transaction;
    private List<EObject> listRootObjects = null;
    private static String DawnBaselineDiagramEditor_ID = "org.eclipse.opencert.apm.baseline.baseline.diagram.part.DawnBaselineDiagramEditor";
    private static final String DawnBaseFrameworkEditPart_MODEL_ID = "Baseline";

    public DawnBaselineDiagramUtil(CDOResource sourceDiagramResource, List<EObject> lro, URI model, URI diagram, CDOResourceFolder assuranceprojectFolder, CDOTransaction transaction) {
        this.sourceDiagramResource = sourceDiagramResource;
        this.listRootObjects = lro;
        this.modelURI = model;
        this.diagramURI = diagram;
        this.assuranceprojectFolder = assuranceprojectFolder;
        this.transaction = transaction;
    }

    public void generateDiagram(IProgressMonitor monitor) {
        try {
            this.generateDiagram0(monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateEditPartChildren(IGraphicalEditPart editPart, String eClassName, EditPolicy newPolicy) {
        List editPolicies;
        if (editPart == null) {
            return;
        }
        View view = editPart.getNotationView();
        if (view == null) {
            return;
        }
        for (Object child : editPart.getChildren()) {
            if (!(child instanceof IGraphicalEditPart)) continue;
            this.updateEditPartChildren((IGraphicalEditPart)child, eClassName, newPolicy);
        }
        EObject element = view.getElement();
        if (eClassName.contains("BaseActivityBaseActivitySubActivityCompartment2EditPart")) {
            if (element instanceof BaseActivityBaseActivitySubActivityCompartment2EditPart) {
                editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)element);
                while (!editPolicies.isEmpty()) {
                    editPolicies.remove(0);
                }
                IGraphicalEditPart temp = (IGraphicalEditPart)element;
                temp.installEditPolicy((Object)"Canonical", newPolicy);
            }
        } else if (eClassName.contains("BaseActivityBaseActivitySubActivityCompartmentEditPart") && element instanceof BaseActivityBaseActivitySubActivityCompartmentEditPart) {
            editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)element);
            while (!editPolicies.isEmpty()) {
                editPolicies.remove(0);
            }
            IGraphicalEditPart temp = (IGraphicalEditPart)element;
            temp.installEditPolicy((Object)"Canonical", newPolicy);
        }
    }

    public void generateDiagram0(IProgressMonitor monitor) throws IOException {
        block6: {
            this.diagram = this.createDiagram(this.diagramURI, this.modelURI, monitor);
            if (this.diagram != null) {
                try {
                    DawnBaselineDiagramUtil.openDiagram(this.diagram);
                    IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                    if (!(editorPart instanceof IDiagramWorkbenchPart)) break block6;
                    DiagramEditPart editp = ((IDiagramWorkbenchPart)editorPart).getDiagramEditPart();
                    editp.removeEditPolicy((Object)"Canonical");
                    LoadViewLocations sourceViewLocations = new LoadViewLocations(this.sourceDiagramResource);
                    sourceViewLocations.LoadObjectLocations();
                    BaseActivityBaseActivitySubActivityCompartmentEditPart.NOT_FROM_REFFRAMEWORK = 0;
                    BaseActivityBaseActivitySubActivityCompartmentEditPart.sourceViewLocations = sourceViewLocations;
                    BaseActivityBaseActivitySubActivityCompartment2EditPart.NOT_FROM_REFFRAMEWORK = 0;
                    BaseActivityBaseActivitySubActivityCompartment2EditPart.sourceViewLocations = sourceViewLocations;
                    DawnBaseFrameworkPersistedSemiCanonicalEditPolicy scp = new DawnBaseFrameworkPersistedSemiCanonicalEditPolicy();
                    scp.setObjects(this.listRootObjects);
                    scp.setSourceDiagram(sourceViewLocations);
                    scp.setHost((EditPart)editp);
                    scp.refresh();
                    scp.deactivate();
                    DawnBaselineDiagramEditor dawnEditorPart = (DawnBaselineDiagramEditor)editorPart;
                    dawnEditorPart.doSave(monitor);
                    if (editorPart instanceof DiagramEditor) {
                        boolean save = true;
                        try {
                            DiagramEditor deditor = (DiagramEditor)editorPart;
                            deditor.getSite().getPage().closeEditor((IEditorPart)deditor, save);
                        }
                        catch (SWTException e) {
                            AssuranceprojectEditorPlugin.INSTANCE.log((Object)e);
                        }
                    }
                    BaseActivityBaseActivitySubActivityCompartmentEditPart.NOT_FROM_REFFRAMEWORK = 1;
                    BaseActivityBaseActivitySubActivityCompartment2EditPart.NOT_FROM_REFFRAMEWORK = 1;
                }
                catch (PartInitException e) {
                    AssuranceprojectEditorPlugin.INSTANCE.log((Object)e);
                }
            }
        }
    }

    public Resource createDiagram(URI diagramURI, URI modelURI, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = DawnGMFEditingDomainFactory.getInstance().createEditingDomain();
        progressMonitor.beginTask(Messages.BaselineDiagramEditorUtil_CreateDiagramProgressTask, 3);
        String diagramResourceStr = diagramURI.toString().substring("cdo://opencert".length(), diagramURI.toString().length());
        CDOResource diagramResource = this.transaction.getOrCreateResource(diagramResourceStr);
        CreateSemanticResourceRecordingCommand createSemanticResourceCommand = new CreateSemanticResourceRecordingCommand(editingDomain, this.transaction, modelURI.path());
        editingDomain.getCommandStack().execute((Command)createSemanticResourceCommand);
        final Resource modelResource = createSemanticResourceCommand.getResource();
        String diagramName = diagramURI.lastSegment();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, Messages.BaselineDiagramEditorUtil_CreateDiagramCommandLabel, Collections.EMPTY_LIST, (Resource)diagramResource, diagramName){
            private final /* synthetic */ Resource val$diagramResource;
            private final /* synthetic */ String val$diagramName;
            {
                this.val$diagramResource = resource2;
                this.val$diagramName = string;
                super($anonymous0, $anonymous1, $anonymous2);
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject model = null;
                if (modelResource.getContents().size() > 0) {
                    model = (EObject)modelResource.getContents().get(0);
                } else {
                    model = DawnBaselineDiagramUtil.createInitialModel();
                    DawnBaselineDiagramUtil.attachModelToResource(model, modelResource);
                }
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)DawnBaselineDiagramUtil.DawnBaseFrameworkEditPart_MODEL_ID, (PreferencesHint)BaselineDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    this.val$diagramResource.getContents().add((Object)diagram);
                    diagram.setName(this.val$diagramName);
                    diagram.setElement(model);
                }
                try {
                    modelResource.save(Collections.EMPTY_MAP);
                    this.val$diagramResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    BaselineDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", (Throwable)e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            BaselineDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", (Throwable)e);
        }
        DawnBaselineDiagramUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)modelResource));
        DawnBaselineDiagramUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)diagramResource));
        return diagramResource;
    }

    private static EObject createInitialModel() {
        return BaselineFactory.eINSTANCE.createBaseFramework();
    }

    private static void attachModelToResource(EObject model, Resource resource) {
        resource.getContents().add((Object)model);
    }

    public static boolean openDiagram(Resource diagram) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return page.openEditor((IEditorInput)new DawnEditorInput(diagram.getURI()), DawnBaselineDiagramEditor_ID) != null;
    }

    public static void setCharset(IFile file) {
        if (file == null) {
            return;
        }
        try {
            file.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            BaselineDiagramEditorPlugin.getInstance().logError("Unable to set charset for file " + file.getFullPath(), (Throwable)e);
        }
    }
}

