/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.sysml.constraints.ConstraintsPackage;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractStereotypedElementEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConstraintBlockEditHelperAdvice
extends AbstractStereotypedElementEditHelperAdvice {
    public ConstraintBlockEditHelperAdvice() {
        this.requiredProfiles.add(ConstraintsPackage.eINSTANCE);
    }

    protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
        IElementType elementToCreate = request.getElementType();
        if (UMLElementTypes.STRUCTURAL_FEATURE.getEClass().isSuperTypeOf(elementToCreate.getEClass()) && elementToCreate != SysMLElementTypes.CONSTRAINT_PROPERTY && elementToCreate != UMLElementTypes.PROPERTY) {
            return null;
        }
        return super.getBeforeCreateCommand(request);
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                NamedElement element = (NamedElement)request.getElementToConfigure();
                if (element != null) {
                    UMLUtil.StereotypeApplicationHelper.INSTANCE.applyStereotype((Element)element, ConstraintsPackage.eINSTANCE.getConstraintBlock());
                    String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)ConstraintsPackage.eINSTANCE.getConstraintBlock().getName(), (Collection)element.eContainer().eContents());
                    element.setName(initializedName);
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }
}

