/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ui.composites;

import java.util.Date;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.composites.CDOResourceNodeSelectionWidget;
import org.eclipse.emf.cdo.dawn.ui.messages.Messages;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CDOResourceNodeChooserComposite
extends Composite {
    private final String fileExtension;
    protected Text resourcePathComposite;
    protected Text resourceNameComposite;
    private String resourceNamePrefix = "default";
    protected CDOResourceNodeSelectionWidget selectCDOResourceNodeComposite;
    private final CDOView view;
    private ResourceChooserValidator validator;

    public CDOResourceNodeChooserComposite(Composite parent, int style, String fileExtension, CDOView view) {
        super(parent, style);
        this.fileExtension = fileExtension;
        this.view = view;
        this.init();
        this.setValidator(new ResourceChooserValidator());
    }

    private void createLayout() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePathComposite.setText(resourcePath);
    }

    public void setResourceName(String resourceNamePrefix) {
        this.resourceNameComposite.setText(resourceNamePrefix);
    }

    protected void init() {
        this.createLayout();
        this.createResourcePathInput();
        this.createResourceSelectionComposite();
        this.createResourceInput();
    }

    public String getResourceName() {
        return this.resourceNameComposite.getText();
    }

    public String getResourcePath() {
        return this.resourcePathComposite.getText();
    }

    private void createResourceSelectionComposite() {
        this.selectCDOResourceNodeComposite = new CDOResourceNodeSelectionWidget(this, 0);
        GridData gd = new GridData(1808);
        this.selectCDOResourceNodeComposite.setLayoutData(gd);
        this.selectCDOResourceNodeComposite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    CDOResourceNodeChooserComposite.this.resourceNameComposite.setText("");
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element instanceof CDOResource) {
                        String resourceName = ((CDOResource)element).getName();
                        CDOResourceNodeChooserComposite.this.resourcePathComposite.setText(((CDOResource)element).getPath().replace(resourceName, ""));
                        CDOResourceNodeChooserComposite.this.resourceNameComposite.setText(resourceName);
                    } else if (element instanceof CDOResourceNode) {
                        CDOResourceNodeChooserComposite.this.resourcePathComposite.setText(((CDOResourceNode)element).getPath());
                    }
                }
                CDOResourceNodeChooserComposite.this.getValidator().validate();
            }
        });
    }

    private void createResourceInput() {
        Composite nameGroup = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        Label label1 = new Label(nameGroup, 0);
        label1.setText(Messages.DawnCreateNewResourceWizardPage_6);
        this.resourceNameComposite = new Text(nameGroup, 2052);
        this.resourceNameComposite.setText("");
        this.resourceNameComposite.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                CDOResourceNodeChooserComposite.this.getValidator().validate();
            }
        });
        GridData gd = new GridData(768);
        this.resourceNameComposite.setLayoutData((Object)gd);
    }

    private GridData createResourcePathInput() {
        Label resourcePathLabel = new Label((Composite)this, 0);
        resourcePathLabel.setText(Messages.DawnCreateNewResourceWizardPage_8);
        this.resourcePathComposite = new Text((Composite)this, 2052);
        this.resourcePathComposite.setText("");
        this.resourcePathComposite.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                CDOResourceNodeChooserComposite.this.getValidator().validate();
            }
        });
        GridData gd = new GridData(768);
        this.resourcePathComposite.setLayoutData((Object)gd);
        return gd;
    }

    public void createAutomaticResourceName() {
        this.resourceNameComposite.setText(String.valueOf(this.getResourceNamePrefix()) + "." + this.fileExtension);
        int i = 1;
        while (i < 30 && this.view.hasResource(this.getURI().path())) {
            this.resourceNameComposite.setText(String.valueOf(this.getResourceNamePrefix()) + i + "." + this.fileExtension);
            ++i;
        }
        if (i < 30) {
            return;
        }
        this.resourceNameComposite.setText(String.valueOf(this.getResourceNamePrefix()) + new Date().getTime() + "." + this.fileExtension);
    }

    public URI getURI() {
        String resourcePath = this.getResourcePath();
        if (resourcePath.length() > 0) {
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1, resourcePath.length());
            }
            if (!resourcePath.endsWith("/")) {
                resourcePath = String.valueOf(resourcePath) + "/";
            }
        }
        String resourceName = this.getResourceName();
        String authority = PreferenceConstants.getRepositoryName();
        URI uri = URI.createURI((String)("cdo://" + authority + "/" + resourcePath + resourceName));
        return uri;
    }

    public String getDefaultName() {
        return this.getResourceNamePrefix();
    }

    public void showResources(boolean showResources) {
        this.selectCDOResourceNodeComposite.setShowResources(showResources);
    }

    public void setResourceNamePrefix(String resourceNamePrefix) {
        this.resourceNamePrefix = resourceNamePrefix;
    }

    public String getResourceNamePrefix() {
        return this.resourceNamePrefix;
    }

    public void setValidator(ResourceChooserValidator validator) {
        this.validator = validator;
    }

    public ResourceChooserValidator getValidator() {
        return this.validator;
    }

    public class ResourceChooserValidator {
        public static final int VALIDATION_NONE = 0;
        public static final int VALIDATION_WARN = 1;
        public static final int VALIDATION_ERROR = 2;
        private int resourceValidationType = 2;
        private boolean valid;
        private int messageType = 0;
        private String message;
        private ValidationListener validationListener;

        public void validate() {
            this.internalValidate();
            if (this.validationListener != null) {
                this.validationListener.validationFinished();
            }
        }

        private void internalValidate() {
            this.setValid(true);
            if (CDOResourceNodeChooserComposite.this.getResourceName().length() == 0) {
                this.setMessage(Messages.DawnCreateNewResourceWizardPage_10, 3);
                this.setValid(false);
                return;
            }
            if (!CDOResourceNodeChooserComposite.this.getResourceName().endsWith("." + CDOResourceNodeChooserComposite.this.fileExtension)) {
                this.setValid(false);
                this.setMessage(String.valueOf(Messages.CDOResourceNodeChooserComposite_1) + CDOResourceNodeChooserComposite.this.fileExtension, 3);
                return;
            }
            if (CDOResourceNodeChooserComposite.this.view != null && this.getResourceValidationType() != 0) {
                try {
                    if (CDOResourceNodeChooserComposite.this.view.hasResource(CDOResourceNodeChooserComposite.this.getURI().path())) {
                        if (this.getResourceValidationType() == 1) {
                            this.setMessage(Messages.DawnCreateNewResourceWizardPage_11, 2);
                            this.setMessageType(2);
                            this.setValid(true);
                            return;
                        }
                        if (this.getResourceValidationType() == 2) {
                            this.setMessage(Messages.DawnCreateNewResourceWizardPage_12, 3);
                            this.setValid(false);
                            this.setMessageType(3);
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    this.setMessage(e.getMessage());
                    this.setMessageType(3);
                }
            }
            if (this.isValid()) {
                this.setMessage(null);
                this.setMessageType(0);
            }
        }

        private void setMessage(String message, int type) {
            this.setMessage(message);
            this.setMessageType(type);
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessageType(int messageType) {
            this.messageType = messageType;
        }

        public int getMessageType() {
            return this.messageType;
        }

        public void setResourceValidationType(int resourceValidationType) {
            this.resourceValidationType = resourceValidationType;
        }

        public int getResourceValidationType() {
            return this.resourceValidationType;
        }

        public void setValidationListener(ValidationListener validationListener) {
            this.validationListener = validationListener;
        }

        public ValidationListener getValidationListener() {
            return this.validationListener;
        }
    }

    public static interface ValidationListener {
        public void validationFinished();
    }
}

