/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.resource.ASSaver;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class ASSaverResolveVisitor
extends AbstractExtendingVisitor<Object, ASSaver> {
    public ASSaverResolveVisitor(@NonNull ASSaver saver) {
        super(saver);
    }

    @Override
    public Object visitClass(@NonNull Class object) {
        List<Class> superClasses = object.getSuperClasses();
        int i = 0;
        while (i < superClasses.size()) {
            Class referredClass = superClasses.get(i);
            if (referredClass != null) {
                Class resolvedClass = ((ASSaver)this.context).resolveType(referredClass);
                superClasses.set(i, resolvedClass);
            }
            ++i;
        }
        return super.visitClass(object);
    }

    @Override
    public Object visitCollectionType(@NonNull CollectionType object) {
        Class resolvedType;
        Type referredType = ClassUtil.nonNullModel(object.getElementType());
        Class referredClass = referredType.isClass();
        if (referredClass != null && (resolvedType = ((ASSaver)this.context).resolveType(referredClass)) != referredType) {
            object.setElementType(resolvedType);
        }
        return super.visitCollectionType(object);
    }

    @Override
    public Object visitLambdaType(@NonNull LambdaType object) {
        Class resolvedType;
        Type referredType = ClassUtil.nonNullModel(object.getContextType());
        Class referredClass = referredType.isClass();
        if (referredClass != null && (resolvedType = ((ASSaver)this.context).resolveType(referredClass)) != referredType) {
            object.setContextType(resolvedType);
        }
        if ((referredClass = (referredType = ClassUtil.nonNullModel(object.getResultType())).isClass()) != null && (resolvedType = ((ASSaver)this.context).resolveType(referredClass)) != referredType) {
            object.setResultType(resolvedType);
        }
        List<Type> parameterTypes = object.getParameterType();
        int i = 0;
        while (i < parameterTypes.size()) {
            Class resolvedType2;
            referredType = parameterTypes.get(i);
            if (referredType != null && (referredClass = referredType.isClass()) != null && (resolvedType2 = ((ASSaver)this.context).resolveType(referredClass)) != referredType) {
                parameterTypes.set(i, resolvedType2);
            }
            ++i;
        }
        return super.visitLambdaType(object);
    }

    @Override
    public Object visitLoopExp(@NonNull LoopExp object) {
        Iteration referredIteration = ClassUtil.nonNullModel(object.getReferredIteration());
        Iteration resolvedIteration = ((ASSaver)this.context).resolveOperation(referredIteration);
        object.setReferredIteration(resolvedIteration);
        return super.visitLoopExp(object);
    }

    @Override
    public Object visitMapType(@NonNull MapType object) {
        Class resolvedType;
        Type referredType = ClassUtil.nonNullModel(object.getKeyType());
        Class referredClass = referredType.isClass();
        if (referredClass != null && (resolvedType = ((ASSaver)this.context).resolveType(referredClass)) != referredType) {
            object.setKeyType(resolvedType);
        }
        if ((referredClass = (referredType = ClassUtil.nonNullModel(object.getValueType())).isClass()) != null && (resolvedType = ((ASSaver)this.context).resolveType(referredClass)) != referredType) {
            object.setValueType(resolvedType);
        }
        return super.visitMapType(object);
    }

    @Override
    public Object visitOperationCallExp(@NonNull OperationCallExp object) {
        Operation referredOperation = ClassUtil.nonNullModel(object.getReferredOperation());
        Operation resolvedOperation = ((ASSaver)this.context).resolveOperation(referredOperation);
        object.setReferredOperation(resolvedOperation);
        return super.visitOperationCallExp(object);
    }

    @Override
    public Object visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution object) {
        Class resolvedType;
        Type referredType = ClassUtil.nonNullModel(object.getActual());
        Class referredClass = referredType.isClass();
        if (referredClass != null && (resolvedType = ((ASSaver)this.context).resolveType(referredClass)) != referredType) {
            object.setActual(resolvedType);
        }
        return null;
    }

    @Override
    public Object visitTemplateParameter(@NonNull TemplateParameter object) {
        List<Class> constrainingTypes = object.getConstrainingClasses();
        int i = 0;
        while (i < constrainingTypes.size()) {
            Class referredType = constrainingTypes.get(i);
            if (referredType != null) {
                Class resolvedType = ((ASSaver)this.context).resolveType(referredType);
                constrainingTypes.set(i, resolvedType);
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object visitType(@NonNull Type object) {
        return null;
    }

    @Override
    public Object visitTypedElement(@NonNull TypedElement object) {
        Class resolvedType;
        Type referredType = ClassUtil.nonNullEMF(object.getType());
        Class referredClass = referredType.isClass();
        if (referredClass != null && (resolvedType = ((ASSaver)this.context).resolveType(referredClass)) != referredType) {
            object.setType(resolvedType);
        }
        return null;
    }

    @Override
    public Object visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for PivotSaver Resolve pass");
    }
}

