/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.validation;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.AbstractConstraintEvaluator;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.validation.ComposedEValidator;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class PivotEObjectValidator
implements EValidator {
    private static final @NonNull PivotEObjectValidator INSTANCE = new PivotEObjectValidator();
    protected final @Nullable List<Model> complementingModels;

    public static @NonNull ValidationAdapter install(@NonNull ResourceSet resourceSet, @NonNull EnvironmentFactoryInternal environmentFactory) {
        ValidationAdapter validationAdapter = ValidationAdapter.findAdapter(resourceSet);
        if (validationAdapter != null) {
            if (validationAdapter.getEnvironmentFactory() != environmentFactory) {
                throw new IllegalArgumentException("Inconsistent EnvironmentFactory");
            }
        } else {
            validationAdapter = new ValidationAdapter(environmentFactory);
            resourceSet.eAdapters().add((Object)validationAdapter);
        }
        return validationAdapter;
    }

    @Deprecated
    public static synchronized void install(@NonNull EPackage ePackage) {
        PivotEObjectValidator.install(ePackage, null);
    }

    public static synchronized void install(@NonNull EPackage ePackage, @Nullable List<Model> complementingModels) {
        ComposedEValidator composedEValidator = ComposedEValidator.install(ePackage);
        if (complementingModels == null || complementingModels.isEmpty()) {
            composedEValidator.addChild(INSTANCE);
        } else {
            composedEValidator.addChild(new PivotEObjectValidator(complementingModels));
        }
    }

    public static ResourceSet getResourceSet(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics) {
        ResourceSet resourceSet = null;
        if (diagnostics instanceof BasicDiagnostic) {
            for (Object dataObject : ((BasicDiagnostic)diagnostics).getData()) {
                Resource resource;
                if (dataObject instanceof EObject && (resource = EcoreUtil.getRootContainer((EObject)((EObject)dataObject)).eResource()) != null && (resourceSet = resource.getResourceSet()) != null) break;
            }
        }
        if (resourceSet == null) {
            Resource resource;
            if (object instanceof EObject && (resource = EcoreUtil.getRootContainer((EObject)((EObject)object)).eResource()) != null) {
                resourceSet = resource.getResourceSet();
            }
            if (resourceSet == null && (resource = EcoreUtil.getRootContainer((EObject)eClassifier).eResource()) != null) {
                resourceSet = resource.getResourceSet();
            }
        }
        return resourceSet;
    }

    @Deprecated
    protected PivotEObjectValidator() {
        this.complementingModels = null;
    }

    public PivotEObjectValidator(@Nullable List<Model> complementingModels) {
        this.complementingModels = complementingModels;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (eClass != null && !eObject.eIsProxy()) {
            allOk &= this.validatePivot((EClassifier)eClass, eObject, diagnostics, context);
        }
        return allOk;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (eDataType != null) {
            allOk &= this.validatePivot((EClassifier)eDataType, value, diagnostics, context);
        }
        return allOk;
    }

    protected boolean validatePivot(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context) {
        ValidationAdapter validationAdapter;
        ResourceSet resourceSet = PivotEObjectValidator.getResourceSet(eClassifier, object, diagnostics);
        if (resourceSet != null && (validationAdapter = ValidationAdapter.findAdapter(resourceSet)) != null) {
            boolean allOk = validationAdapter.validate(eClassifier, object, this.complementingModels, diagnostics, context);
            return allOk || diagnostics != null;
        }
        return true;
    }

    public static class ValidationAdapter
    extends AdapterImpl {
        protected final @NonNull EnvironmentFactoryInternal environmentFactory;

        public static ValidationAdapter findAdapter(@NonNull ResourceSet resourceSet) {
            for (Adapter adapter : resourceSet.eAdapters()) {
                if (!(adapter instanceof ValidationAdapter)) continue;
                return (ValidationAdapter)adapter;
            }
            EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.findEnvironmentFactory(resourceSet);
            if (environmentFactory != null) {
                ResourceSet externalResourceSet = environmentFactory.getResourceSet();
                for (Adapter adapter : externalResourceSet.eAdapters()) {
                    if (!(adapter instanceof ValidationAdapter)) continue;
                    return (ValidationAdapter)adapter;
                }
            }
            return null;
        }

        public ValidationAdapter(@NonNull EnvironmentFactoryInternal environmentFactory) {
            this.environmentFactory = environmentFactory;
        }

        public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
            return this.environmentFactory;
        }

        @Deprecated
        public boolean validate(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics, @Nullable Map<Object, Object> context) {
            return this.validate(eClassifier, object, null, diagnostics, context);
        }

        public boolean validate(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable List<Model> complementingModels, @Nullable DiagnosticChain diagnostics, @Nullable Map<Object, Object> context) {
            boolean allOk = true;
            PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
            Type type = metamodelManager.getASOfEcore(Type.class, (EObject)eClassifier);
            if (type != null) {
                for (Constraint constraint : metamodelManager.getAllInvariants(type)) {
                    Diagnostic diagnostic;
                    Model containingModel;
                    if (constraint == null || complementingModels != null && !complementingModels.contains(containingModel = PivotUtil.getContainingModel(constraint)) || (diagnostic = this.validate(constraint, object, context)) == null) continue;
                    if (diagnostics != null) {
                        diagnostics.add(diagnostic);
                    }
                    allOk = false;
                    if (diagnostic.getSeverity() != 4) continue;
                    return allOk;
                }
            }
            return allOk;
        }

        public @Nullable Diagnostic validate(final @NonNull Constraint constraint, final @Nullable Object object, final @Nullable Map<Object, Object> context) {
            ExpressionInOCL query;
            LanguageExpression specification = constraint.getOwnedSpecification();
            if (specification == null) {
                return null;
            }
            if (specification.getBody() == null) {
                return null;
            }
            final PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
            try {
                query = metamodelManager.parseSpecification(specification);
            }
            catch (ParserException e) {
                String message = e.getLocalizedMessage();
                return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
            }
            Variable contextVariable = query.getOwnedContext();
            if (contextVariable == null) {
                return null;
            }
            ModelManager oldModelManager = null;
            if (context != null) {
                oldModelManager = (ModelManager)context.get(ModelManager.class);
            }
            EvaluationVisitor.EvaluationVisitorExtension evaluationVisitor = (EvaluationVisitor.EvaluationVisitorExtension)this.environmentFactory.createEvaluationVisitor(object, query, oldModelManager);
            if (context != null) {
                Object monitor;
                ModelManager newModelManager = evaluationVisitor.getExecutor().getModelManager();
                if (newModelManager != oldModelManager) {
                    context.put(ModelManager.class, newModelManager);
                }
                if ((monitor = context.get(Monitor.class)) instanceof Monitor) {
                    evaluationVisitor.setMonitor((Monitor)monitor);
                }
            }
            AbstractConstraintEvaluator<Diagnostic> constraintEvaluator = new AbstractConstraintEvaluator<Diagnostic>(query){

                @Override
                protected String getObjectLabel() {
                    Type type = PivotUtil.getContainingType(constraint);
                    Type primaryType = type != null ? metamodelManager.getPrimaryType(type) : null;
                    EObject eTarget = primaryType != null ? primaryType.getESObject() : null;
                    EClassifier eClassifier = eTarget instanceof EClassifier ? (EClassifier)eTarget : null;
                    return LabelUtil.getLabel(eClassifier, object, context);
                }

                @Override
                protected Diagnostic handleExceptionResult(@NonNull Throwable e) {
                    String message = StringUtil.bind(PivotMessagesInternal.ValidationConstraintException_ERROR_, this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e);
                    return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
                }

                @Override
                protected Diagnostic handleFailureResult(@Nullable Object result) {
                    String message = this.getConstraintResultMessage(result);
                    int severity = this.getConstraintResultSeverity(result);
                    return new BasicDiagnostic(severity, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
                }

                @Override
                protected Diagnostic handleInvalidExpression(@NonNull String message) {
                    return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
                }

                @Override
                protected Diagnostic handleInvalidResult(@NonNull InvalidValueException e) {
                    String message = StringUtil.bind(PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage());
                    return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
                }

                @Override
                protected Diagnostic handleSuccessResult() {
                    return null;
                }
            };
            Diagnostic diagnostic = (Diagnostic)constraintEvaluator.evaluate(evaluationVisitor);
            return diagnostic;
        }
    }
}

