/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.executor;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.internal.elements.AbstractExecutorClass;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.utilities.TypeUtil;

public class ExecutorTupleType
extends AbstractExecutorClass
implements TupleType {
    protected final @NonNull TupleTypeId typeId;

    public ExecutorTupleType(@NonNull TupleTypeId typeId) {
        super("Tuple", 0);
        this.typeId = typeId;
    }

    @Override
    public boolean conformsTo(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof TupleType)) {
            return false;
        }
        return TypeUtil.conformsToTupleType(standardLibrary, this, (TupleType)type);
    }

    @Override
    public @NonNull Class getCommonType(@NonNull IdResolver idResolver, @NonNull Type type) {
        if (type != this) {
            return idResolver.getStandardLibrary().getOclAnyType();
        }
        return this;
    }

    @Override
    public @NonNull TupleTypeId getTupleTypeId() {
        return this.typeId;
    }

    @Override
    public @NonNull TupleTypeId getTypeId() {
        return this.typeId;
    }

    @Override
    public boolean isEqualTo(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof TupleType)) {
            return false;
        }
        return TypeUtil.isEqualToTupleType(standardLibrary, this, (TupleType)type);
    }

    @Override
    public @NonNull Operation lookupActualOperation(@NonNull StandardLibrary standardLibrary, @NonNull Operation apparentOperation) {
        return standardLibrary.getOclTupleType().lookupActualOperation(standardLibrary, apparentOperation);
    }

    @Override
    public @NonNull LibraryFeature lookupImplementation(@NonNull StandardLibrary standardLibrary, @NonNull Operation apparentOperation) {
        return standardLibrary.getOclTupleType().lookupImplementation(standardLibrary, apparentOperation);
    }

    public String toString() {
        return this.typeId.toString();
    }
}

