/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.AbstractConstraintEvaluator;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.internal.delegate.InvocationBehavior;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.ValidationBehavior;
import org.eclipse.ocl.pivot.internal.delegate.ValidationDelegate;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class OCLValidationDelegate
implements ValidationDelegate {
    protected final @NonNull OCLDelegateDomain delegateDomain;
    protected final @NonNull EClassifier eClassifier;

    public OCLValidationDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EClassifier classifier) {
        this.delegateDomain = delegateDomain;
        this.eClassifier = classifier;
    }

    public String toString() {
        return "<" + this.delegateDomain.getURI() + ":validate> " + this.eClassifier.getEPackage().getName() + "::" + this.eClassifier.getName();
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, EOperation invariant, String expression) {
        if (eClass == null) {
            throw new NullPointerException("Null EClass");
        }
        if (eObject == null) {
            throw new NullPointerException("Null EObject");
        }
        MetamodelManager metamodelManager = this.delegateDomain.getMetamodelManager();
        NamedElement namedElement = this.delegateDomain.getPivot(NamedElement.class, (EObject)ClassUtil.nonNullEMF(invariant));
        if (namedElement instanceof Operation) {
            Operation operation = (Operation)namedElement;
            ExpressionInOCL query = InvocationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, operation);
            InvocationBehavior.INSTANCE.validate(operation);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement instanceof Constraint) {
            Constraint constraint = (Constraint)namedElement;
            ExpressionInOCL query = ValidationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, constraint);
            ValidationBehavior.INSTANCE.validate(constraint);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement != null) {
            throw new ClassCastException(String.valueOf(namedElement.getClass().getName()) + " does not provide a Constraint");
        }
        throw new ClassCastException(String.valueOf(invariant.eClass().getName()) + " does not provide a Constraint");
    }

    @Override
    public boolean validate(@NonNull EClass eClass, @NonNull EObject eObject, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull EOperation invariant, String expression, int severity, String source, int code) {
        MetamodelManager metamodelManager = this.delegateDomain.getMetamodelManager();
        NamedElement namedElement = this.delegateDomain.getPivot(NamedElement.class, (EObject)ClassUtil.nonNullEMF(invariant));
        if (namedElement instanceof Operation) {
            Operation operation = (Operation)namedElement;
            ExpressionInOCL query = InvocationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, operation);
            InvocationBehavior.INSTANCE.validate(operation);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement instanceof Constraint) {
            Constraint constraint = (Constraint)namedElement;
            ExpressionInOCL query = ValidationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, constraint);
            ValidationBehavior.INSTANCE.validate(constraint);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, diagnostics, context, invariant.getName(), source, code, query);
        }
        if (namedElement != null) {
            throw new ClassCastException(String.valueOf(namedElement.getClass().getName()) + " does not provide a Constraint");
        }
        throw new IllegalStateException(String.valueOf(invariant.eClass().getName()) + " does not provide a Constraint");
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, String constraintName, String expression) {
        if (eClass == null) {
            throw new NullPointerException("Null EClass");
        }
        if (eObject == null) {
            throw new NullPointerException("Null EObject");
        }
        if (constraintName == null) {
            throw new NullPointerException("Null constraint name");
        }
        return this.validatePivot((EClassifier)eClass, eObject, null, context, constraintName, null, 0);
    }

    @Override
    public boolean validate(@NonNull EClass eClass, @NonNull EObject eObject, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String constraintName, String expression, int severity, String source, int code) {
        return this.validatePivot((EClassifier)eClass, eObject, diagnostics, context, constraintName, source, code);
    }

    public boolean validate(EDataType eDataType, Object value, Map<Object, Object> context, String constraintName, String expression) {
        if (eDataType == null) {
            throw new NullPointerException("Null EClass");
        }
        if (value == null) {
            throw new NullPointerException("Null EObject");
        }
        if (constraintName == null) {
            throw new NullPointerException("Null constraint name");
        }
        return this.validatePivot((EClassifier)eDataType, value, null, context, constraintName, null, 0);
    }

    @Override
    public boolean validate(@NonNull EDataType eDataType, @NonNull Object value, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String constraintName, String expression, int severity, String source, int code) {
        return this.validatePivot((EClassifier)eDataType, value, diagnostics, context, constraintName, source, code);
    }

    protected boolean validateExpressionInOCL(@NonNull EClassifier eClassifier, final @NonNull Object value, final @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, final String source, final int code, @NonNull ExpressionInOCL query) {
        CheckingConstraintEvaluator constraintEvaluator = new CheckingConstraintEvaluator(eClassifier, query){

            @Override
            protected String getObjectLabel() {
                return NameUtil.qualifiedNameFor(value);
            }

            @Override
            protected Boolean handleFailureResult(@Nullable Object result) {
                if (result == null) {
                    String message = this.getConstraintResultMessage(result);
                    EvaluationException cause = new EvaluationException(message);
                    throw new OCLDelegateException(cause);
                }
                if (diagnostics != null) {
                    String message = this.getConstraintResultMessage(result);
                    int severity = this.getConstraintResultSeverity(result);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(severity, source, code, message, new Object[]{value}));
                }
                return Boolean.FALSE;
            }
        };
        OCL ocl = this.delegateDomain.getOCL();
        EvaluationVisitor evaluationVisitor = ocl.createEvaluationVisitor(value, query);
        return (Boolean)((AbstractConstraintEvaluator)constraintEvaluator).evaluate(evaluationVisitor);
    }

    protected boolean validatePivot(@NonNull EClassifier eClassifier, @NonNull Object value, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String constraintName, String source, int code) {
        MetamodelManager metamodelManager = this.delegateDomain.getMetamodelManager();
        Type type = this.delegateDomain.getPivot(Type.class, (EObject)eClassifier);
        Constraint constraint = ValidationBehavior.INSTANCE.getConstraint(metamodelManager, eClassifier, constraintName);
        if (constraint == null) {
            SemanticException cause = new SemanticException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, type, "constraint");
            throw new OCLDelegateException(cause);
        }
        ExpressionInOCL query = null;
        if (type != null) {
            query = ValidationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, constraint);
        }
        if (query == null) {
            SemanticException cause = new SemanticException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, type, "constraint");
            throw new OCLDelegateException(cause);
        }
        return this.validateExpressionInOCL(eClassifier, value, diagnostics, context, constraintName, source, code, query);
    }

    protected static class CheckingConstraintEvaluator
    extends AbstractConstraintEvaluator<Boolean> {
        protected final @NonNull EClassifier eClassifier;

        protected CheckingConstraintEvaluator(@NonNull EClassifier eClassifier, @NonNull ExpressionInOCL query) {
            super(query);
            this.eClassifier = eClassifier;
        }

        @Override
        public Boolean evaluate(@NonNull EvaluationVisitor evaluationVisitor) {
            if (!this.isBooleanConstraint()) {
                String objectLabel = LabelUtil.getLabel(this.query.getType());
                String constraintTypeName = this.getConstraintTypeName();
                String constraintName = this.getConstraintName();
                String checkMessage = StringUtil.bind(PivotMessagesInternal.ValidationConstraintIsNotBooleanType_ERROR_, constraintTypeName, constraintName, objectLabel);
                EvaluationException cause = new EvaluationException(checkMessage);
                throw new OCLDelegateException(cause);
            }
            return (Boolean)super.evaluate(evaluationVisitor);
        }

        @Override
        protected String getObjectLabel() {
            return LabelUtil.getLabel(this.eClassifier, null, null);
        }

        @Override
        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            String constraintTypeName = this.getConstraintTypeName();
            String constraintName = this.getConstraintName();
            String objectLabel = this.getObjectLabel();
            String message = e.toString();
            EvaluationException cause = new EvaluationException(e, PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, constraintTypeName, constraintName, objectLabel, message);
            throw new OCLDelegateException(cause);
        }

        @Override
        protected Boolean handleFailureResult(@Nullable Object result) {
            if (result == null) {
                String message = this.getConstraintResultMessage(result);
                EvaluationException cause = new EvaluationException(message);
                throw new OCLDelegateException(cause);
            }
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidExpression(@NonNull String message) {
            EvaluationException cause = new EvaluationException(message);
            throw new OCLDelegateException(cause);
        }

        @Override
        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            String constraintTypeName = this.getConstraintTypeName();
            String constraintName = this.getConstraintName();
            String objectLabel = this.getObjectLabel();
            String localizedMessage = e.getLocalizedMessage();
            EvaluationException cause = new EvaluationException(e, PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, constraintTypeName, constraintName, objectLabel, localizedMessage);
            throw new OCLDelegateException(cause);
        }

        @Override
        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }
}

