/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo.messages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import org.eclipse.opencert.storage.cdo.messages.PersistenceEventMessage;
import org.eclipse.opencert.storage.cdo.messages.SimpleMessageCreator;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class OpencertPersistenceMessagesProducer {
    private JmsTemplate jmsTemplate;
    private Destination allEntitiesEventsDestination;
    private Map<String, Destination> perEntityTypeEventsDestinations = new HashMap<String, Destination>();

    public OpencertPersistenceMessagesProducer(JmsTemplate jmsTemplate, Destination allEntitiesEventsDestination) {
        this.jmsTemplate = jmsTemplate;
        this.allEntitiesEventsDestination = allEntitiesEventsDestination;
    }

    public void setPerEntityTypeEventsDestinationsList(List<Destination> destinations) {
        for (Destination destination : destinations) {
            String key = destination.toString();
            String entityOnlyKey = key.replaceAll("topic://opencert.persistence.", "");
            this.perEntityTypeEventsDestinations.put(entityOnlyKey, destination);
        }
    }

    public void send(PersistenceEventMessage entityPersistenceEventMessage) {
        Destination targetDestination = this.perEntityTypeEventsDestinations.get(entityPersistenceEventMessage.getEntityType());
        if (targetDestination != null) {
            this.jmsTemplate.send(targetDestination, (MessageCreator)new SimpleMessageCreator(entityPersistenceEventMessage));
        }
        this.jmsTemplate.send(this.allEntitiesEventsDestination, (MessageCreator)new SimpleMessageCreator(entityPersistenceEventMessage));
    }
}

