/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.celleditor;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.opencert.userguidance.StyledText2;
import org.eclipse.opencert.userguidance.autocomplete.AutoCompleteField2;
import org.eclipse.opencert.userguidance.autocomplete.StyledTextContentAdapter;
import org.eclipse.opencert.userguidance.celleditor.CellEditorHighlighter;
import org.eclipse.opencert.userguidance.celleditor.StyledTextCellEditorEx;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StyledWrapTextCellEditor
extends StyledTextCellEditorEx {
    private AutoCompleteField2 field;
    private EObject eobj;
    private int featureID;

    public StyledWrapTextCellEditor(Composite parent, int style, EObject eobj, int featureID) {
        super(parent, style, eobj, featureID);
        this.eobj = eobj;
        this.featureID = featureID;
        this.create(parent);
    }

    @Override
    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
            this.deactivate();
        } else if (keyEvent.character == '\r' && (keyEvent.stateMask & 0x40000) != 0) {
            StyledText styledText = (StyledText)this.getControl();
            int caretOffset = styledText.getCaretOffset();
            String text = styledText.getText();
            styledText.setText(String.valueOf(text) + "\n");
            styledText.setCaretOffset(caretOffset + 1);
        } else if (keyEvent.character == '\r') {
            if (!this.field.isPopupOpen()) {
                this.fireApplyEditorValue();
                this.deactivate();
            }
        } else {
            super.keyReleaseOccured(keyEvent);
        }
    }

    @Override
    protected Control createControl(Composite parent) {
        final StyledText2 styledText = (StyledText2)super.createControl(parent);
        styledText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                CellEditorHighlighter highlighter = new CellEditorHighlighter(styledText.getText(), styledText.getFont(), styledText.getFont());
                highlighter.calculateHighlighting();
                List<StyleRange> ranges = highlighter.getStyles();
                styledText.setStyleRanges(ranges);
            }
        });
        this.field = new AutoCompleteField2(styledText, new StyledTextContentAdapter(), this.eobj, this.featureID);
        return styledText;
    }
}

