/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.autocomplete;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.opencert.userguidance.autocomplete.ContentProposalAdapter2;
import org.eclipse.opencert.userguidance.label.LabelHighlighter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class ContentProposalPopup
extends PopupDialog {
    private final ContentProposalAdapter2 contentProposalAdapter;
    private Listener targetControlListener;
    private PopupCloserListener popupCloser;
    private Table proposalTable;
    private IContentProposal[] proposals;
    private InfoPopupDialog infoPopup;
    private boolean pendingDescriptionUpdate = false;
    private String filterText = "";

    ContentProposalPopup(ContentProposalAdapter2 contentProposalAdapter2, String infoText, IContentProposal[] proposals) {
        super(Display.getDefault().getActiveShell(), 16400, false, false, false, false, false, null, infoText);
        this.contentProposalAdapter = contentProposalAdapter2;
        this.proposals = proposals;
    }

    protected Color getForeground() {
        return JFaceResources.getColorRegistry().get("CONTENT_ASSIST_FOREGROUND_COLOR");
    }

    protected Color getBackground() {
        return JFaceResources.getColorRegistry().get("CONTENT_ASSIST_BACKGROUND_COLOR");
    }

    protected final Control createDialogArea(Composite parent) {
        if (ContentProposalAdapter2.USE_VIRTUAL) {
            this.proposalTable = new Table(parent, 0x10000300);
            parent.setToolTipText("org.eclipse.opencert.userguidance.autocomplete.ContentProposalPopup");
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    ContentProposalPopup.this.handleSetData(event);
                }
            };
            this.proposalTable.addListener(36, listener);
        } else {
            this.proposalTable = new Table(parent, 768);
        }
        this.setProposals(this.filterProposals(this.proposals, this.filterText));
        this.proposalTable.setHeaderVisible(false);
        this.proposalTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == null) {
                    if (ContentProposalPopup.this.infoPopup != null) {
                        ContentProposalPopup.this.infoPopup.close();
                    }
                } else {
                    ContentProposalPopup.this.showProposalDescription();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ContentProposalPopup.this.acceptCurrentProposal();
            }
        });
        return this.proposalTable;
    }

    protected void adjustBounds() {
        Point location = this.contentProposalAdapter.control.getDisplay().map((Control)this.contentProposalAdapter.control.getParent(), null, this.contentProposalAdapter.control.getLocation());
        int initialX = location.x + 3;
        int initialY = location.y + this.contentProposalAdapter.control.getSize().y + 3;
        if (this.contentProposalAdapter.getProposalAcceptanceStyle() == 1) {
            Rectangle insertionBounds = this.contentProposalAdapter.controlContentAdapter.getInsertionBounds(this.contentProposalAdapter.control);
            initialX += insertionBounds.x;
            initialY = location.y + insertionBounds.y + insertionBounds.height;
        }
        if (this.contentProposalAdapter.popupSize == null) {
            GridData data = new GridData(1808);
            data.heightHint = this.proposalTable.getItemHeight() * 10;
            data.widthHint = Math.max(this.contentProposalAdapter.control.getSize().x, 300);
            this.proposalTable.setLayoutData((Object)data);
            this.getShell().pack();
            this.contentProposalAdapter.popupSize = this.getShell().getSize();
        }
        Rectangle constrainedBounds = this.getConstrainedShellBounds(new Rectangle(initialX, initialY, this.contentProposalAdapter.popupSize.x, this.contentProposalAdapter.popupSize.y));
        if (constrainedBounds.y < initialY) {
            this.getShell().setBounds(initialX, location.y - this.contentProposalAdapter.popupSize.y, this.contentProposalAdapter.popupSize.x, this.contentProposalAdapter.popupSize.y);
        } else {
            this.getShell().setBounds(initialX, initialY, this.contentProposalAdapter.popupSize.x, this.contentProposalAdapter.popupSize.y);
        }
        this.getShell().addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.popupSize = ContentProposalPopup.this.getShell().getSize();
                if (ContentProposalPopup.this.infoPopup != null) {
                    ContentProposalPopup.this.infoPopup.adjustBounds();
                }
            }
        });
    }

    private void handleSetData(Event event) {
        TableItem item = (TableItem)event.item;
        int index = this.proposalTable.indexOf(item);
        if (index >= 0 && index < this.proposals.length) {
            IContentProposal current = this.proposals[index];
            item.setText(this.getString(current));
            item.setImage(this.getImage(current));
            item.setData((Object)current);
        }
    }

    private void setProposals(IContentProposal[] newProposals) {
        if (newProposals == null || newProposals.length == 0) {
            newProposals = this.getEmptyProposalArray();
        }
        this.proposals = newProposals;
        if (this.isValid()) {
            int newSize = newProposals.length;
            if (ContentProposalAdapter2.USE_VIRTUAL) {
                this.proposalTable.setItemCount(newSize);
                this.proposalTable.clearAll();
            } else {
                this.proposalTable.setRedraw(false);
                this.proposalTable.setItemCount(newSize);
                TableItem[] items = this.proposalTable.getItems();
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    IContentProposal proposal = newProposals[i];
                    item.setText(this.getString(proposal));
                    item.setImage(this.getImage(proposal));
                    item.setData((Object)proposal);
                    ++i;
                }
                this.proposalTable.setRedraw(true);
            }
            if (newProposals.length > 0) {
                this.selectProposal(0);
            } else if (this.infoPopup != null) {
                this.infoPopup.close();
            }
        }
    }

    private String getString(IContentProposal proposal) {
        if (proposal == null) {
            return "";
        }
        if (this.contentProposalAdapter.labelProvider == null) {
            return proposal.getLabel() == null ? proposal.getContent() : proposal.getLabel();
        }
        return this.contentProposalAdapter.labelProvider.getText((Object)proposal);
    }

    private Image getImage(IContentProposal proposal) {
        if (proposal == null || this.contentProposalAdapter.labelProvider == null) {
            return null;
        }
        return this.contentProposalAdapter.labelProvider.getImage((Object)proposal);
    }

    private IContentProposal[] getEmptyProposalArray() {
        return new IContentProposal[0];
    }

    private boolean isValid() {
        return this.proposalTable != null && !this.proposalTable.isDisposed();
    }

    boolean hasFocus() {
        if (!this.isValid()) {
            return false;
        }
        if (this.getShell().isFocusControl() || this.proposalTable.isFocusControl()) {
            return true;
        }
        return this.infoPopup != null && this.infoPopup.hasFocus();
    }

    private IContentProposal getSelectedProposal() {
        if (this.isValid()) {
            int i = this.proposalTable.getSelectionIndex();
            if (this.proposals == null || i < 0 || i >= this.proposals.length) {
                return null;
            }
            return this.proposals[i];
        }
        return null;
    }

    private void selectProposal(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"Proposal index should never be negative");
        if (!this.isValid() || this.proposals == null || index >= this.proposals.length) {
            return;
        }
        this.proposalTable.setSelection(index);
        this.proposalTable.showSelection();
        this.showProposalDescription();
    }

    public int open() {
        int value = super.open();
        if (this.popupCloser == null) {
            this.popupCloser = new PopupCloserListener();
        }
        this.popupCloser.installListeners();
        IContentProposal p = this.getSelectedProposal();
        if (p != null) {
            this.showProposalDescription();
        }
        return value;
    }

    public boolean close() {
        this.popupCloser.removeListeners();
        if (this.infoPopup != null) {
            this.infoPopup.close();
        }
        boolean ret = super.close();
        this.contentProposalAdapter.notifyPopupClosed();
        return ret;
    }

    private void showProposalDescription() {
        if (!this.pendingDescriptionUpdate) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ContentProposalPopup.this.pendingDescriptionUpdate = true;
                    try {
                        Thread.sleep(750L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (!ContentProposalPopup.this.isValid()) {
                        return;
                    }
                    ContentProposalPopup.this.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IContentProposal p = ContentProposalPopup.this.getSelectedProposal();
                            if (p != null) {
                                String description = p.getDescription();
                                if (description != null) {
                                    if (ContentProposalPopup.this.infoPopup == null) {
                                        ContentProposalPopup.this.infoPopup = new InfoPopupDialog(ContentProposalPopup.this.getShell());
                                        ContentProposalPopup.this.infoPopup.open();
                                        ContentProposalPopup.this.infoPopup.getShell().addDisposeListener(new DisposeListener(){

                                            public void widgetDisposed(DisposeEvent event) {
                                                ContentProposalPopup.this.infoPopup = null;
                                            }
                                        });
                                    }
                                    ContentProposalPopup.this.infoPopup.setContents(p.getDescription());
                                } else if (ContentProposalPopup.this.infoPopup != null) {
                                    ContentProposalPopup.this.infoPopup.close();
                                }
                                ContentProposalPopup.this.pendingDescriptionUpdate = false;
                            }
                        }
                    });
                }
            };
            Thread t = new Thread(runnable);
            t.start();
        }
    }

    private void acceptCurrentProposal() {
        IContentProposal proposal = this.getSelectedProposal();
        this.close();
        this.contentProposalAdapter.proposalAccepted(proposal);
    }

    private void recomputeProposals(String filterText) {
        IContentProposal[] allProposals = this.contentProposalAdapter.getProposals();
        if (allProposals == null) {
            allProposals = this.getEmptyProposalArray();
        }
        if (allProposals.length == 0) {
            this.proposals = allProposals;
            this.close();
        } else {
            this.setProposals(this.filterProposals(allProposals, filterText));
        }
    }

    private void asyncRecomputeProposals(final String filterText) {
        if (this.isValid()) {
            this.contentProposalAdapter.control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ContentProposalPopup.this.contentProposalAdapter.recordCursorPosition();
                    ContentProposalPopup.this.recomputeProposals(filterText);
                }
            });
        } else {
            this.recomputeProposals(filterText);
        }
    }

    private IContentProposal[] filterProposals(IContentProposal[] proposals, String filterString) {
        if (filterString.length() == 0) {
            return proposals;
        }
        ArrayList<IContentProposal> list = new ArrayList<IContentProposal>();
        int i = 0;
        while (i < proposals.length) {
            String string = this.getString(proposals[i]);
            if (string.length() >= filterString.length() && string.substring(0, filterString.length()).equalsIgnoreCase(filterString)) {
                list.add(proposals[i]);
            }
            ++i;
        }
        return list.toArray(new IContentProposal[list.size()]);
    }

    public Listener getTargetControlListener() {
        if (this.targetControlListener == null) {
            this.targetControlListener = new TargetControlListener();
        }
        return this.targetControlListener;
    }

    private class InfoPopupDialog
    extends PopupDialog {
        private StyledText text;
        private String contents;

        InfoPopupDialog(Shell parent) {
            super(parent, 540676, false, false, false, false, false, null, null);
            this.contents = "";
        }

        protected Control createDialogArea(Composite parent) {
            this.text = new StyledText(parent, 524362);
            GridData gd = new GridData(1809);
            gd.horizontalIndent = 1;
            gd.verticalIndent = 1;
            this.text.setLayoutData((Object)gd);
            this.text.setText(this.contents);
            this.text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent event) {
                    ContentProposalPopup.this.close();
                }
            });
            return this.text;
        }

        protected void adjustBounds() {
            Rectangle proposedBounds;
            Rectangle parentBounds = this.getParentShell().getBounds();
            Rectangle rightProposedBounds = new Rectangle(parentBounds.x + parentBounds.width + 1, parentBounds.y + 1, parentBounds.width, parentBounds.height);
            if ((rightProposedBounds = this.getConstrainedShellBounds(rightProposedBounds)).intersects(parentBounds)) {
                Rectangle leftProposedBounds = new Rectangle(parentBounds.x - parentBounds.width - 1 - 1, parentBounds.y, parentBounds.width, parentBounds.height);
                if ((leftProposedBounds = this.getConstrainedShellBounds(leftProposedBounds)).intersects(parentBounds)) {
                    if (rightProposedBounds.x - parentBounds.x >= parentBounds.x - leftProposedBounds.x) {
                        rightProposedBounds.x = parentBounds.x + parentBounds.width + 1;
                        proposedBounds = rightProposedBounds;
                    } else {
                        leftProposedBounds.width = parentBounds.x - 1 - leftProposedBounds.x;
                        proposedBounds = leftProposedBounds;
                    }
                } else {
                    proposedBounds = leftProposedBounds;
                }
            } else {
                proposedBounds = rightProposedBounds;
            }
            this.getShell().setBounds(proposedBounds);
        }

        protected Color getForeground() {
            return ((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.control.getDisplay().getSystemColor(28);
        }

        protected Color getBackground() {
            return ((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.control.getDisplay().getSystemColor(29);
        }

        void setContents(String newContents) {
            if (newContents == null) {
                newContents = "";
            }
            this.contents = newContents;
            if (this.text != null && !this.text.isDisposed()) {
                LabelHighlighter highlighter = new LabelHighlighter(this.contents, this.text.getFont(), this.text.getFont());
                highlighter.calculateHighlighting();
                this.text.setText(highlighter.getOutputText());
                this.text.setStyleRanges(highlighter.getStylesArray());
            }
        }

        boolean hasFocus() {
            if (this.text == null || this.text.isDisposed()) {
                return false;
            }
            return this.text.getShell().isFocusControl() || this.text.isFocusControl();
        }
    }

    private final class PopupCloserListener
    implements Listener {
        private boolean scrollbarClicked = false;

        private PopupCloserListener() {
        }

        public void handleEvent(final Event e) {
            if (e.type == 16) {
                this.scrollbarClicked = false;
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ContentProposalPopup.this.isValid()) {
                            if (PopupCloserListener.this.scrollbarClicked || ContentProposalPopup.this.hasFocus()) {
                                return;
                            }
                            Shell activeShell = e.display.getActiveShell();
                            if (activeShell == ContentProposalPopup.this.getShell() || ContentProposalPopup.this.infoPopup != null && ContentProposalPopup.this.infoPopup.getShell() == activeShell) {
                                return;
                            }
                            ContentProposalPopup.this.close();
                        }
                    }
                });
                return;
            }
            if (e.type == 13) {
                this.scrollbarClicked = true;
                return;
            }
            if (e.type == 8 || e.type == 3) {
                return;
            }
            ContentProposalPopup.this.close();
        }

        void installListeners() {
            ContentProposalPopup.this.proposalTable.addListener(16, (Listener)this);
            ScrollBar scrollbar = ContentProposalPopup.this.proposalTable.getVerticalBar();
            if (scrollbar != null) {
                scrollbar.addListener(13, (Listener)this);
            }
            ContentProposalPopup.this.getShell().addListener(27, (Listener)this);
            ContentProposalPopup.this.getShell().addListener(21, (Listener)this);
            ((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.control.addListener(12, (Listener)this);
            ((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.control.addListener(16, (Listener)this);
            Shell controlShell = ((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.control.getShell();
            controlShell.addListener(10, (Listener)this);
            controlShell.addListener(11, (Listener)this);
        }

        void removeListeners() {
            if (ContentProposalPopup.this.isValid()) {
                ContentProposalPopup.this.proposalTable.removeListener(16, (Listener)this);
                ScrollBar scrollbar = ContentProposalPopup.this.proposalTable.getVerticalBar();
                if (scrollbar != null) {
                    scrollbar.removeListener(13, (Listener)this);
                }
                ContentProposalPopup.this.getShell().removeListener(27, (Listener)this);
                ContentProposalPopup.this.getShell().removeListener(21, (Listener)this);
            }
            if (((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.control != null && !((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.control.isDisposed()) {
                ((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.control.removeListener(12, (Listener)this);
                ((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.control.removeListener(16, (Listener)this);
                Shell controlShell = ((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.control.getShell();
                controlShell.removeListener(10, (Listener)this);
                controlShell.removeListener(11, (Listener)this);
            }
        }
    }

    private final class TargetControlListener
    implements Listener {
        private TargetControlListener() {
        }

        public void handleEvent(Event e) {
            if (!ContentProposalPopup.this.isValid()) {
                return;
            }
            char key = e.character;
            if (e.type == 31) {
                if (key != '\u0000') {
                    e.doit = false;
                    return;
                }
                e.detail = 0;
                e.doit = true;
            } else {
                e.doit = ((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.propagateKeys;
            }
            if (key == '\u0000') {
                int newSelection = ContentProposalPopup.this.proposalTable.getSelectionIndex();
                int visibleRows = ((ContentProposalPopup)ContentProposalPopup.this).proposalTable.getSize().y / ContentProposalPopup.this.proposalTable.getItemHeight() - 1;
                switch (e.keyCode) {
                    case 0x1000001: {
                        if (--newSelection < 0) {
                            newSelection = ContentProposalPopup.this.proposalTable.getItemCount() - 1;
                        }
                        if (e.type != 1) break;
                        e.doit = false;
                        break;
                    }
                    case 0x1000002: {
                        if (++newSelection > ContentProposalPopup.this.proposalTable.getItemCount() - 1) {
                            newSelection = 0;
                        }
                        if (e.type != 1) break;
                        e.doit = false;
                        break;
                    }
                    case 0x1000006: {
                        if ((newSelection += visibleRows) >= ContentProposalPopup.this.proposalTable.getItemCount()) {
                            newSelection = ContentProposalPopup.this.proposalTable.getItemCount() - 1;
                        }
                        if (e.type != 1) break;
                        e.doit = false;
                        break;
                    }
                    case 0x1000005: {
                        if ((newSelection -= visibleRows) < 0) {
                            newSelection = 0;
                        }
                        if (e.type != 1) break;
                        e.doit = false;
                        break;
                    }
                    case 0x1000007: {
                        newSelection = 0;
                        if (e.type != 1) break;
                        e.doit = false;
                        break;
                    }
                    case 0x1000008: {
                        newSelection = ContentProposalPopup.this.proposalTable.getItemCount() - 1;
                        if (e.type != 1) break;
                        e.doit = false;
                        break;
                    }
                    case 0x1000003: 
                    case 0x1000004: {
                        if (e.type == 31) {
                            e.doit = false;
                            break;
                        }
                        e.doit = true;
                        String contents = ContentProposalPopup.this.contentProposalAdapter.getControlContentAdapter().getControlContents(ContentProposalPopup.this.contentProposalAdapter.getControl());
                        if (contents.length() <= 0) break;
                        ContentProposalPopup.this.asyncRecomputeProposals(ContentProposalPopup.this.filterText);
                        break;
                    }
                    default: {
                        if (e.keyCode != 16777298 && e.keyCode != 16777299 && e.keyCode != SWT.MOD1 && e.keyCode != SWT.MOD2 && e.keyCode != SWT.MOD3 && e.keyCode != SWT.MOD4) {
                            ContentProposalPopup.this.close();
                        }
                        return;
                    }
                }
                if (newSelection >= 0) {
                    ContentProposalPopup.this.selectProposal(newSelection);
                }
                return;
            }
            switch (key) {
                case '\u001b': {
                    e.doit = false;
                    ContentProposalPopup.this.close();
                    break;
                }
                case '\n': 
                case '\r': {
                    e.doit = false;
                    IContentProposal p = ContentProposalPopup.this.getSelectedProposal();
                    if (p != null) {
                        ContentProposalPopup.this.acceptCurrentProposal();
                        break;
                    }
                    ContentProposalPopup.this.close();
                    break;
                }
                case '\t': {
                    e.doit = false;
                    ContentProposalPopup.this.getShell().setFocus();
                    return;
                }
                case '\b': {
                    if (((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.filterStyle != 1) {
                        if (ContentProposalPopup.this.filterText.length() == 0) {
                            return;
                        }
                        ContentProposalPopup.this.filterText = ContentProposalPopup.this.filterText.substring(0, ContentProposalPopup.this.filterText.length() - 1);
                        ContentProposalPopup.this.asyncRecomputeProposals(ContentProposalPopup.this.filterText);
                        return;
                    }
                    int pos = ContentProposalPopup.this.contentProposalAdapter.getControlContentAdapter().getCursorPosition(ContentProposalPopup.this.contentProposalAdapter.getControl());
                    if (pos <= 0) break;
                    ContentProposalPopup.this.asyncRecomputeProposals(ContentProposalPopup.this.filterText);
                    break;
                }
                default: {
                    if (!Character.isDefined(key)) break;
                    if (((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.filterStyle == 3) {
                        ContentProposalPopup contentProposalPopup = ContentProposalPopup.this;
                        contentProposalPopup.filterText = String.valueOf(contentProposalPopup.filterText) + String.valueOf(key);
                    } else if (((ContentProposalPopup)ContentProposalPopup.this).contentProposalAdapter.filterStyle == 2) {
                        ContentProposalPopup.this.filterText = String.valueOf(key);
                    }
                    ContentProposalPopup.this.asyncRecomputeProposals(ContentProposalPopup.this.filterText);
                }
            }
        }
    }
}

