/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.tweaklets.PreferencePageEnhancer;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.util.PrefUtil;
import org.osgi.service.prefs.BackingStoreException;

public class ViewsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String E4_THEME_EXTENSION_POINT = "org.eclipse.e4.ui.css.swt.theme";
    private IThemeEngine engine;
    private ComboViewer themeIdCombo;
    private ControlDecoration themeComboDecorator;
    private ITheme currentTheme;
    private String defaultTheme;
    private Button enableAnimations;
    private Button enableMru;
    private Button useColoredLabels;
    private Text colorsAndFontsThemeDescriptionText;
    private ComboViewer colorsAndFontsThemeCombo;
    private ControlDecoration colorFontsDecorator;
    private ColorsAndFontsTheme currentColorsAndFontsTheme;
    private Map<String, String> themeAssociations;
    private boolean highContrastMode;
    private Button themingEnabled;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = new Composite(parent, 0);
        this.themingEnabled = this.createCheckButton(comp, WorkbenchMessages.ThemingEnabled, this.engine != null);
        if (this.engine == null) {
            GridLayout layout = new GridLayout(1, false);
            layout.horizontalSpacing = 10;
            comp.setLayout((Layout)layout);
            this.createThemeIndependentComposits(comp);
            return comp;
        }
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        comp.setLayout((Layout)layout);
        new Label(comp, 0).setText(WorkbenchMessages.ViewsPreferencePage_Theme);
        this.highContrastMode = parent.getDisplay().getHighContrast();
        this.themeIdCombo = new ComboViewer(comp, 8);
        this.themeIdCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ITheme)element).getLabel();
            }
        });
        this.themeIdCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.themeIdCombo.setInput(this.getCSSThemes(this.highContrastMode));
        this.themeIdCombo.getCombo().setEnabled(!this.highContrastMode);
        this.themeIdCombo.getControl().setLayoutData((Object)new GridData(768));
        this.currentTheme = this.engine.getActiveTheme();
        if (this.currentTheme != null) {
            this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentTheme));
        }
        this.themeComboDecorator = new ControlDecoration((Control)this.themeIdCombo.getCombo(), 16512);
        this.themeIdCombo.addSelectionChangedListener(event -> {
            ITheme selection = this.getSelectedTheme();
            if (!selection.equals(this.currentTheme)) {
                this.themeComboDecorator.setDescriptionText(WorkbenchMessages.ThemeChangeWarningText);
                Image decorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
                this.themeComboDecorator.setImage(decorationImage);
                this.themeComboDecorator.show();
            } else {
                this.themeComboDecorator.hide();
            }
            try {
                ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).setSelection(selection);
            }
            catch (SWTException e) {
                WorkbenchPlugin.log("Failed to set CSS preferences", e);
            }
            this.selectColorsAndFontsTheme(this.getColorAndFontThemeIdByThemeId(selection.getId()));
        });
        this.currentColorsAndFontsTheme = this.getCurrentColorsAndFontsTheme();
        this.createColorsAndFontsThemeCombo(comp);
        this.createColorsAndFontsThemeDescriptionText(comp);
        this.createThemeIndependentComposits(comp);
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).setSelection(this.currentTheme);
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).createContents(comp);
        if (this.currentTheme != null) {
            String colorsAndFontsThemeId = this.getColorAndFontThemeIdByThemeId(this.currentTheme.getId());
            if (colorsAndFontsThemeId != null && !this.currentColorsAndFontsTheme.getId().equals(colorsAndFontsThemeId)) {
                colorsAndFontsThemeId = this.currentColorsAndFontsTheme.getId();
            }
            this.selectColorsAndFontsTheme(colorsAndFontsThemeId);
        }
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    private void createThemeIndependentComposits(Composite comp) {
        this.createEnableAnimationsPref(comp);
        this.createColoredLabelsPref(comp);
        this.createEnableMruPref(comp);
    }

    private List<ITheme> getCSSThemes(boolean highContrastMode) {
        ArrayList<ITheme> themes = new ArrayList<ITheme>();
        for (ITheme theme : this.engine.getThemes()) {
            if (!highContrastMode && !Util.isGtk() && theme.getId().equals("org.eclipse.e4.ui.css.theme.high-contrast")) continue;
            themes.add(theme);
        }
        themes.sort((t1, t2) -> t1.getLabel().compareTo(t2.getLabel()));
        return themes;
    }

    private void createColoredLabelsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.useColoredLabels = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_useColoredLabels, apiStore.getBoolean("USE_COLORED_LABELS"));
    }

    private Button createCheckButton(Composite composite, String text, boolean selection) {
        Button button = new Button(composite, 32);
        GridData data = new GridData(1, 0x1000000, false, false, 2, 1);
        button.setLayoutData((Object)data);
        button.setText(text);
        button.setSelection(selection);
        return button;
    }

    private Label createLabel(Composite composite, String text) {
        Label label = new Label(composite, 0);
        GridData data = new GridData(1, 0x1000000, false, false, 2, 1);
        label.setLayoutData((Object)data);
        label.setText(text);
        return label;
    }

    protected void createEnableMruPref(Composite composite) {
        boolean mruControlledByCSS;
        this.createLabel(composite, "");
        this.createLabel(composite, WorkbenchMessages.ViewsPreference_visibleTabs_description);
        IEclipsePreferences prefs = this.getSwtRendererPreferences();
        if (this.engine != null && (mruControlledByCSS = prefs.getBoolean("MRUControlledByCSS", false))) {
            return;
        }
        boolean defaultValue = this.getDefaultMRUValue();
        boolean actualValue = prefs.getBoolean("enableMRU", defaultValue);
        this.enableMru = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_enableMRU, actualValue);
    }

    protected void createEnableAnimationsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_enableAnimations, apiStore.getBoolean("ENABLE_ANIMATIONS"));
    }

    private ITheme getSelectedTheme() {
        return (ITheme)this.themeIdCombo.getStructuredSelection().getFirstElement();
    }

    @Override
    public void init(IWorkbench workbench) {
        MApplication application = (MApplication)workbench.getService(MApplication.class);
        IEclipseContext context = application.getContext();
        this.defaultTheme = (String)context.get("cssTheme");
        this.engine = (IThemeEngine)context.get(IThemeEngine.class);
    }

    public boolean performOk() {
        ITheme theme;
        if (this.engine != null && (theme = this.getSelectedTheme()) != null) {
            this.engine.setTheme(this.getSelectedTheme(), !this.highContrastMode);
        }
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        apiStore.setValue("ENABLE_ANIMATIONS", this.enableAnimations.getSelection());
        apiStore.setValue("USE_COLORED_LABELS", this.useColoredLabels.getSelection());
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).performOK();
        IEclipsePreferences prefs = this.getSwtRendererPreferences();
        if (this.enableMru != null) {
            prefs.putBoolean("enableMRU", this.enableMru.getSelection());
        }
        prefs.putBoolean("themeEnabled", this.themingEnabled.getSelection());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            WorkbenchPlugin.log("Failed to set SWT renderer preferences", e);
        }
        return super.performOk();
    }

    private IEclipsePreferences getSwtRendererPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.workbench.renderers.swt");
    }

    private boolean getDefaultMRUValue() {
        return this.getSwtRendererPreferences().getBoolean("enableMRUDefault", true);
    }

    private void setColorsAndFontsTheme(ColorsAndFontsTheme theme) {
        org.eclipse.ui.themes.ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (theme != null && !currentTheme.getId().equals(theme.getId())) {
            PlatformUI.getWorkbench().getThemeManager().setCurrentTheme(theme.getId());
        }
    }

    protected void performDefaults() {
        if (this.engine != null) {
            this.setColorsAndFontsTheme(this.currentColorsAndFontsTheme);
            ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).performDefaults();
            this.engine.setTheme(this.defaultTheme, true);
            if (this.engine.getActiveTheme() != null) {
                this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.engine.getActiveTheme()));
            }
        }
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations.setSelection(apiStore.getDefaultBoolean("ENABLE_ANIMATIONS"));
        this.useColoredLabels.setSelection(apiStore.getDefaultBoolean("USE_COLORED_LABELS"));
        if (this.enableMru != null) {
            this.enableMru.setSelection(this.getDefaultMRUValue());
        }
        super.performDefaults();
    }

    public boolean performCancel() {
        if (this.engine != null) {
            this.setColorsAndFontsTheme(this.currentColorsAndFontsTheme);
            if (this.currentTheme != null) {
                this.engine.setTheme(this.currentTheme, false);
            }
        }
        return super.performCancel();
    }

    protected void performApply() {
        super.performApply();
        if (this.engine != null) {
            ColorsAndFontsTheme colorsAndFontsTheme;
            ITheme theme = this.getSelectedTheme();
            if (theme != null) {
                this.currentTheme = theme;
            }
            if ((colorsAndFontsTheme = this.getSelectedColorsAndFontsTheme()) != null) {
                this.currentColorsAndFontsTheme = colorsAndFontsTheme;
            }
            this.themeComboDecorator.hide();
            this.colorFontsDecorator.hide();
        }
    }

    private void createColorsAndFontsThemeCombo(Composite composite) {
        new Label(composite, 0).setText(WorkbenchMessages.ViewsPreference_currentTheme);
        this.colorsAndFontsThemeCombo = new ComboViewer(composite, 8);
        this.colorsAndFontsThemeCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.colorsAndFontsThemeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ColorsAndFontsTheme)element).getLabel();
            }
        });
        this.colorFontsDecorator = new ControlDecoration((Control)this.colorsAndFontsThemeCombo.getCombo(), 16512);
        this.colorsAndFontsThemeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.colorsAndFontsThemeCombo.setInput(this.getColorsAndFontsThemes());
        this.colorsAndFontsThemeCombo.getControl().setLayoutData((Object)new GridData(768));
        this.colorsAndFontsThemeCombo.addSelectionChangedListener(event -> {
            ColorsAndFontsTheme colorsAndFontsTheme = this.getSelectedColorsAndFontsTheme();
            if (!colorsAndFontsTheme.equals(this.currentColorsAndFontsTheme)) {
                Image decorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
                this.colorFontsDecorator.setImage(decorationImage);
                this.colorFontsDecorator.setDescriptionText(WorkbenchMessages.ThemeChangeWarningText);
                this.colorFontsDecorator.show();
            } else {
                this.colorFontsDecorator.hide();
            }
            this.refreshColorsAndFontsThemeDescriptionText(colorsAndFontsTheme);
            this.setColorsAndFontsTheme(colorsAndFontsTheme);
        });
    }

    private void createColorsAndFontsThemeDescriptionText(Composite parent) {
        new Label(parent, 0).setText(WorkbenchMessages.ViewsPreference_currentThemeDescription);
        this.colorsAndFontsThemeDescriptionText = new Text(parent, 2888);
        GridData layoutData = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)parent);
        layoutData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)2);
        gc.dispose();
        this.colorsAndFontsThemeDescriptionText.setLayoutData((Object)layoutData);
    }

    private void selectColorsAndFontsTheme(String colorAndFontThemeId) {
        if (colorAndFontThemeId == null) {
            colorAndFontThemeId = this.currentColorsAndFontsTheme.getId();
        }
        List colorsAndFontsThemes = (List)this.colorsAndFontsThemeCombo.getInput();
        int i = 0;
        while (i < colorsAndFontsThemes.size()) {
            if (((ColorsAndFontsTheme)colorsAndFontsThemes.get(i)).getId().equals(colorAndFontThemeId)) {
                StructuredSelection selection = new StructuredSelection(colorsAndFontsThemes.get(i));
                this.colorsAndFontsThemeCombo.setSelection((ISelection)selection);
                break;
            }
            ++i;
        }
    }

    private String getColorAndFontThemeIdByThemeId(String themeId) {
        String result;
        if (this.themeAssociations == null) {
            this.themeAssociations = this.createThemeAssociations();
        }
        if ((result = this.themeAssociations.get(themeId)) == null) {
            for (Map.Entry<String, String> entry : this.themeAssociations.entrySet()) {
                if (!themeId.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return result;
    }

    private Map<String, String> createThemeAssociations() {
        HashMap<String, String> result = new HashMap<String, String>();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(E4_THEME_EXTENSION_POINT);
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equals("themeAssociation")) {
                    String themeId = ce.getAttribute("themeId");
                    String osVersion = ce.getAttribute("os_version");
                    result.put(osVersion != null ? String.valueOf(themeId) + osVersion : themeId, ce.getAttribute("colorAndFontId"));
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private List<ColorsAndFontsTheme> getColorsAndFontsThemes() {
        ArrayList<ColorsAndFontsTheme> result = new ArrayList<ColorsAndFontsTheme>();
        org.eclipse.ui.themes.ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        IThemeDescriptor[] descs = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        String defaultThemeString = PlatformUI.getWorkbench().getThemeManager().getTheme("org.eclipse.ui.defaultTheme").getLabel();
        if (currentTheme.getId().equals("org.eclipse.ui.defaultTheme")) {
            defaultThemeString = NLS.bind((String)WorkbenchMessages.ViewsPreference_currentThemeFormat, (Object[])new Object[]{defaultThemeString});
        }
        result.add(new ColorsAndFontsTheme("org.eclipse.ui.defaultTheme", defaultThemeString));
        IThemeDescriptor[] iThemeDescriptorArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            IThemeDescriptor themeDescriptor = iThemeDescriptorArray[n2];
            String themeString = themeDescriptor.getName();
            if (themeDescriptor.getId().equals(currentTheme.getId())) {
                themeString = NLS.bind((String)WorkbenchMessages.ViewsPreference_currentThemeFormat, (Object[])new Object[]{themeString});
            }
            result.add(new ColorsAndFontsTheme(themeDescriptor.getId(), themeString));
            ++n2;
        }
        return result;
    }

    private void refreshColorsAndFontsThemeDescriptionText(ColorsAndFontsTheme theme) {
        String description = "";
        IThemeDescriptor[] descs = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        int i = 0;
        while (theme != null && description == null && i < descs.length) {
            if (descs[i].getId().equals(theme.getId())) {
                description = descs[i].getDescription();
            }
            ++i;
        }
        this.colorsAndFontsThemeDescriptionText.setText(description);
    }

    private ColorsAndFontsTheme getSelectedColorsAndFontsTheme() {
        return (ColorsAndFontsTheme)this.colorsAndFontsThemeCombo.getStructuredSelection().getFirstElement();
    }

    private ColorsAndFontsTheme getCurrentColorsAndFontsTheme() {
        org.eclipse.ui.themes.ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        return new ColorsAndFontsTheme(theme.getId(), theme.getLabel());
    }

    private static class ColorsAndFontsTheme {
        private String label;
        private String id;

        public ColorsAndFontsTheme(String id, String label) {
            this.id = id;
            this.label = label;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColorsAndFontsTheme other = (ColorsAndFontsTheme)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

