/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.version;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.internal.version.Element;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.version.IElement;
import org.eclipse.oomph.version.IRelease;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.VersionUtil;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Release
implements IRelease {
    public static final String RELEASE_TAG = "release";
    public static final String FEATURE_TAG = "feature";
    public static final String PLUGIN_TAG = "plugin";
    public static final String PRODUCT_TAG = "product";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String VERSION_ATTRIBUTE = "version";
    public static final String FRAGMENT_ATTRIBUTE = "fragment";
    public static final String LICENSE_ATTRIBUTE = "license";
    private static final String INDENT = "\t";
    private IFile file;
    private byte[] digest;
    private Map<IElement, IElement> elements = new HashMap<IElement, IElement>();

    public Release(IFile file) {
        this.file = file;
    }

    public Release(SAXParser parser, IFile file) throws CoreException, IOException, SAXException, NoSuchAlgorithmException {
        this.file = file;
        XMLHandler handler = new XMLHandler();
        InputStream contents = null;
        try {
            contents = file.getContents();
            parser.parse(contents, (DefaultHandler)handler);
            if (!handler.hasReleaseTag()) {
                throw new IOException("Release specification file does not contain a <release> element: " + file.getFullPath());
            }
            this.digest = VersionUtil.getSHA1(file);
        }
        finally {
            IOUtil.closeSilent((Closeable)contents);
        }
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public byte[] getDigest() {
        return this.digest;
    }

    @Override
    public Map<IElement, IElement> getElements() {
        return this.elements;
    }

    @Override
    public IElement resolveElement(IElement key) {
        return this.elements.get(key);
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    public void write() throws IOException, CoreException, NoSuchAlgorithmException {
        StringBuilder builder = new StringBuilder();
        this.writeRelease(builder);
        String xml = builder.toString();
        xml = xml.replace("\n", VersionUtil.getLineDelimiter(this.file));
        ByteArrayInputStream contents = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        if (this.file.exists()) {
            this.file.setContents((InputStream)contents, true, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.create((InputStream)contents, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.digest = VersionUtil.getSHA1(this.file);
    }

    private void writeRelease(StringBuilder builder) {
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        builder.append("<release>\n");
        ArrayList<IElement> list = new ArrayList<IElement>(this.elements.keySet());
        Collections.sort(list, new Comparator<IElement>(){

            @Override
            public int compare(IElement o1, IElement o2) {
                int result = o1.getType().compareTo(o2.getType());
                if (result == 0) {
                    result = StringUtil.safe((String)o1.getName()).compareTo(StringUtil.safe((String)o2.getName()));
                }
                if (result == 0) {
                    result = o1.getVersion().compareTo(o2.getVersion());
                }
                return result;
            }
        });
        for (IElement element : list) {
            this.writeElement(builder, element, INDENT);
        }
        builder.append("</release>\n");
    }

    private void writeElement(StringBuilder builder, IElement element, String indent) {
        String name = element.getName();
        Version version = element.getVersion();
        builder.append(String.valueOf(indent) + "<" + element.getTag() + " " + NAME_ATTRIBUTE + "=\"" + name + "\" " + (element.isFragment() ? "fragment=\"true\" " : "") + VERSION_ATTRIBUTE + "=\"" + version + "\"" + (element.isLicenseFeature() ? " license=\"true\"" : ""));
        List<IElement> content = element.getChildren();
        if (content.isEmpty()) {
            builder.append("/");
            this.writeElementEnd(builder, element);
        } else {
            this.writeElementEnd(builder, element);
            for (IElement child : content) {
                this.writeElement(builder, child, String.valueOf(indent) + INDENT);
            }
            builder.append(String.valueOf(indent) + "</" + element.getTag() + ">\n");
        }
    }

    private void writeElementEnd(StringBuilder builder, IElement element) {
        builder.append(">");
        if (element.getVersion().equals((Object)Version.emptyVersion)) {
            builder.append(" <!-- UNRESOLVED -->");
        }
        builder.append("\n");
    }

    public class XMLHandler
    extends DefaultHandler {
        private IElement parent;
        private int level;

        public boolean hasReleaseTag() {
            return this.level == 1;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (Release.RELEASE_TAG.equalsIgnoreCase(qName)) {
                ++this.level;
            } else if (Release.FEATURE_TAG.equalsIgnoreCase(qName)) {
                if (this.level == 0) {
                    return;
                }
                IElement element = this.createElement(IElement.Type.FEATURE, attributes);
                if (++this.level == 2) {
                    Release.this.elements.put(element, element);
                    this.parent = element;
                } else {
                    this.parent.getChildren().add(element);
                }
            } else if (Release.PRODUCT_TAG.equalsIgnoreCase(qName)) {
                if (this.level == 0) {
                    return;
                }
                IElement element = this.createElement(IElement.Type.PRODUCT, attributes);
                if (++this.level == 2) {
                    Release.this.elements.put(element, element);
                    this.parent = element;
                } else {
                    this.parent.getChildren().add(element);
                }
            } else if (Release.PLUGIN_TAG.equalsIgnoreCase(qName)) {
                if (this.level == 0) {
                    return;
                }
                IElement element = this.createElement(IElement.Type.PLUGIN, attributes);
                if (++this.level == 2) {
                    Release.this.elements.put(element, element);
                    this.parent = element;
                } else {
                    this.parent.getChildren().add(element);
                }
            }
        }

        private IElement createElement(IElement.Type type, Attributes attributes) throws SAXException {
            String name = this.getString(attributes, Release.NAME_ATTRIBUTE);
            Version version = new Version(this.getString(attributes, Release.VERSION_ATTRIBUTE));
            boolean isFragment = "true".equals(this.getString(attributes, Release.FRAGMENT_ATTRIBUTE));
            Element element = new Element(type, name, version, isFragment);
            String license = this.getString(attributes, Release.LICENSE_ATTRIBUTE);
            if ("true".equals(license)) {
                element.setLicenseFeature(true);
            }
            return element;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (Release.FEATURE_TAG.equalsIgnoreCase(qName) || Release.PLUGIN_TAG.equalsIgnoreCase(qName) || Release.PRODUCT_TAG.equalsIgnoreCase(qName)) {
                --this.level;
            }
        }

        private String getString(Attributes attributes, String name) throws SAXException {
            String value = attributes.getValue(name);
            if (value != null || Release.LICENSE_ATTRIBUTE.equals(name) || Release.FRAGMENT_ATTRIBUTE.equals(name)) {
                return value;
            }
            throw new SAXException("Illegal value for " + name);
        }

        public void error(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 2);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 2);
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 1);
        }

        private void addMarker(SAXParseException e, int severity) {
            try {
                Markers.addMarker((IResource)Release.this.file, e.getMessage(), severity, e.getLineNumber());
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }
    }
}

