/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.provider;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.predicates.AndPredicate;
import org.eclipse.oomph.predicates.NamePredicate;
import org.eclipse.oomph.predicates.NaturePredicate;
import org.eclipse.oomph.predicates.PredicatesFactory;
import org.eclipse.oomph.predicates.RepositoryPredicate;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.projectconfig.ExclusionPredicate;
import org.eclipse.oomph.projectconfig.InclusionPredicate;
import org.eclipse.oomph.projectconfig.PreferenceFilter;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.ProjectConfigFactory;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.provider.Messages;
import org.eclipse.oomph.projectconfig.provider.ProjectConfigEditPlugin;
import org.eclipse.oomph.projectconfig.util.ProjectConfigUtil;

public class ProjectItemProvider
extends ModelElementItemProvider {
    private static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private static final Class<?> IWORKBENCH_ADAPTER_CLASS;
    private static final Method GET_IMAGE_DESCRIPTOR_METHOD;
    private References references;
    private static final Set<String> IGNORE_NAME_COMPONENTS;
    private static final Map<String, String> ACRYONYMS;

    static {
        Class workbenchAdapterClass = null;
        Method method = null;
        try {
            workbenchAdapterClass = CommonPlugin.loadClass((String)"org.eclipse.ui.ide", (String)"org.eclipse.ui.model.IWorkbenchAdapter");
            method = workbenchAdapterClass.getMethod("getImageDescriptor", Object.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IWORKBENCH_ADAPTER_CLASS = workbenchAdapterClass;
        GET_IMAGE_DESCRIPTOR_METHOD = method;
        IGNORE_NAME_COMPONENTS = new HashSet<String>(Arrays.asList("org", "eclipse", "com"));
        ACRYONYMS = new HashMap<String, String>();
        ACRYONYMS.put("jdt", "JDT");
        ACRYONYMS.put("pde", "PDE");
        ACRYONYMS.put("ui", "UI");
        ACRYONYMS.put("api", "API");
        ACRYONYMS.put("ltk", "LTK");
        ACRYONYMS.put("gmf", "GMF");
    }

    public ProjectItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPreferenceNodePropertyDescriptor(object);
            this.addPreferenceProfileReferencesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPreferenceNodePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_preferenceNode_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_preferenceNode_feature", "_UI_Project_type"), (EStructuralFeature)ProjectConfigPackage.Literals.PROJECT__PREFERENCE_NODE, true, false, true, null, null, null));
    }

    protected void addPreferenceProfileReferencesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_preferenceProfileReferences_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_preferenceProfileReferences_feature", "_UI_Project_type"), (EStructuralFeature)ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILE_REFERENCES, true, false, true, null, null, null){
            IItemLabelProvider labelProvider;
            {
                this.labelProvider = new IItemLabelProvider(){

                    public String getText(Object object) {
                        String name;
                        PreferenceNode preferenceNode;
                        PreferenceProfile preferenceProfile;
                        Project project;
                        Object result = itemDelegator.getText(object);
                        if (object instanceof PreferenceProfile && (project = (preferenceProfile = (PreferenceProfile)object).getProject()) != null && (preferenceNode = project.getPreferenceNode()) != null && (name = preferenceNode.getName()) != null) {
                            result = (String)result + " - " + name;
                        }
                        return result;
                    }

                    public Object getImage(Object object) {
                        return itemDelegator.getImage(object);
                    }
                };
            }

            public IItemLabelProvider getLabelProvider(Object object) {
                return this.labelProvider;
            }
        });
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public boolean hasChildren(Object object) {
        return this.hasChildren(object, false);
    }

    public Object getImage(Object object) {
        String name;
        Project project = (Project)object;
        PreferenceNode preferenceNode = project.getPreferenceNode();
        if (preferenceNode != null && (name = preferenceNode.getName()) != null) {
            IProject iProject = WORKSPACE_ROOT.getProject(name);
            try {
                Object adapter = iProject.getAdapter(IWORKBENCH_ADAPTER_CLASS);
                if (adapter != null) {
                    return GET_IMAGE_DESCRIPTOR_METHOD.invoke(adapter, iProject);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Project"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String name;
        Project project = (Project)object;
        PreferenceNode preferenceNode = project.getPreferenceNode();
        String label = Messages.ProjectItemProvider_Invalid_label;
        if (preferenceNode != null && (name = preferenceNode.getName()) != null) {
            label = name;
        }
        return label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Project.class)) {
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public void notifyChangedFoo(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Project.class)) {
            case 2: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public Collection<?> getChildren(Object object) {
        ArrayList<References> result = new ArrayList<References>(super.getChildren(object));
        Project project = (Project)object;
        if (this.references == null) {
            this.references = new References(this.adapterFactory, Messages.ProjectItemProvider_References_label, this.getResourceLocator().getImage("full/obj16/OutgoingLinks"), project);
        }
        this.references.update();
        result.add(this.references);
        return result;
    }

    protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        if (operation == 4) {
            return this.references.createCommand((Object)this.references, domain, DragAndDropCommand.class, new CommandParameter((Object)this.references, (Object)new DragAndDropCommand.Detail(location, operations, operation), collection));
        }
        return super.createPrimaryDragAndDropCommand(domain, owner, location, operations, operation, collection);
    }

    private String[] getRootComponents(PreferenceNode preferenceNode, StringBuilder qualifiedPreferenceNodeName) {
        String[] rootNameComponents = null;
        String[] stringArray = preferenceNode.getRelativePath().segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String preferenceNodeName = stringArray[n2];
            String[] nameComponents = URI.decode((String)preferenceNodeName).split("\\.");
            int start = 0;
            if (rootNameComponents == null) {
                rootNameComponents = nameComponents;
                while (start < nameComponents.length) {
                    if (!IGNORE_NAME_COMPONENTS.contains(nameComponents[start])) break;
                    ++start;
                }
            }
            int j = start;
            while (j < nameComponents.length) {
                String nameComponent;
                String acronym;
                if (qualifiedPreferenceNodeName.length() > 0) {
                    qualifiedPreferenceNodeName.append(' ');
                }
                if ((acronym = ACRYONYMS.get(nameComponent = nameComponents[j])) != null) {
                    qualifiedPreferenceNodeName.append(acronym);
                } else {
                    int length = nameComponent.length();
                    if (length >= 1) {
                        qualifiedPreferenceNodeName.append(Character.toUpperCase(nameComponent.charAt(0)));
                        qualifiedPreferenceNodeName.append(nameComponent, 1, length);
                    }
                }
                ++j;
            }
            ++n2;
        }
        return rootNameComponents;
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        PreferenceFilter preferenceFilter;
        PreferenceProfile preferenceProfile;
        String[] rootNameComponents;
        StringBuilder qualifiedPreferenceNodeName;
        Project project = (Project)object;
        Map unmanagedPreferenceNodes = ProjectConfigUtil.getUnmanagedPreferenceNodes((Project)project);
        for (Map.Entry entry : unmanagedPreferenceNodes.entrySet()) {
            PreferenceNode preferenceNode = (PreferenceNode)entry.getKey();
            Set properties = (Set)entry.getValue();
            qualifiedPreferenceNodeName = new StringBuilder();
            rootNameComponents = this.getRootComponents(preferenceNode, qualifiedPreferenceNodeName);
            preferenceProfile = ProjectConfigFactory.eINSTANCE.createPreferenceProfile();
            if (qualifiedPreferenceNodeName.length() > 0) {
                preferenceProfile.setName(qualifiedPreferenceNodeName.toString());
            }
            preferenceFilter = ProjectConfigFactory.eINSTANCE.createPreferenceFilter();
            preferenceFilter.setPreferenceNode(preferenceNode);
            preferenceProfile.getPreferenceFilters().add((Object)preferenceFilter);
            EList realProperties = preferenceNode.getProperties();
            int realSize = realProperties.size();
            int targetSize = properties.size();
            if (realSize != targetSize) {
                if (realSize - targetSize > realSize / 2) {
                    preferenceFilter.setInclusions(Pattern.compile(this.getPattern(properties)));
                } else {
                    HashSet<Property> inverse = new HashSet<Property>((Collection<Property>)realProperties);
                    inverse.removeAll(properties);
                    preferenceFilter.setExclusions(Pattern.compile(this.getPattern(inverse)));
                }
            }
            AndPredicate andPredicate = this.createAndPredicate(project, rootNameComponents);
            preferenceProfile.getPredicates().add((Object)andPredicate);
            newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILES, preferenceProfile));
        }
        Map inconsistentPreferenceNodes = ProjectConfigUtil.getInconsistentPreferenceNodes((Project)project);
        for (Map.Entry entry : inconsistentPreferenceNodes.entrySet()) {
            PreferenceNode preferenceNode = (PreferenceNode)entry.getKey();
            qualifiedPreferenceNodeName = new StringBuilder();
            rootNameComponents = this.getRootComponents(preferenceNode, qualifiedPreferenceNodeName);
            preferenceProfile = ProjectConfigFactory.eINSTANCE.createPreferenceProfile();
            if (qualifiedPreferenceNodeName.length() > 0) {
                preferenceProfile.setName(qualifiedPreferenceNodeName.toString());
            }
            preferenceFilter = ProjectConfigFactory.eINSTANCE.createPreferenceFilter();
            preferenceFilter.setPreferenceNode(preferenceNode);
            preferenceProfile.getPreferenceFilters().add((Object)preferenceFilter);
            preferenceFilter.setInclusions(Pattern.compile(this.getPattern(((Map)entry.getValue()).keySet())));
            AndPredicate andPredicate = this.createAndPredicate(project, rootNameComponents);
            NamePredicate namePredicate = PredicatesFactory.eINSTANCE.createNamePredicate();
            namePredicate.setPattern(project.getPreferenceNode().getName().replace(".", "\\."));
            andPredicate.getOperands().add((Object)namePredicate);
            preferenceProfile.getPredicates().add((Object)andPredicate);
            newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILES, preferenceProfile));
        }
        this.collectNewChildDescriptorsGen(newChildDescriptors, object);
    }

    private AndPredicate createAndPredicate(Project project, String[] rootNameComponents) {
        AndPredicate andPredicate = PredicatesFactory.eINSTANCE.createAndPredicate();
        RepositoryPredicate repositoryPredicate = PredicatesFactory.eINSTANCE.createRepositoryPredicate();
        IProject iProject = ProjectConfigUtil.getProject((Project)project);
        repositoryPredicate.setProject(iProject);
        andPredicate.getOperands().add((Object)repositoryPredicate);
        try {
            String[] natureIds = iProject.getDescription().getNatureIds();
            int bestMatchLength = 0;
            String bestNatureId = null;
            String[] stringArray = natureIds;
            int n = natureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                String[] natureComponents = natureId.split("\\.");
                int index = 0;
                while (index < natureComponents.length && index < rootNameComponents.length) {
                    if (!rootNameComponents[index].equals(natureComponents[index])) break;
                    ++index;
                }
                if (bestMatchLength < index) {
                    bestMatchLength = index;
                    bestNatureId = natureId;
                }
                ++n2;
            }
            if (bestMatchLength >= 3) {
                NaturePredicate naturePredicate = PredicatesFactory.eINSTANCE.createNaturePredicate();
                naturePredicate.setNature(bestNatureId);
                andPredicate.getOperands().add((Object)naturePredicate);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return andPredicate;
    }

    private String getPattern(Collection<Property> properties) {
        StringBuilder pattern = new StringBuilder();
        for (Property property : properties) {
            String name = property.getName();
            name = name.replace(".", "\\.");
            if (pattern.length() != 0) {
                pattern.append('|');
            }
            pattern.append(name);
        }
        return pattern.toString();
    }

    private String getNamePattern(Collection<String> properties) {
        StringBuilder pattern = new StringBuilder();
        for (String name : properties) {
            name = name.replace(".", "\\.");
            if (pattern.length() != 0) {
                pattern.append('|');
            }
            pattern.append(name);
        }
        return pattern.toString();
    }

    protected void collectNewChildDescriptorsGen(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILES, ProjectConfigFactory.eINSTANCE.createPreferenceProfile()));
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        PreferenceFilter preferenceFilter;
        PreferenceNode preferenceNode;
        PreferenceProfile preferenceProfile;
        EList preferenceFilters;
        Object text = super.getCreateChildText(owner, feature, child, selection);
        if (child instanceof PreferenceProfile && !(preferenceFilters = (preferenceProfile = (PreferenceProfile)child).getPreferenceFilters()).isEmpty() && (preferenceNode = (preferenceFilter = (PreferenceFilter)preferenceFilters.get(0)).getPreferenceNode()) != null) {
            text = (String)text + Messages.ProjectItemProvider_For_message_part + PreferencesFactory.eINSTANCE.convertURI(preferenceNode.getRelativePath());
        }
        return text;
    }

    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection<?> collection) {
        return new CreateChildCommand(domain, owner, feature, value, index, collection, (CreateChildCommand.Helper)this){
            private CompoundCommand command;

            /*
             * WARNING - void declaration
             */
            public void execute() {
                super.execute();
                if (this.child instanceof PreferenceProfile) {
                    PreferenceProfile preferenceProfile = (PreferenceProfile)this.child;
                    Project project = preferenceProfile.getProject();
                    WorkspaceConfiguration workspaceConfiguration = project.getConfiguration();
                    for (PreferenceFilter preferenceFilter : preferenceProfile.getPreferenceFilters()) {
                        void var13_26;
                        LinkedHashMap<PreferenceFilter, LinkedHashSet<Property>> incomingCollisions = new LinkedHashMap<PreferenceFilter, LinkedHashSet<Property>>();
                        LinkedHashMap<PreferenceFilter, LinkedHashSet<Property>> outgoingCollisions = new LinkedHashMap<PreferenceFilter, LinkedHashSet<Property>>();
                        URI preferenceFilterNodeRelativePath = preferenceFilter.getPreferenceNode().getRelativePath();
                        for (Property property : preferenceFilter.getProperties()) {
                            Iterator managingProject;
                            URI relativePath = property.getRelativePath();
                            for (PreferenceProfile preferenceProfileReference : project.getPreferenceProfileReferences()) {
                                Property managingProperty = preferenceProfileReference.getProperty(relativePath);
                                if (managingProperty == null) continue;
                                for (PreferenceFilter preferenceFilterReference : preferenceProfileReference.getPreferenceFilters()) {
                                    if (!preferenceFilterReference.getPreferenceNode().getRelativePath().equals(preferenceFilterNodeRelativePath)) continue;
                                    LinkedHashSet<Property> properties = (LinkedHashSet<Property>)incomingCollisions.get(preferenceFilterReference);
                                    if (properties == null) {
                                        properties = new LinkedHashSet<Property>();
                                        incomingCollisions.put(preferenceFilterReference, properties);
                                    }
                                    properties.add(property);
                                }
                            }
                            HashSet<Iterator> collidingProjects = new HashSet<Iterator>();
                            for (Project project2 : workspaceConfiguration.getProjects()) {
                                Property managingProperty;
                                if (project2 == project || !preferenceProfile.matches(WORKSPACE_ROOT.getProject(project2.getPreferenceNode().getName())) || (managingProperty = project2.getProperty(relativePath)) == null || (managingProject = workspaceConfiguration.getProject(managingProperty.getScope().getName())) == project) continue;
                                collidingProjects.add(managingProject);
                            }
                            for (Project project3 : collidingProjects) {
                                managingProject = project3.getPreferenceProfiles().iterator();
                                while (managingProject.hasNext()) {
                                    PreferenceProfile collidingPreferenceProfile = (PreferenceProfile)managingProject.next();
                                    for (PreferenceFilter collidingPreferenceFilter : collidingPreferenceProfile.getPreferenceFilters()) {
                                        if (!collidingPreferenceFilter.getPreferenceNode().getRelativePath().equals(preferenceFilterNodeRelativePath)) continue;
                                        LinkedHashSet<Property> properties = (LinkedHashSet<Property>)outgoingCollisions.get(collidingPreferenceFilter);
                                        if (properties == null) {
                                            properties = new LinkedHashSet<Property>();
                                            outgoingCollisions.put(collidingPreferenceFilter, properties);
                                        }
                                        properties.add(property);
                                    }
                                }
                            }
                        }
                        for (Map.Entry entry : incomingCollisions.entrySet()) {
                            if (this.command == null) {
                                this.command = new CompoundCommand();
                            }
                            PreferenceFilter collidingPreferenceFilter = (PreferenceFilter)entry.getKey();
                            PreferenceProfile collidingPreferenceProfile = collidingPreferenceFilter.getPreferenceProfile();
                            Project project4 = collidingPreferenceProfile.getProject();
                            Pattern pattern = Pattern.compile(ProjectItemProvider.this.getPattern((Collection)entry.getValue()));
                            PreferenceProfile exceptionalPreferenceProfile = ProjectConfigFactory.eINSTANCE.createPreferenceProfile();
                            exceptionalPreferenceProfile.setName(collidingPreferenceProfile.getName() + Messages.ProjectItemProvider_Exceptional_label);
                            PreferenceFilter exceptionalPreferenceFilter = ProjectConfigFactory.eINSTANCE.createPreferenceFilter();
                            exceptionalPreferenceFilter.setInclusions(pattern);
                            exceptionalPreferenceFilter.setPreferenceNode(collidingPreferenceFilter.getPreferenceNode());
                            exceptionalPreferenceProfile.getPreferenceFilters().add((Object)exceptionalPreferenceFilter);
                            AndPredicate exceptionalAndPredicate = PredicatesFactory.eINSTANCE.createAndPredicate();
                            InclusionPredicate exceptionalInclusionPredicate = ProjectConfigFactory.eINSTANCE.createInclusionPredicate();
                            exceptionalInclusionPredicate.getIncludedPreferenceProfiles().add((Object)collidingPreferenceProfile);
                            exceptionalAndPredicate.getOperands().add((Object)exceptionalInclusionPredicate);
                            ExclusionPredicate exceptionalExclusionPredicate = ProjectConfigFactory.eINSTANCE.createExclusionPredicate();
                            exceptionalExclusionPredicate.getExcludedPreferenceProfiles().add((Object)preferenceProfile);
                            exceptionalAndPredicate.getOperands().add((Object)exceptionalExclusionPredicate);
                            exceptionalPreferenceProfile.getPredicates().add((Object)exceptionalAndPredicate);
                            this.command.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)project4, (Object)ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILES, Collections.singletonList(exceptionalPreferenceProfile)));
                            Pattern exclusions = collidingPreferenceFilter.getExclusions();
                            exclusions = exclusions == null || exclusions.toString().length() == 0 ? pattern : Pattern.compile(exclusions.toString() + "|" + pattern.toString());
                            this.command.appendAndExecute(SetCommand.create((EditingDomain)this.domain, (Object)collidingPreferenceFilter, (Object)ProjectConfigPackage.Literals.PREFERENCE_FILTER__EXCLUSIONS, (Object)exclusions));
                        }
                        LinkedHashSet<String> union = new LinkedHashSet<String>();
                        LinkedHashSet<PreferenceProfile> excludedPreferenceProfiles = new LinkedHashSet<PreferenceProfile>();
                        LinkedHashMap exclusionCombinations = new LinkedHashMap();
                        for (Map.Entry entry : outgoingCollisions.entrySet()) {
                            LinkedHashSet<String> properties = new LinkedHashSet<String>();
                            for (Property property : (Set)entry.getValue()) {
                                String name = property.getName();
                                properties.add(name);
                                union.add(name);
                            }
                            LinkedHashSet<PreferenceFilter> filters = (LinkedHashSet<PreferenceFilter>)exclusionCombinations.get(properties);
                            if (filters == null) {
                                filters = new LinkedHashSet<PreferenceFilter>();
                                exclusionCombinations.put(properties, filters);
                            }
                            PreferenceFilter collidingPreferenceFilter = (PreferenceFilter)entry.getKey();
                            filters.add(collidingPreferenceFilter);
                            excludedPreferenceProfiles.add(collidingPreferenceFilter.getPreferenceProfile());
                        }
                        if (union.isEmpty()) continue;
                        String unionPattern = ProjectItemProvider.this.getNamePattern(union);
                        Pattern pattern = preferenceFilter.getExclusions();
                        if (pattern == null || pattern.toString().length() == 0) {
                            Pattern pattern2 = Pattern.compile(unionPattern);
                        } else {
                            Pattern pattern3 = Pattern.compile(pattern.toString() + "|" + unionPattern);
                        }
                        preferenceFilter.setExclusions((Pattern)var13_26);
                        if (this.command == null) {
                            this.command = new CompoundCommand();
                        }
                        PreferenceProfile exceptionalPreferenceProfile = ProjectConfigFactory.eINSTANCE.createPreferenceProfile();
                        exceptionalPreferenceProfile.setName(preferenceProfile.getName() + Messages.ProjectItemProvider_Exceptional_label);
                        PreferenceFilter exceptionalPreferenceFilter = ProjectConfigFactory.eINSTANCE.createPreferenceFilter();
                        exceptionalPreferenceFilter.setInclusions(Pattern.compile(unionPattern));
                        exceptionalPreferenceFilter.setPreferenceNode(preferenceFilter.getPreferenceNode());
                        exceptionalPreferenceProfile.getPreferenceFilters().add((Object)exceptionalPreferenceFilter);
                        AndPredicate exceptionalAndPredicate = PredicatesFactory.eINSTANCE.createAndPredicate();
                        ExclusionPredicate exceptionalExclusionPredicate = ProjectConfigFactory.eINSTANCE.createExclusionPredicate();
                        exceptionalExclusionPredicate.getExcludedPreferenceProfiles().addAll(excludedPreferenceProfiles);
                        exceptionalAndPredicate.getOperands().add((Object)exceptionalExclusionPredicate);
                        InclusionPredicate inclusionPredicate = ProjectConfigFactory.eINSTANCE.createInclusionPredicate();
                        inclusionPredicate.getIncludedPreferenceProfiles().add((Object)preferenceProfile);
                        exceptionalAndPredicate.getOperands().add((Object)inclusionPredicate);
                        exceptionalPreferenceProfile.getPredicates().add((Object)exceptionalAndPredicate);
                        this.command.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)project, (Object)ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILES, Collections.singletonList(exceptionalPreferenceProfile)));
                        int count = 0;
                        for (Map.Entry entry : exclusionCombinations.entrySet()) {
                            LinkedHashSet<String> properties = new LinkedHashSet<String>(union);
                            properties.removeAll((Collection)entry.getKey());
                            if (properties.isEmpty()) continue;
                            PreferenceProfile partialPreferenceProfile = ProjectConfigFactory.eINSTANCE.createPreferenceProfile();
                            partialPreferenceProfile.setName(preferenceProfile.getName() + Messages.ProjectItemProvider_Partial_label + ++count);
                            PreferenceFilter partialPreferenceFilter = ProjectConfigFactory.eINSTANCE.createPreferenceFilter();
                            partialPreferenceFilter.setInclusions(Pattern.compile(ProjectItemProvider.this.getNamePattern(properties)));
                            partialPreferenceFilter.setPreferenceNode(preferenceFilter.getPreferenceNode());
                            partialPreferenceProfile.getPreferenceFilters().add((Object)partialPreferenceFilter);
                            LinkedHashSet<String> projectNames = new LinkedHashSet<String>();
                            for (PreferenceFilter excludedPreferenceFilter : (Set)entry.getValue()) {
                                projectNames.add(excludedPreferenceFilter.getPreferenceProfile().getProject().getPreferenceNode().getName());
                            }
                            for (String projectName : projectNames) {
                                NamePredicate namePredicate = PredicatesFactory.eINSTANCE.createNamePredicate();
                                namePredicate.setPattern(projectName.replace(".", "\\."));
                                partialPreferenceProfile.getPredicates().add((Object)namePredicate);
                            }
                            this.command.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)project, (Object)ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILES, Collections.singletonList(partialPreferenceProfile)));
                        }
                    }
                }
                if (this.command != null) {
                    HashSet combinedAffectedObjects = new HashSet(this.affectedObjects);
                    combinedAffectedObjects.addAll(this.command.getAffectedObjects());
                    this.affectedObjects = combinedAffectedObjects;
                }
            }

            public void undo() {
                if (this.command != null) {
                    this.command.undo();
                }
                super.undo();
                HashSet combinedAffectedObjects = new HashSet(this.affectedObjects);
                combinedAffectedObjects.addAll(this.command.getAffectedObjects());
                this.affectedObjects = combinedAffectedObjects;
            }

            public void redo() {
                super.redo();
                if (this.command != null) {
                    this.command.redo();
                }
                HashSet combinedAffectedObjects = new HashSet(this.affectedObjects);
                combinedAffectedObjects.addAll(this.command.getAffectedObjects());
                this.affectedObjects = combinedAffectedObjects;
            }
        };
    }

    public ResourceLocator getResourceLocator() {
        return ProjectConfigEditPlugin.INSTANCE;
    }

    private class References
    extends ItemProvider
    implements IEditingDomainItemProvider {
        Project project;
        Map<PreferenceProfile, IWrapperItemProvider> wrappers;

        public References(AdapterFactory adapterFactory, String text, Object image, Project project) {
            super(adapterFactory, text, image, (Object)project);
            this.wrappers = new HashMap<PreferenceProfile, IWrapperItemProvider>();
            this.project = project;
        }

        public void update() {
            ArrayList<IWrapperItemProvider> children = new ArrayList<IWrapperItemProvider>();
            EList referentProjects = this.project.getPreferenceProfileReferences();
            int i = 0;
            int size = referentProjects.size();
            while (i < size) {
                PreferenceProfile project = (PreferenceProfile)referentProjects.get(i);
                IWrapperItemProvider wrapper = this.wrap(i, project);
                children.add(wrapper);
                ++i;
            }
            ECollections.setEList((EList)this.getChildren(), children);
        }

        private IWrapperItemProvider wrap(int i, PreferenceProfile preferenceProfile) {
            Object wrapper = this.wrappers.get(preferenceProfile);
            if (wrapper == null) {
                wrapper = new DelegatingWrapperItemProvider(preferenceProfile, this.project, (EStructuralFeature)ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILE_REFERENCES, i, this.adapterFactory){

                    public Object getParent(Object object) {
                        return References.this;
                    }

                    public String getText(Object object) {
                        String name;
                        PreferenceNode preferenceNode;
                        Object result = super.getText(object);
                        PreferenceProfile preferenceProfile = (PreferenceProfile)this.value;
                        Project project = preferenceProfile.getProject();
                        if (project != null && (preferenceNode = project.getPreferenceNode()) != null && (name = preferenceNode.getName()) != null) {
                            result = (String)result + " - " + name;
                        }
                        return result;
                    }

                    public Object getImage(Object object) {
                        Object image = super.getImage(object);
                        ArrayList<Object> images = new ArrayList<Object>(2);
                        images.add(image);
                        images.add(EMFEditPlugin.INSTANCE.getImage("full/ovr16/ControlledObject"));
                        image = new ComposedImage(images);
                        return image;
                    }

                    public boolean hasChildren(Object object) {
                        return false;
                    }

                    public Collection<?> getChildren(Object object) {
                        return Collections.emptyList();
                    }

                    public void notifyChanged(Notification notification) {
                        if (notification instanceof IViewerNotification && ((IViewerNotification)notification).isLabelUpdate()) {
                            super.notifyChanged(notification);
                        }
                    }
                };
                this.wrappers.put(preferenceProfile, (IWrapperItemProvider)wrapper);
            } else {
                wrapper.setIndex(i);
            }
            return wrapper;
        }

        public Command createCommand(Object object, EditingDomain editingDomain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
            final Collection originalCollection = commandParameter.getCollection();
            commandParameter = ProjectItemProvider.this.unwrapCommandValues(commandParameter, commandClass);
            Collection collection = commandParameter.getCollection();
            if (commandClass == RemoveCommand.class) {
                if (this.project.getPreferenceProfileReferences().containsAll(collection)) {
                    return new RemoveCommand(editingDomain, (EObject)this.project, (EStructuralFeature)ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILE_REFERENCES, collection){

                        public void doExecute() {
                            super.doExecute();
                            References.this.update();
                            this.affectedObjects = Collections.singleton(References.this);
                        }

                        public void doUndo() {
                            super.doUndo();
                            References.this.update();
                            this.affectedObjects = Collections.singleton(References.this);
                        }

                        public void doRedo() {
                            super.doRedo();
                            References.this.update();
                            this.affectedObjects = Collections.singleton(References.this);
                        }
                    };
                }
            } else {
                if (commandClass == AddCommand.class && collection != null) {
                    final ArrayList<IWrapperItemProvider> wrappers = new ArrayList<IWrapperItemProvider>();
                    for (Object value : collection) {
                        if (value instanceof PreferenceProfile) {
                            wrappers.add(this.wrap(-1, (PreferenceProfile)value));
                            continue;
                        }
                        return UnexecutableCommand.INSTANCE;
                    }
                    return new AddCommand(editingDomain, (EObject)this.project, (EStructuralFeature)ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILE_REFERENCES, collection){

                        public void doExecute() {
                            super.doExecute();
                            References.this.update();
                            this.affectedObjects = wrappers;
                        }

                        public void doUndo() {
                            super.doUndo();
                            References.this.update();
                            this.affectedObjects = Collections.singleton(References.this);
                        }

                        public void doRedo() {
                            super.doRedo();
                            References.this.update();
                            this.affectedObjects = wrappers;
                        }
                    };
                }
                if (commandClass == DragAndDropCommand.class) {
                    DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getFeature();
                    return new DragAndDropCommand(editingDomain, (Object)this, detail.location, detail.operations, detail.operation, commandParameter.getCollection()){

                        protected boolean prepareDropLinkOn() {
                            this.dragCommand = IdentityCommand.INSTANCE;
                            this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)((Object)References.this), (Object)ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILE_REFERENCES, (Collection)originalCollection);
                            return this.dropCommand.canExecute();
                        }
                    };
                }
            }
            return super.createCommand(object, editingDomain, commandClass, commandParameter);
        }
    }
}

