/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.impl;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.RepositoryPredicate;
import org.eclipse.oomph.predicates.impl.PredicateImpl;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.team.core.RepositoryProvider;

public class RepositoryPredicateImpl
extends PredicateImpl
implements RepositoryPredicate {
    protected static final IProject PROJECT_EDEFAULT = null;
    protected IProject project = PROJECT_EDEFAULT;
    protected static final String RELATIVE_PATH_PATTERN_EDEFAULT = null;
    protected String relativePathPattern = RELATIVE_PATH_PATTERN_EDEFAULT;
    private Pattern compiledPattern;

    protected RepositoryPredicateImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PredicatesPackage.Literals.REPOSITORY_PREDICATE;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject newProject) {
        IProject oldProject = this.project;
        this.project = newProject;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldProject, (Object)this.project));
        }
    }

    @Override
    public String getRelativePathPattern() {
        return this.relativePathPattern;
    }

    public void setRelativePathPatternGen(String newRelativePathPattern) {
        String oldRelativePathPattern = this.relativePathPattern;
        this.relativePathPattern = newRelativePathPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldRelativePathPattern, (Object)this.relativePathPattern));
        }
    }

    @Override
    public void setRelativePathPattern(String newRelativePathPattern) {
        this.setRelativePathPatternGen(newRelativePathPattern);
        this.compiledPattern = null;
    }

    private Pattern getCompiledPattern() {
        if (this.compiledPattern == null) {
            this.compiledPattern = this.getPattern(this.getRelativePathPattern());
        }
        return this.compiledPattern;
    }

    private String getRepoDirAbsolutePath(IProject project) {
        if (project != null) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider == null) {
                java.net.URI locationURI = project.getLocationURI();
                if (locationURI != null && "file".equals(locationURI.getScheme())) {
                    URI emfURI = URI.createURI((String)locationURI.toString());
                    File parent = new File(emfURI.toFileString()).getParentFile();
                    while (parent != null && parent.isDirectory()) {
                        File gitFolder = new File(parent, ".git");
                        if (new File(gitFolder, "index").exists()) {
                            return parent.toString();
                        }
                        parent = parent.getParentFile();
                    }
                }
            } else {
                try {
                    if (provider instanceof GitProvider) {
                        GitProvider gitProvider = (GitProvider)provider;
                        GitProjectData data = gitProvider.getData();
                        RepositoryMapping repositoryMapping = data.getRepositoryMapping((IResource)project);
                        File workTree = repositoryMapping.getWorkTree();
                        return workTree == null ? null : workTree.toString();
                    }
                }
                catch (NoClassDefFoundError gitProvider) {
                    // empty catch block
                }
                try {
                    Class<?> providerClass = provider.getClass();
                    Method getSVNWorkspaceRootMethod = providerClass.getMethod("getSVNWorkspaceRoot", new Class[0]);
                    Object svnWorkspaceRoot = getSVNWorkspaceRootMethod.invoke((Object)provider, new Object[0]);
                    Class<?> workspaceRootClass = svnWorkspaceRoot.getClass();
                    Method getRepositoryMethod = workspaceRootClass.getMethod("getRepository", new Class[0]);
                    Object repositoryLocation = getRepositoryMethod.invoke(svnWorkspaceRoot, new Object[0]);
                    Class<?> repositoryLocationClass = repositoryLocation.getClass();
                    Method getLocationMethod = repositoryLocationClass.getMethod("getLocation", new Class[0]);
                    Object location = getLocationMethod.invoke(repositoryLocation, new Object[0]);
                    return location == null ? null : location.toString();
                }
                catch (Throwable providerClass) {
                    try {
                        Class<?> providerClass2 = provider.getClass();
                        Method getRepositoryLocationMethod = providerClass2.getMethod("getRepositoryLocation", new Class[0]);
                        Object repositoryLocation = getRepositoryLocationMethod.invoke((Object)provider, new Object[0]);
                        Class<?> repositoryLocationClass = repositoryLocation.getClass();
                        Method getRepositoryRootUrlMethod = repositoryLocationClass.getMethod("getRepositoryRootUrl", new Class[0]);
                        Object respositoryRootURL = getRepositoryRootUrlMethod.invoke(repositoryLocation, new Object[0]);
                        return respositoryRootURL == null ? null : respositoryRootURL.toString();
                    }
                    catch (Throwable throwable) {
                        return "Unknown repo";
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean matches(IResource resource) {
        String repoDirAbsolutePath;
        if (resource == null) {
            return false;
        }
        String prototypeRepoDirAbsolutePath = this.getRepoDirAbsolutePath(this.getProject());
        if (!Objects.equals(prototypeRepoDirAbsolutePath, repoDirAbsolutePath = this.getRepoDirAbsolutePath(resource.getProject()))) {
            return false;
        }
        if (repoDirAbsolutePath != null && this.getRelativePathPattern() != null) {
            IPath location = resource.getLocation();
            if (location != null) {
                String projectLocation = location.toPortableString();
                repoDirAbsolutePath = repoDirAbsolutePath.replace(File.separatorChar, '/');
                String relativePath = StringUtil.removePrefix((String)projectLocation, (String[])new String[]{repoDirAbsolutePath});
                relativePath = StringUtil.removePrefix((String)relativePath, (String[])new String[]{"/"});
                if (this.getCompiledPattern().matcher(relativePath).matches()) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getProject();
            }
            case 2: {
                return this.getRelativePathPattern();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setProject((IProject)newValue);
                return;
            }
            case 2: {
                this.setRelativePathPattern((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setProject(PROJECT_EDEFAULT);
                return;
            }
            case 2: {
                this.setRelativePathPattern(RELATIVE_PATH_PATTERN_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return PROJECT_EDEFAULT == null ? this.project != null : !PROJECT_EDEFAULT.equals((Object)this.project);
            }
            case 2: {
                return RELATIVE_PATH_PATTERN_EDEFAULT == null ? this.relativePathPattern != null : !RELATIVE_PATH_PATTERN_EDEFAULT.equals(this.relativePathPattern);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (project: ");
        result.append(this.project);
        result.append(", relativePathPattern: ");
        result.append(this.relativePathPattern);
        result.append(')');
        return result.toString();
    }
}

