/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.smap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfo {
    private int _fileId;
    private String _fileName;
    private String _absoluteFileName;
    private TreeMap<Integer, List<LineInfo>> _lineInfos;

    public FileInfo(int fileId, String fileName, String absoluteFileName) {
        this._fileId = fileId;
        this._fileName = fileName;
        this._absoluteFileName = absoluteFileName;
        this._lineInfos = new TreeMap();
    }

    public void addLineInfo(LineInfo lineInfo) {
        Integer key = new Integer(lineInfo.getInputStartLine());
        List<LineInfo> lineInfosForInputStartLine = this._lineInfos.get(key);
        if (lineInfosForInputStartLine == null) {
            lineInfosForInputStartLine = new ArrayList<LineInfo>();
            this._lineInfos.put(key, lineInfosForInputStartLine);
        }
        lineInfosForInputStartLine.add(lineInfo);
    }

    public void addLineInfo(List<LineInfo> lineInfos) {
        Iterator<LineInfo> iter = lineInfos.iterator();
        while (iter.hasNext()) {
            this.addLineInfo(iter.next());
        }
    }

    public List<LineInfo> getLinesForInputStartLine(int intputStartLine) {
        return this._lineInfos.get(new Integer(intputStartLine));
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileInfo)) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)object;
        if (this._fileId != fileInfo._fileId) {
            return false;
        }
        if (this._absoluteFileName != null && !this._absoluteFileName.equals(fileInfo._absoluteFileName)) {
            return false;
        }
        if (!this._fileName.equals(fileInfo._fileName)) {
            return false;
        }
        TreeMap<Integer, List<LineInfo>> map = fileInfo._lineInfos;
        if (map.size() != this._lineInfos.size()) {
            return false;
        }
        for (Integer key : this._lineInfos.keySet()) {
            List<LineInfo> mapValue;
            List<LineInfo> value = this._lineInfos.get(key);
            if (value == null != ((mapValue = map.get(key)) == null)) {
                return false;
            }
            if (value == null || mapValue == null) {
                return true;
            }
            if (value.size() != mapValue.size()) {
                return false;
            }
            int idx = 0;
            while (idx < value.size()) {
                LineInfo listEntries2;
                LineInfo listEntries1 = value.get(idx);
                if (!listEntries1.equals(listEntries2 = mapValue.get(idx))) {
                    return false;
                }
                ++idx;
            }
        }
        return true;
    }

    public String getFileInfoDataAsString() {
        StringBuffer out = new StringBuffer();
        for (Integer inputStartLine : this._lineInfos.keySet()) {
            List<LineInfo> lineInfos = this._lineInfos.get(inputStartLine);
            int idx = 0;
            while (idx < lineInfos.size()) {
                LineInfo singleLineInfo = lineInfos.get(idx);
                out.append(inputStartLine + "#" + this._fileId);
                if (singleLineInfo.hasRepeatCount()) {
                    out.append(",");
                    out.append(singleLineInfo.getRepeatCount());
                }
                out.append(":");
                out.append(singleLineInfo.getOutputStartLine());
                if (singleLineInfo.hasOutputLineIncrement()) {
                    out.append("," + singleLineInfo.getOutputLineIncrement());
                }
                out.append("\n");
                ++idx;
            }
        }
        return out.toString();
    }

    public String toString() {
        return this.getFileInfoDataAsString();
    }

    public int getFileId() {
        return this._fileId;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getAbsoluteFileName() {
        return this._absoluteFileName;
    }

    public boolean hasLineInfos() {
        return !this._lineInfos.isEmpty();
    }

    public void optimizeLineInfos() {
        TreeMap<Integer, List<LineInfo>> optimizedLineInfos = new TreeMap<Integer, List<LineInfo>>();
        for (Integer key : this._lineInfos.keySet()) {
            List<LineInfo> listofLineInfos = this._lineInfos.get(key);
            if (listofLineInfos.size() <= 1) continue;
            List<LineInfo> optimizedSimliarLineInfos = this.optimizeListOfSimilarLineInfos(listofLineInfos);
            this._lineInfos.put(key, optimizedSimliarLineInfos);
        }
        Integer firstKey = this._lineInfos.firstKey();
        List<LineInfo> listofFirstLineInfos = this.cloneLineInfos(this._lineInfos.get(firstKey));
        LineInfo firstLineInfo = listofFirstLineInfos.get(0);
        optimizedLineInfos.put(firstKey, listofFirstLineInfos);
        Integer[] keys = this._lineInfos.keySet().toArray(new Integer[this._lineInfos.size()]);
        int idx = 1;
        while (idx < keys.length) {
            int newRepeatCount;
            int oldRepeatCount;
            Integer iterKey1 = keys[idx];
            List<LineInfo> iterKey1ListofLineInfos = this._lineInfos.get(iterKey1);
            LineInfo iterKey1LineInfo = iterKey1ListofLineInfos.get(0);
            Integer iterKey2 = keys[idx - 1];
            List<LineInfo> iterKey2ListofLineInfos = this._lineInfos.get(iterKey2);
            LineInfo iterKey2LineInfo = iterKey2ListofLineInfos.get(0);
            if (iterKey1LineInfo.isPreviousLineInfo(firstLineInfo)) {
                oldRepeatCount = firstLineInfo.getRepeatCount();
                newRepeatCount = oldRepeatCount == -1 ? 2 : oldRepeatCount + 1;
                firstLineInfo.setRepeatCount(newRepeatCount);
            } else if (iterKey1LineInfo.isPreviousLineInfo(iterKey2LineInfo)) {
                oldRepeatCount = firstLineInfo.getRepeatCount();
                newRepeatCount = oldRepeatCount == -1 ? 1 : oldRepeatCount + 1;
                firstLineInfo.setRepeatCount(newRepeatCount);
            } else {
                firstKey = iterKey1;
                listofFirstLineInfos = this.cloneLineInfos(this._lineInfos.get(firstKey));
                firstLineInfo = listofFirstLineInfos.get(0);
                optimizedLineInfos.put(firstKey, listofFirstLineInfos);
            }
            ++idx;
        }
        this._lineInfos = optimizedLineInfos;
    }

    private List<LineInfo> cloneLineInfos(List<LineInfo> listofLineInfos) {
        ArrayList<LineInfo> clonedList = new ArrayList<LineInfo>();
        int idx = 0;
        while (idx < listofLineInfos.size()) {
            LineInfo lineInfo = listofLineInfos.get(idx);
            LineInfo copiedLineInfo = lineInfo.clone();
            clonedList.add(copiedLineInfo);
            ++idx;
        }
        return clonedList;
    }

    private List<LineInfo> optimizeListOfSimilarLineInfos(List<LineInfo> listofLineInfos) {
        ArrayList<LineInfo> optimizedListOfSimilarLineInfos = new ArrayList<LineInfo>();
        LineInfo lineInfo = listofLineInfos.get(0);
        optimizedListOfSimilarLineInfos.add(lineInfo);
        for (LineInfo tmpLineInfo : listofLineInfos) {
            if (lineInfo.equals(tmpLineInfo) || optimizedListOfSimilarLineInfos.contains(tmpLineInfo)) continue;
            optimizedListOfSimilarLineInfos.add(tmpLineInfo);
        }
        return optimizedListOfSimilarLineInfos;
    }

    protected boolean isEqualTo(String fileName, String absoluteFileName) {
        return this._fileName.equals(fileName) && this._absoluteFileName.equals(absoluteFileName);
    }
}

