/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.smap;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.AbstractSmapGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.FileInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfoCollector;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineNumberProvider;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.SmapStratum;

public class RoleSmapGenerator
extends AbstractSmapGenerator {
    public RoleSmapGenerator(TypeDeclaration type) {
        super(type);
    }

    public char[] generate() {
        for (SmapStratum stratum : this._strata) {
            if (!stratum.getStratumName().equals("OTJ")) continue;
            return this.generateOTJSmap(stratum);
        }
        return null;
    }

    private char[] generateOTJSmap(SmapStratum stratum) {
        LineInfoCollector lineInfoCollector = new LineInfoCollector();
        if (this.generatePartialOTJSmap(stratum, lineInfoCollector)) {
            return this.getSMAP().toCharArray();
        }
        this.fillSmap(stratum, lineInfoCollector);
        return this.getSMAP().toCharArray();
    }

    public boolean generatePartialOTJSmap(SmapStratum stratum, LineInfoCollector lineInfoCollector) {
        LineNumberProvider provider = this._type.getRoleModel().getLineNumberProvider();
        boolean isCompleted = false;
        if (!provider.containsLineInfos() && this._type.isRoleFile()) {
            FileInfo fileInfo = this.getOrCreateFileInfoForType(stratum, this._type.binding);
            int maxLineNumber = this._type.getRoleModel()._maxLineNumber;
            LineInfo lineInfo = new LineInfo(1, 1);
            lineInfo.setRepeatCount(maxLineNumber);
            fileInfo.addLineInfo(lineInfo);
            LineInfo stepOverLineInfo = new LineInfo(65534, 65534);
            fileInfo.addLineInfo(stepOverLineInfo);
            lineInfoCollector.storeLineInfo(stepOverLineInfo);
            LineInfo stepIntoLineInfo = new LineInfo(65533, 65533);
            fileInfo.addLineInfo(stepIntoLineInfo);
            lineInfoCollector.storeLineInfo(stepIntoLineInfo);
            isCompleted = true;
            return isCompleted;
        }
        for (ReferenceBinding copySrc : provider.getLineInfos().keySet()) {
            List<LineInfo> lineInfos = provider.getLineInfosForType(copySrc);
            FileInfo fileInfo = this.getOrCreateFileInfoForType(stratum, this.getCUType(copySrc));
            fileInfo.addLineInfo(lineInfos);
            lineInfoCollector.storeLineInfos(lineInfos);
        }
        return isCompleted;
    }

    private void fillSmap(SmapStratum stratum, LineInfoCollector lineInfoCollector) {
        FileInfo fileInfo;
        LineNumberProvider provider = this._type.getRoleModel().getLineNumberProvider();
        List<FileInfo> knownFileInfos = stratum.getFileInfos();
        if (this._type.isPurelyCopied && !knownFileInfos.isEmpty()) {
            fileInfo = knownFileInfos.get(0);
        } else {
            int startLine;
            fileInfo = this.getOrCreateFileInfoForType(stratum, this.getCUType(this._type.binding));
            int[] lineSeparatorPositions = this._type.compilationResult.lineSeparatorPositions;
            int idx = startLine = lineSeparatorPositions == null ? 1 : Util.getLineNumber(this._type.sourceStart, lineSeparatorPositions, 0, lineSeparatorPositions.length - 1);
            while (idx <= provider.getSourceEndLineNumber()) {
                if (!lineInfoCollector.existsLineInfoFor(idx)) {
                    LineInfo newLineInfo = new LineInfo(idx, idx);
                    fileInfo.addLineInfo(newLineInfo);
                    lineInfoCollector.storeLineInfo(newLineInfo);
                }
                ++idx;
            }
        }
        if (!lineInfoCollector.existsLineInfoFor(65534)) {
            LineInfo stepOverLineInfo = new LineInfo(65534, 65534);
            fileInfo.addLineInfo(stepOverLineInfo);
            lineInfoCollector.storeLineInfo(stepOverLineInfo);
        }
        if (!lineInfoCollector.existsLineInfoFor(65533)) {
            LineInfo stepIntoLineInfo = new LineInfo(65533, 65533);
            fileInfo.addLineInfo(stepIntoLineInfo);
            lineInfoCollector.storeLineInfo(stepIntoLineInfo);
        }
    }

    boolean isCopySrcRoleFile(ReferenceBinding copySrc) {
        if (copySrc.roleModel == null) {
            return false;
        }
        return copySrc.roleModel.isRoleFile();
    }
}

