/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TsuperReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.BytecodeTransformer;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.DeclaredLifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.AnchorMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;

public class ExplicitConstructorCall
extends Statement
implements InvocationSite {
    public Expression[] arguments;
    public Expression qualification;
    public MethodBinding binding;
    MethodBinding syntheticAccessor;
    public int accessMode;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public static final int ImplicitSuper = 1;
    public static final int Super = 2;
    public static final int This = 3;
    public static final int Tsuper = 4;
    private int chainTSuperMarkArgPos = -1;
    public VariableBinding[][] implicitArguments;
    public int typeArgumentsSourceStart;

    public ExplicitConstructorCall(int accessMode) {
        this.accessMode = accessMode;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            ((MethodScope)currentScope).isConstructorCall = true;
            if (this.qualification != null) {
                flowInfo = this.qualification.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            }
            if (this.arguments != null) {
                boolean analyseResources = currentScope.compilerOptions().analyseResourceLeaks;
                int i = 0;
                int max = this.arguments.length;
                while (i < max) {
                    flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                    if (analyseResources) {
                        flowInfo = FakedTrackingVariable.markPassedToOutside(currentScope, this.arguments[i], flowInfo, flowContext, false);
                    }
                    this.arguments[i].checkNPEbyUnboxing(currentScope, flowContext, flowInfo);
                    ++i;
                }
                this.analyseArguments(currentScope, flowContext, flowInfo, this.binding, this.arguments);
            }
            TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
            if (this.binding.thrownExceptions != Binding.NO_EXCEPTIONS) {
                if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                    thrownExceptions = currentScope.environment().convertToRawTypes(this.binding.thrownExceptions, true, true);
                }
                flowContext.checkExceptionHandlers(thrownExceptions, this.accessMode == 1 ? (ASTNode)((Object)currentScope.methodScope().referenceContext) : this, flowInfo, currentScope);
            }
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
            this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
            FlowInfo flowInfo2 = flowInfo;
            return flowInfo2;
        }
        finally {
            ((MethodScope)currentScope).isConstructorCall = false;
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        try {
            ((MethodScope)currentScope).isConstructorCall = true;
            int pc = codeStream.position;
            codeStream.aload_0();
            MethodBinding codegenBinding = this.binding.original();
            ReferenceBinding targetType = codegenBinding.declaringClass;
            if (targetType.erasure().id == 41 || targetType.isEnum()) {
                codeStream.aload_1();
                codeStream.iload_2();
            }
            if (targetType.isNestedType()) {
                codeStream.generateSyntheticEnclosingInstanceValues(currentScope, targetType, (this.bits & 0x2000) != 0 ? null : this.qualification, this);
            }
            this.generateArguments(this.binding, this.arguments, currentScope, codeStream);
            if (this.chainTSuperMarkArgPos > -1) {
                BytecodeTransformer.addChainingPlaceholder(currentScope, codeStream, this.chainTSuperMarkArgPos);
            }
            if (targetType.isNestedType()) {
                codeStream.generateSyntheticOuterArgumentValues(currentScope, targetType, this);
            }
            if (this.syntheticAccessor != null) {
                int i = 0;
                int max = this.syntheticAccessor.parameters.length - codegenBinding.parameters.length;
                while (i < max) {
                    codeStream.aconst_null();
                    ++i;
                }
                codeStream.invoke((byte)-73, this.syntheticAccessor, null);
            } else {
                codeStream.invoke((byte)-73, codegenBinding, null);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        finally {
            ((MethodScope)currentScope).isConstructorCall = false;
        }
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isImplicitSuper() {
        return this.accessMode == 1;
    }

    public boolean isTsuperAccess() {
        return this.accessMode == 4;
    }

    public boolean isSuperAccess() {
        return this.accessMode == 2 || this.accessMode == 1;
    }

    public boolean isTypeAccess() {
        return true;
    }

    void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        ReferenceBinding superTypeErasure = (ReferenceBinding)this.binding.declaringClass.erasure();
        if ((flowInfo.tagBits & 1) == 0 && superTypeErasure.isNestedType() && currentScope.enclosingSourceType().isLocalType()) {
            if (superTypeErasure.isLocalType()) {
                ((LocalTypeBinding)superTypeErasure).addInnerEmulationDependent(currentScope, this.qualification != null);
            } else {
                currentScope.propagateInnerEmulation(superTypeErasure, this.qualification != null);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            MethodBinding codegenBinding = this.binding.original();
            if (this.binding.isPrivate() && this.accessMode != 3) {
                ReferenceBinding declaringClass = codegenBinding.declaringClass;
                if ((declaringClass.tagBits & 0x10L) != 0L && currentScope.compilerOptions().complianceLevel >= 0x300000L) {
                    codegenBinding.tagBits |= 0x200L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)declaringClass).addSyntheticMethod(codegenBinding, this.isSuperAccess());
                    currentScope.problemReporter().needToEmulateMethodAccess(codegenBinding, this);
                }
            }
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ExplicitConstructorCall.printIndent(indent, output);
        if (this.qualification != null) {
            this.qualification.printExpression(0, output).append('.');
        }
        if (this.typeArguments != null) {
            output.append('<');
            int max = this.typeArguments.length - 1;
            int j = 0;
            while (j < max) {
                this.typeArguments[j].print(0, output);
                output.append(", ");
                ++j;
            }
            this.typeArguments[max].print(0, output);
            output.append('>');
        }
        if (this.accessMode == 4) {
            output.append("tsuper(");
        } else if (this.accessMode == 3) {
            output.append("this(");
        } else {
            output.append("super(");
        }
        if (this.arguments != null) {
            int len = this.arguments.length;
            if (this.accessMode == 4 && TSuperHelper.isMarkerArg(this.arguments[len - 1])) {
                --len;
            }
            int i = 0;
            while (i < len) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(");");
    }

    public void resolve(BlockScope scope) {
        MethodScope methodScope = scope.methodScope();
        try {
            AbstractMethodDeclaration methodDeclaration = methodScope.referenceMethod();
            if (methodDeclaration == null || !methodDeclaration.isConstructor() || ((ConstructorDeclaration)methodDeclaration).constructorCall != this) {
                int max;
                int i;
                scope.problemReporter().invalidExplicitConstructorCall(this);
                if (this.qualification != null) {
                    this.qualification.resolveType(scope);
                }
                if (this.typeArguments != null) {
                    i = 0;
                    max = this.typeArguments.length;
                    while (i < max) {
                        this.typeArguments[i].resolveType(scope, true);
                        ++i;
                    }
                }
                if (this.arguments != null) {
                    i = 0;
                    max = this.arguments.length;
                    while (i < max) {
                        this.arguments[i].resolveType(scope);
                        ++i;
                    }
                }
                return;
            }
            methodScope.isConstructorCall = true;
            ReferenceBinding receiverType = scope.enclosingReceiverType();
            boolean rcvHasError = false;
            if (this.isSuperAccess()) {
                receiverType = receiverType.superclass();
                TypeReference superclassRef = scope.referenceType().superclass;
                if (superclassRef != null && superclassRef.resolvedType != null && !superclassRef.resolvedType.isValidBinding()) {
                    rcvHasError = true;
                }
            }
            if (receiverType == null) {
                if (CharOperation.equals(scope.enclosingSourceType().compoundName, IOTConstants.ORG_OBJECTTEAMS_TEAM_OTCONFINED)) {
                    receiverType = scope.getJavaLangObject();
                } else {
                    scope.problemReporter().missingImplementation(this, "Detected null receiverType");
                }
            }
            if (receiverType != null) {
                if (this.accessMode == 2 && receiverType.erasure().id == 41) {
                    scope.problemReporter().cannotInvokeSuperConstructorInEnum(this, methodScope.referenceMethod().binding);
                }
                if (this.qualification != null) {
                    if (this.accessMode != 2) {
                        scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, receiverType);
                    }
                    if (!rcvHasError) {
                        ReferenceBinding enclosingType = receiverType.enclosingType();
                        if (enclosingType == null) {
                            scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, receiverType);
                            this.bits |= 0x2000;
                        } else {
                            TypeBinding qTb = this.qualification.resolveTypeExpecting(scope, enclosingType);
                            this.qualification.computeConversion(scope, qTb, qTb);
                        }
                    }
                }
            }
            if (this.typeArguments != null) {
                boolean argHasError = scope.compilerOptions().sourceLevel < 0x310000L;
                int length = this.typeArguments.length;
                this.genericTypeArguments = new TypeBinding[length];
                int i = 0;
                while (i < length) {
                    TypeReference typeReference = this.typeArguments[i];
                    this.genericTypeArguments[i] = typeReference.resolveType(scope, true);
                    if (this.genericTypeArguments[i] == null) {
                        argHasError = true;
                    }
                    if (argHasError && typeReference instanceof Wildcard) {
                        scope.problemReporter().illegalUsageOfWildcard(typeReference);
                    }
                    ++i;
                }
                if (argHasError) {
                    if (this.arguments != null) {
                        i = 0;
                        int max = this.arguments.length;
                        while (i < max) {
                            this.arguments[i].resolveType(scope);
                            ++i;
                        }
                    }
                    return;
                }
            }
            TypeBinding[] argumentTypes = Binding.NO_PARAMETERS;
            boolean argsContainCast = false;
            if (this.arguments != null) {
                boolean argHasError = false;
                int length = this.arguments.length;
                argumentTypes = new TypeBinding[length];
                int i = 0;
                while (i < length) {
                    Expression argument = this.arguments[i];
                    if (argument instanceof CastExpression) {
                        argument.bits |= 0x20;
                        argsContainCast = true;
                    }
                    if ((argumentTypes[i] = argument.resolveType(scope)) == null) {
                        argHasError = true;
                    }
                    ++i;
                }
                if (argHasError) {
                    MethodBinding closestMatch;
                    if (receiverType == null) {
                        return;
                    }
                    TypeBinding[] pseudoArgs = new TypeBinding[length];
                    int i2 = length;
                    while (--i2 >= 0) {
                        TypeBinding typeBinding = pseudoArgs[i2] = argumentTypes[i2] == null ? TypeBinding.NULL : argumentTypes[i2];
                    }
                    this.binding = scope.findMethod(receiverType, TypeConstants.INIT, pseudoArgs, this);
                    if (this.binding != null && !this.binding.isValidBinding() && (closestMatch = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                        if (closestMatch.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                            closestMatch = scope.environment().createParameterizedGenericMethod(closestMatch.original(), (RawTypeBinding)null);
                        }
                        this.binding = closestMatch;
                        MethodBinding closestMatchOriginal = closestMatch.original();
                        if (closestMatchOriginal.isOrEnclosedByPrivateType() && !scope.isDefinedInMethod(closestMatchOriginal)) {
                            closestMatchOriginal.modifiers |= 0x8000000;
                        }
                    }
                    return;
                }
            } else if (receiverType.erasure().id == 41) {
                argumentTypes = new TypeBinding[]{scope.getJavaLangString(), TypeBinding.INT};
            }
            if (receiverType == null) {
                return;
            }
            if (receiverType.isTeam() || receiverType.isRole()) {
                Dependencies.ensureBindingState(receiverType, 16);
            }
            if (this.accessMode == 4) {
                if (!receiverType.isRole()) {
                    scope.problemReporter().tsuperOutsideRole(methodScope.referenceMethod(), this, receiverType);
                    return;
                }
                RoleModel role = receiverType.roleModel;
                if (role.getImplicitSuperRole() == null) {
                    scope.problemReporter().tsuperCallWithoutTsuperRole(receiverType, this);
                    return;
                }
                if (role._refinesExtends) {
                    scope.problemReporter().tsuperCtorDespiteRefinedExtends(this, receiverType.superclass());
                    return;
                }
            }
            ThisReference receiver = null;
            switch (this.accessMode) {
                case 3: {
                    receiver = new ThisReference(this.sourceStart, this.sourceEnd);
                    break;
                }
                case 1: 
                case 2: {
                    receiver = new SuperReference(this.sourceStart, this.sourceEnd);
                    break;
                }
                case 4: {
                    receiver = new TsuperReference(this.sourceStart, this.sourceEnd);
                }
            }
            AnchorMapping anchorMapping = null;
            try {
                anchorMapping = AnchorMapping.setupNewMapping(receiver, this.arguments, scope);
                this.binding = scope.getConstructor(receiverType, argumentTypes, this);
                Binding tsuperMethod = null;
                TypeBinding[] tsuperArgs = null;
                if (!this.binding.isValidBinding()) {
                    if (this.accessMode == 4) {
                        int len = argumentTypes.length - 1;
                        TypeBinding[] strippedArgumentTypes = new TypeBinding[len];
                        System.arraycopy(argumentTypes, 0, strippedArgumentTypes, 0, len);
                        MethodBinding strippedMethod = scope.getConstructor(receiverType, strippedArgumentTypes, this);
                        if (strippedMethod.isValidBinding() && strippedMethod.copyInheritanceSrc != null) {
                            this.binding = strippedMethod;
                            argumentTypes = strippedArgumentTypes;
                            this.arguments = new Expression[len];
                            System.arraycopy(this.arguments, 0, this.arguments, 0, len);
                        }
                    } else if (this.accessingSuperteam(scope)) {
                        TeamModel teamModel = scope.enclosingSourceType().getTeamModel();
                        tsuperArgs = AstEdit.extendTypeArray(argumentTypes, teamModel.getMarkerInterfaceBinding(scope));
                        tsuperMethod = scope.getConstructor(receiverType, tsuperArgs, this);
                    }
                } else if (this.accessingSuperteam(scope) && methodDeclaration.binding != null && RoleTypeBinding.hasNonExternalizedRoleParameter(methodDeclaration.binding) && (tsuperMethod = DeclaredLifting.createCopyOrTurningCtor(scope, this.binding, argumentTypes, ((ConstructorDeclaration)methodDeclaration).needsLifting, new AstGenerator(this.sourceStart, this.sourceEnd))) != null) {
                    tsuperArgs = AstEdit.extendTypeArray(argumentTypes, ((MethodBinding)tsuperMethod).parameters[((MethodBinding)tsuperMethod).parameters.length - 1]);
                }
                if (tsuperMethod != null && tsuperMethod.isValidBinding() && tsuperMethod != this.binding && tsuperMethod != methodDeclaration.binding) {
                    this.updateFromTSuper(scope.enclosingSourceType().superclass(), tsuperArgs[tsuperArgs.length - 1]);
                    this.binding = tsuperMethod;
                    argumentTypes = tsuperArgs;
                }
                if (this.binding.problemId() == 1) {
                    argumentTypes = this.checkLiftingTeamCtor(scope, argumentTypes, (ConstructorDeclaration)methodDeclaration);
                }
            }
            catch (Throwable throwable) {
                AnchorMapping.removeCurrentMapping(anchorMapping);
                throw throwable;
            }
            AnchorMapping.removeCurrentMapping(anchorMapping);
            if (this.binding.isValidBinding()) {
                MethodBinding enclosingMethod;
                if (scope.enclosingSourceType().isRole() && !TSuperHelper.isTSuper(this.binding) && this.binding.declaringClass == scope.enclosingSourceType() && (enclosingMethod = methodDeclaration.binding) != null) {
                    this.chainTSuperMarkArgPos = enclosingMethod.parameters.length + enclosingMethod.declaringClass.depth() + 1;
                }
                if ((this.binding.tagBits & 0x80L) != 0L && !methodScope.enclosingSourceType().isAnonymousType()) {
                    scope.problemReporter().missingTypeInConstructor(this, this.binding);
                }
                if (this.isMethodUseDeprecated(this.binding, scope, this.accessMode != 1)) {
                    scope.problemReporter().deprecatedMethod(this.binding, this);
                }
                if (this.checkInvocationArguments(scope, null, receiverType, this.binding, this.arguments, argumentTypes, argsContainCast, this)) {
                    this.bits |= 0x10000;
                }
                if (this.binding.isOrEnclosedByPrivateType()) {
                    this.binding.original().modifiers |= 0x8000000;
                }
                if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
                    scope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = receiverType;
                }
                if (rcvHasError) {
                    return;
                }
                if (this.accessMode == 4) {
                    int len = this.binding.parameters.length;
                    this.binding.parameters = new TypeBinding[len - 1];
                    System.arraycopy(this.binding.parameters, 0, this.binding.parameters, 0, len - 1);
                    this.binding.declaringClass = receiverType.roleModel.getImplicitSuperRole().getBinding();
                }
                scope.problemReporter().invalidConstructor(this, this.binding);
            }
        }
        finally {
            methodScope.isConstructorCall = false;
        }
    }

    private boolean accessingSuperteam(BlockScope scope) {
        return this.isSuperAccess() && scope.enclosingSourceType().isTeam();
    }

    private TypeBinding[] checkLiftingTeamCtor(BlockScope scope, TypeBinding[] argumentTypes, ConstructorDeclaration ctorDecl) {
        if (!scope.referenceType().isTeam()) {
            return argumentTypes;
        }
        ReferenceBinding superTeam = scope.enclosingSourceType().superclass();
        MethodBinding[] ctors = superTeam.getMethods(TypeConstants.INIT);
        if (ctors != null) {
            int i = 0;
            while (i < ctors.length) {
                TypeBinding[] adjustedArgtypes;
                MethodBinding ctor = ctors[i];
                if (this.isChainingMatch(this.arguments, ctor.parameters)) {
                    if (this.accessMode == 3) {
                        MethodBinding newBinding = DeclaredLifting.createCopyOrTurningCtor(scope, ctor, argumentTypes, ctorDecl.needsLifting, new AstGenerator(this));
                        if (newBinding == null) break;
                        this.binding = newBinding;
                        break;
                    }
                } else if (this.isSuperAccess() && (adjustedArgtypes = this.getAdjustedArgTypes(scope.referenceType().getTeamModel(), scope, this.arguments, ctor.parameters, ctor)) != null) {
                    MethodBinding newBinding = DeclaredLifting.createCopyOrTurningCtor(scope, ctor, adjustedArgtypes, ctorDecl.needsLifting, new AstGenerator(this));
                    if (newBinding == null) break;
                    this.binding = newBinding;
                    TypeBinding markerType = this.binding.parameters[this.binding.parameters.length - 1];
                    this.updateFromTSuper(superTeam, markerType);
                    argumentTypes = AstEdit.extendTypeArray(argumentTypes, markerType);
                    break;
                }
                ++i;
            }
        }
        return argumentTypes;
    }

    private boolean isChainingMatch(Expression[] provided, TypeBinding[] expected) {
        if (provided == null) {
            return expected.length == 0;
        }
        if (provided.length != expected.length + 1) {
            return false;
        }
        int i = 0;
        while (i < expected.length) {
            if (!provided[i].resolvedType.isCompatibleWith(expected[i])) {
                return false;
            }
            ++i;
        }
        return TSuperHelper.isMarkerArg(provided[provided.length - 1]);
    }

    private TypeBinding[] getAdjustedArgTypes(TeamModel teamModel, BlockScope scope, Expression[] provided, TypeBinding[] expected, MethodBinding method) {
        if (provided == null) {
            if (expected.length == 0) {
                return new TypeBinding[0];
            }
            return null;
        }
        if (provided.length != expected.length) {
            return null;
        }
        TypeBinding[] adjustedArgtypes = new TypeBinding[expected.length + 1];
        int i = 0;
        while (i < expected.length) {
            adjustedArgtypes[i] = this.arguments[i].resolvedType;
            TypeBinding param = expected[i];
            TypeBinding arg = provided[i].resolvedType;
            if (!AnchorMapping.areTypesEqual(param, arg, method) && !arg.isCompatibleWith(param)) {
                if (TSuperHelper.isMarkerInterface(param)) {
                    return null;
                }
                TypeBinding roleType = TeamModel.getRoleToLiftTo(scope, arg, param, false, provided[i]);
                if (roleType == null) {
                    return null;
                }
            }
            ++i;
        }
        adjustedArgtypes[expected.length] = teamModel.markerInterface.binding;
        return adjustedArgtypes;
    }

    private void updateFromTSuper(ReferenceBinding superTeam, TypeBinding markerType) {
        CastExpression markerArg = TSuperHelper.createMarkerArgExpr(superTeam, new AstGenerator(this.sourceStart, this.sourceEnd));
        markerArg.resolvedType = markerType;
        this.arguments = AstEdit.extendExpressionArray(this.arguments, markerArg);
        this.accessMode = 4;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int depth) {
    }

    public void setFieldIndex(int depth) {
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int i;
            if (this.qualification != null) {
                this.qualification.traverse(visitor, scope);
            }
            if (this.typeArguments != null) {
                i = 0;
                int typeArgumentsLength = this.typeArguments.length;
                while (i < typeArgumentsLength) {
                    this.typeArguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.arguments != null) {
                i = 0;
                int argumentLength = this.arguments.length;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

